/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.util.CaseFinder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestCaseFinder {
    private static BufferedReader mk(String s) {
        return new BufferedReader(new StringReader(s));
    }

    private static String pr(List<Object[]> t) {
        StringBuilder b = new StringBuilder();
        b.append("{ ");
        boolean firstTime = true;
        for (Object[] p : t) {
            if (!firstTime) {
                b.append(", ");
            } else {
                firstTime = false;
            }
            b.append("{ \"").append(p[0]).append("\", \"").append(p[1]).append("\" }");
        }
        b.append("}");
        return b.toString();
    }

    private static boolean eq(List<Object[]> l1, List<Object[]> l2) {
        if (l1 == null || l2 == null) {
            return l1 == l2;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (Arrays.equals(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Nested
    public class NonParameterized {
        @Test
        void badDocLabel1() throws Exception {
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                CaseFinder.find(TestCaseFinder.mk("<<INPUT blah"), "", result);
            });
        }

        @Test
        void badDocLabel2() throws Exception {
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                CaseFinder.find(TestCaseFinder.mk("<<INPUT blah"), "kill-er", result);
            });
        }

        @Test
        void badSingleLineHeredoc() throws Exception {
            Assertions.assertThrows(IOException.class, () -> {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                CaseFinder.find(TestCaseFinder.mk("<<INPUTblah"), "foo", result);
            });
        }

        @Test
        void unterminatedHeredoc() throws Exception {
            Assertions.assertThrows(IOException.class, () -> {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                CaseFinder.find(TestCaseFinder.mk("<<INPUT"), "foo", result);
            });
        }
    }

    @Nested
    public static class SimpleCases {
        public static List<Object[]> cases() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            result.add(new Object[]{"", "foo", new Object[0][]});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT b", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT b\n", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT b\n\n", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\r<<OUTPUT b", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"// This is a test\n<<INPUT a\n\n\n<<OUTPUT b", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\nb\nOUTPUT", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\nb\nOUTPUT", "OUTPUT", new Object[][]{{"a", "b"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\nb\n\nOUTPUT", "OUTPUT", new Object[][]{{"a", "b\n"}}});
            result.add(new Object[]{"<<INPUT a\n<<OUTPUT\n\n  b  \n\nOUTPUT", "OUTPUT", new Object[][]{{"a", "\n  b  \n"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<INPUT c\n<<O d", "O", new Object[][]{{"a", "b"}, {"c", "d"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<F z\n<<INPUT c\n<<O d", "O", new Object[][]{{"a", "b"}, {"c", "d"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<F z\n<<INPUT c\n<<O d", "F", new Object[][]{{"a", "z"}}});
            result.add(new Object[]{"<<INPUT a\n<<O b\n<<F z\n<<INPUT\nc\nINPUT\n<<O d\n<<INPUT e", "INPUT", new Object[][]{{"a", null}, {"c", null}, {"e", null}}});
            return result;
        }

        @ParameterizedTest
        @MethodSource(value={"cases"})
        void output(String input, String label, Object[][] ex) throws Exception {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            CaseFinder.find(TestCaseFinder.mk(input), label, result);
            List<Object[]> expectedOutput = Arrays.asList(ex);
            Assertions.assertTrue((boolean)TestCaseFinder.eq(result, expectedOutput), (String)TestCaseFinder.pr(result));
        }
    }
}

