/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.message.MissingSchemaException;
import org.apache.avro.specific.TestRecordWithLogicalTypes;
import org.apache.avro.specific.TestRecordWithoutLogicalTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSpecificToFromByteArray {
    @Test
    void specificToFromByteBufferWithLogicalTypes() throws IOException {
        LocalTime t = LocalTime.now().truncatedTo(ChronoUnit.MILLIS);
        Instant instant = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        TestRecordWithLogicalTypes record = new TestRecordWithLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, LocalDate.now(), t, instant, new BigDecimal("123.45"), new BigDecimal(-23.456562323));
        ByteBuffer b = record.toByteBuffer();
        TestRecordWithLogicalTypes copy = TestRecordWithLogicalTypes.fromByteBuffer(b);
        Assertions.assertEquals((Object)((Object)record), (Object)((Object)copy));
    }

    @Test
    void specificToFromByteBufferWithoutLogicalTypes() throws IOException {
        TestRecordWithoutLogicalTypes record = new TestRecordWithoutLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, (int)System.currentTimeMillis() / 1000, (int)System.currentTimeMillis() / 1000, System.currentTimeMillis(), new Conversions.DecimalConversion().toBytes(new BigDecimal("123.45"), null, (LogicalType)LogicalTypes.decimal((int)9, (int)2)));
        ByteBuffer b = record.toByteBuffer();
        TestRecordWithoutLogicalTypes copy = TestRecordWithoutLogicalTypes.fromByteBuffer(b);
        Assertions.assertEquals((Object)((Object)record), (Object)((Object)copy));
    }

    @Test
    void specificByteArrayIncompatibleWithLogicalTypes() throws IOException {
        Assertions.assertThrows(MissingSchemaException.class, () -> {
            TestRecordWithoutLogicalTypes withoutLogicalTypes = new TestRecordWithoutLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, (int)System.currentTimeMillis() / 1000, (int)System.currentTimeMillis() / 1000, System.currentTimeMillis(), new Conversions.DecimalConversion().toBytes(new BigDecimal("123.45"), null, (LogicalType)LogicalTypes.decimal((int)9, (int)2)));
            ByteBuffer b = withoutLogicalTypes.toByteBuffer();
            TestRecordWithLogicalTypes.fromByteBuffer(b);
        });
    }

    @Test
    void specificByteArrayIncompatibleWithoutLogicalTypes() throws IOException {
        Assertions.assertThrows(MissingSchemaException.class, () -> {
            TestRecordWithLogicalTypes withLogicalTypes = new TestRecordWithLogicalTypes(true, 34, 35L, Float.valueOf(3.14f), 3019.34, null, LocalDate.now(), LocalTime.now(), Instant.now(), new BigDecimal("123.45"), new BigDecimal(-23.456562323));
            ByteBuffer b = withLogicalTypes.toByteBuffer();
            TestRecordWithoutLogicalTypes.fromByteBuffer(b);
        });
    }
}

