/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSpecificDatumReader {
    @Test
    void readMyData() throws IOException {
        EncoderFactory e_factory = new EncoderFactory().configureBufferSize(30);
        DecoderFactory factory = new DecoderFactory().configureDecoderBufferSize(30);
        MyReader reader = new MyReader();
        reader.setExpected(Schema.create((Schema.Type)Schema.Type.STRING));
        reader.setSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        ByteArrayOutputStream out = new ByteArrayOutputStream(30);
        BinaryEncoder encoder = e_factory.binaryEncoder((OutputStream)out, null);
        encoder.writeString(new Utf8("Hello"));
        encoder.flush();
        BinaryDecoder decoder = factory.binaryDecoder(out.toByteArray(), null);
        reader.getData().setFastReaderEnabled(false);
        MyData read = (MyData)reader.read(null, (Decoder)decoder);
        Assertions.assertNotNull((Object)read, (String)"MyReader.newInstanceFromString was not called");
        Assertions.assertEquals((Object)"Hello", (Object)read.getContent());
    }

    public static class MyReader
    extends SpecificDatumReader<MyData> {
        protected Class findStringClass(Schema schema) {
            return MyData.class;
        }

        protected Object newInstanceFromString(Class c, String s) {
            return new MyData(s);
        }
    }

    public static class MyData {
        private final String content;

        public MyData(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }
}

