/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestReflectDatumWithAnonymousInstances {
    private static Pojo pojo;

    @BeforeAll
    public static void init() {
        pojo = new Pojo(){
            {
                Person person = new Person(){
                    {
                        this.setAddress("Address");
                    }
                };
                this.setPerson(person);
                this.setTestEnum(TestEnum.V);
            }
        };
    }

    @Test
    void handleProperlyEnumInstances() throws IOException {
        byte[] output = this.serialize(pojo);
        Pojo deserializedPojo = this.deserialize(output);
        Assertions.assertEquals((Object)pojo, (Object)deserializedPojo);
        Assertions.assertTrue((boolean)deserializedPojo.getTestEnum().is_V());
    }

    private Pojo deserialize(byte[] input) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        ReflectData.AllowNull reflectData = ReflectData.AllowNull.get();
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader((ReflectData)reflectData);
        Schema schema = reflectData.getSchema(Pojo.class);
        reflectDatumReader.setSchema(schema);
        return (Pojo)reflectDatumReader.read(null, (Decoder)decoder);
    }

    private byte[] serialize(Pojo input) throws IOException {
        ReflectData.AllowNull reflectData = ReflectData.AllowNull.get();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, null);
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(Pojo.class, (ReflectData)reflectData);
        datumWriter.write((Object)input, (Encoder)encoder);
        encoder.flush();
        return outputStream.toByteArray();
    }

    private static class Pojo {
        private TestEnum testEnum;
        private Person person;

        private Pojo() {
        }

        public TestEnum getTestEnum() {
            return this.testEnum;
        }

        public void setTestEnum(TestEnum testEnum) {
            this.testEnum = testEnum;
        }

        public Person getPerson() {
            return this.person;
        }

        public void setPerson(Person person) {
            this.person = person;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Class<?> thisClass = this.getClass();
            while (thisClass.isAnonymousClass()) {
                thisClass = thisClass.getSuperclass();
            }
            Class<?> oClass = o.getClass();
            while (oClass.isAnonymousClass()) {
                oClass = oClass.getSuperclass();
            }
            if (thisClass != oClass) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            if (this.testEnum != pojo.testEnum) {
                return false;
            }
            return this.person != null ? this.person.equals(pojo.person) : pojo.person == null;
        }

        public int hashCode() {
            int result = this.testEnum != null ? this.testEnum.hashCode() : 0;
            result = 31 * result + (this.person != null ? this.person.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Pojo{testEnum=" + this.testEnum + ", person=" + this.person + "}";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum TestEnum {
        V{

            @Override
            public boolean is_V() {
                return true;
            }
        };


        public boolean is_V() {
            return false;
        }
    }

    private static class Person {
        private String name;
        private String address;

        private Person() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Class<?> thisClass = this.getClass();
            while (thisClass.isAnonymousClass()) {
                thisClass = thisClass.getSuperclass();
            }
            Class<?> oClass = o.getClass();
            while (oClass.isAnonymousClass()) {
                oClass = oClass.getSuperclass();
            }
            if (thisClass != oClass) {
                return false;
            }
            Person person = (Person)o;
            if (this.name != null ? !this.name.equals(person.name) : person.name != null) {
                return false;
            }
            return this.address != null ? this.address.equals(person.address) : person.address == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Person{name='" + this.name + "', address='" + this.address + "'}";
        }
    }
}

