/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.util.internal.JacksonUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;

public class TestReflectData {
    @Test
    void weakSchemaCaching() throws Exception {
        int numSchemas = 1000000;
        for (int i = 0; i < numSchemas; ++i) {
            Schema schema = Schema.createRecord((String)"schema", null, null, (boolean)false);
            schema.setFields(Collections.emptyList());
            ReflectData.get().getRecordState(new Object(), schema);
        }
        ReflectData.ClassAccessorData classData = (ReflectData.ClassAccessorData)ReflectData.ACCESSOR_CACHE.get(Object.class);
        System.gc();
        MatcherAssert.assertThat((String)"ReflectData cache should release references", (Object)classData.bySchema.size(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(numSchemas)));
    }

    @Test
    void genericProtocol() {
        Protocol protocol = ReflectData.get().getProtocol(FooBarProtocol.class);
        Schema recordSchema = ReflectData.get().getSchema(FooBarReflectiveRecord.class);
        MatcherAssert.assertThat((Object)protocol.getTypes(), (Matcher)Matchers.contains((Object[])new Schema[]{recordSchema}));
        MatcherAssert.assertThat(protocol.getMessages().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"store", "findById", "exists"}));
        Schema.Field storeArgument = (Schema.Field)((Protocol.Message)protocol.getMessages().get("store")).getRequest().getFields().get(0);
        MatcherAssert.assertThat((Object)storeArgument.schema(), (Matcher)Matchers.equalTo((Object)recordSchema));
        Schema.Field findByIdArgument = (Schema.Field)((Protocol.Message)protocol.getMessages().get("findById")).getRequest().getFields().get(0);
        MatcherAssert.assertThat((Object)findByIdArgument.schema(), (Matcher)Matchers.equalTo((Object)Schema.create((Schema.Type)Schema.Type.STRING)));
        Schema findByIdResponse = ((Protocol.Message)protocol.getMessages().get("findById")).getResponse();
        MatcherAssert.assertThat((Object)findByIdResponse, (Matcher)Matchers.equalTo((Object)recordSchema));
        Schema.Field existsArgument = (Schema.Field)((Protocol.Message)protocol.getMessages().get("exists")).getRequest().getFields().get(0);
        MatcherAssert.assertThat((Object)existsArgument.schema(), (Matcher)Matchers.equalTo((Object)Schema.create((Schema.Type)Schema.Type.STRING)));
    }

    @Test
    void createSchemaDefaultValue() {
        Meta meta = new Meta();
        this.validateSchema(meta);
        meta.f4 = 6535;
        this.validateSchema(meta);
    }

    private void validateSchema(Meta meta) {
        Schema schema = new ReflectData().setDefaultsGenerated(true).setDefaultGeneratedValue(Meta.class, (Object)meta).getSchema(Meta.class);
        String schemaString = schema.toString(true);
        Schema.Parser parser = new Schema.Parser();
        Schema cloneSchema = parser.parse(schemaString);
        Map testCases = JacksonUtils.objectToMap((Object)meta);
        for (Schema.Field field : cloneSchema.getFields()) {
            Assertions.assertEquals((Object)field.defaultVal(), testCases.get(field.name()), (String)("Invalid field " + field.name()));
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_8, max=JRE.JAVA_17, disabledReason="Doesn't work under JRE 21, no clue why")
    void nonStaticInnerClasses() {
        Assertions.assertThrows(AvroTypeException.class, () -> ReflectData.get().getSchema(Definition.class));
    }

    @Test
    void staticInnerClasses() {
        ReflectData.get().getSchema(Meta.class);
    }

    private static interface FooBarProtocol
    extends OtherProtocol<String>,
    CrudProtocol<FooBarReflectiveRecord, String> {
    }

    private static class FooBarReflectiveRecord {
        private String bar;
        private int baz;

        private FooBarReflectiveRecord() {
        }
    }

    static class Meta {
        public int f1 = 55;
        public int f4;
        public String f2 = "a-string";
        public List<String> f3 = Arrays.asList("one", "two", "three");

        Meta() {
        }
    }

    public class Definition {
        public Map<String, String> tokens;
    }

    static class User {
        public String first = "Avro";
        public String last = "Apache";

        User() {
        }
    }

    private static interface OtherProtocol<G> {
        public boolean exists(G var1);
    }

    private static interface CrudProtocol<R, I>
    extends OtherProtocol<I> {
        public void store(R var1);

        public R findById(I var1);
    }
}

