/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.NameValidator;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.AvroAlias;
import org.apache.avro.reflect.AvroAliases;
import org.apache.avro.reflect.AvroDefault;
import org.apache.avro.reflect.AvroDoc;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.avro.reflect.AvroMeta;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.DateAsLongEncoding;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.reflect.Union;
import org.apache.avro.util.Utf8;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;

public class TestReflect {
    EncoderFactory factory = new EncoderFactory();

    @Test
    void testVoid() {
        this.check(Void.TYPE, "\"null\"");
        this.check((Type)((Object)Void.class), "\"null\"");
    }

    @Test
    void testBoolean() {
        this.check(Boolean.TYPE, "\"boolean\"");
        this.check((Type)((Object)Boolean.class), "\"boolean\"");
    }

    @Test
    void testInt() {
        this.check(Integer.TYPE, "\"int\"");
        this.check((Type)((Object)Integer.class), "\"int\"");
    }

    @Test
    void testByte() {
        this.check(Byte.TYPE, "{\"type\":\"int\",\"java-class\":\"java.lang.Byte\"}");
        this.check((Type)((Object)Byte.class), "{\"type\":\"int\",\"java-class\":\"java.lang.Byte\"}");
    }

    @Test
    void testShort() {
        this.check(Short.TYPE, "{\"type\":\"int\",\"java-class\":\"java.lang.Short\"}");
        this.check((Type)((Object)Short.class), "{\"type\":\"int\",\"java-class\":\"java.lang.Short\"}");
    }

    @Test
    void testChar() {
        this.check(Character.TYPE, "{\"type\":\"int\",\"java-class\":\"java.lang.Character\"}");
        this.check((Type)((Object)Character.class), "{\"type\":\"int\",\"java-class\":\"java.lang.Character\"}");
    }

    @Test
    void testLong() {
        this.check(Long.TYPE, "\"long\"");
        this.check((Type)((Object)Long.class), "\"long\"");
    }

    @Test
    void testFloat() {
        this.check(Float.TYPE, "\"float\"");
        this.check((Type)((Object)Float.class), "\"float\"");
    }

    @Test
    void testDouble() {
        this.check(Double.TYPE, "\"double\"");
        this.check((Type)((Object)Double.class), "\"double\"");
    }

    @Test
    void string() {
        this.check("Foo", "\"string\"");
    }

    @Test
    void bytes() {
        this.check(ByteBuffer.allocate(0), "\"bytes\"");
        this.check(new byte[0], "{\"type\":\"bytes\",\"java-class\":\"[B\"}");
    }

    @Test
    void unionWithCollection() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"array\",\"items\":\"float\"}]");
        ReflectData data = ReflectData.get();
        Assertions.assertEquals((int)1, (int)data.resolveUnion(s, new ArrayList()));
    }

    @Test
    void unionWithMap() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"map\",\"values\":\"float\"}]");
        ReflectData data = ReflectData.get();
        Assertions.assertEquals((int)1, (int)data.resolveUnion(s, new HashMap()));
    }

    @Test
    void unionWithMapWithUtf8Keys() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"map\",\"values\":\"float\"}]");
        ReflectData data = ReflectData.get();
        HashMap<Utf8, Float> map = new HashMap<Utf8, Float>();
        map.put(new Utf8("foo"), Float.valueOf(1.0f));
        Assertions.assertEquals((int)1, (int)data.resolveUnion(s, map));
    }

    @Test
    void unionWithFixed() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"fixed\",\"name\":\"f\",\"size\":1}]");
        Schema f = new Schema.Parser().parse("{\"type\":\"fixed\",\"name\":\"f\",\"size\":1}");
        ReflectData data = ReflectData.get();
        Assertions.assertEquals((int)1, (int)data.resolveUnion(s, (Object)new GenericData.Fixed(f)));
    }

    @Test
    void unionWithEnum() {
        Schema s = new Schema.Parser().parse("[\"null\", {\"type\":\"enum\",\"name\":\"E\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"symbols\":[\"A\",\"B\"]}]");
        ReflectData data = ReflectData.get();
        Assertions.assertEquals((int)1, (int)data.resolveUnion(s, (Object)E.A));
    }

    @Test
    void unionWithBytes() {
        Schema s = new Schema.Parser().parse("[\"null\", \"bytes\"]");
        ReflectData data = ReflectData.get();
        Assertions.assertEquals((int)1, (int)data.resolveUnion(s, (Object)ByteBuffer.wrap(new byte[]{1})));
    }

    @Test
    void map() throws Exception {
        this.check(R1.class.getDeclaredField("mapField").getGenericType(), "{\"type\":\"map\",\"values\":\"string\"}");
    }

    @Test
    void array() throws Exception {
        this.check(R1.class.getDeclaredField("arrayField").getGenericType(), "{\"type\":\"array\",\"items\":\"string\",\"java-class\":\"[Ljava.lang.String;\"}");
    }

    @Test
    void list() throws Exception {
        this.check(R1.class.getDeclaredField("listField").getGenericType(), "{\"type\":\"array\",\"items\":\"string\",\"java-class\":\"java.util.List\"}");
    }

    @Test
    void r1() throws Exception {
        this.checkReadWrite(new R1());
    }

    @Test
    void r2() throws Exception {
        R2 r2 = new R2();
        r2.arrayField = new String[]{"foo"};
        r2.collectionField = new ArrayList<String>();
        r2.collectionField.add("foo");
        this.checkReadWrite(r2);
    }

    @Test
    void r3() throws Exception {
        R3 r3 = new R3();
        r3.intArray = new int[]{1};
        this.checkReadWrite(r3);
    }

    @Test
    void r5() throws Exception {
        R5 r5 = new R5();
        r5.value = 1;
        r5.shorts = new short[]{3, 255, 256, Short.MAX_VALUE, Short.MIN_VALUE};
        r5.b = (byte)99;
        r5.c = (char)97;
        this.checkReadWrite(r5);
    }

    @Test
    void r6() throws Exception {
        R7 r7 = new R7();
        r7.value = 1;
        this.checkReadWrite(r7, ReflectData.get().getSchema(R6.class));
        R8 r8 = new R8();
        r8.value = 1.0f;
        this.checkReadWrite(r8, ReflectData.get().getSchema(R6.class));
        R9 r9 = new R9();
        r9.r6s = new R6[]{r7, r8};
        this.checkReadWrite(r9, ReflectData.get().getSchema(R9.class));
    }

    @Test
    void r6_1() throws Exception {
        R7 r7 = new R7();
        r7.value = 1;
        this.checkReadWrite(r7, ReflectData.get().getSchema(R6.class));
        R8 r8 = new R8();
        r8.value = 1.0f;
        this.checkReadWrite(r8, ReflectData.get().getSchema(R6.class));
        R9_1 r9_1 = new R9_1();
        r9_1.value = null;
        this.checkReadWrite(r9_1, ReflectData.get().getSchema(R9_1.class));
        r9_1.value = r7;
        this.checkReadWrite(r9_1, ReflectData.get().getSchema(R9_1.class));
        r9_1.value = r8;
        this.checkReadWrite(r9_1, ReflectData.get().getSchema(R9_1.class));
    }

    @Test
    @DisabledIfEnvironmentVariable(named="WithinInvokerPlugin", matches="true", disabledReason="Doesn't work, no clue why")
    void p0() throws Exception {
        Protocol p0 = ReflectData.get().getProtocol(P0.class);
        Protocol.Message message = (Protocol.Message)p0.getMessages().get("foo");
        Schema response = message.getResponse();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)response.getType());
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)response.getTypes().get(0)).getType());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)response.getTypes().get(1)).getType());
        Schema request = message.getRequest();
        Schema.Field field = request.getField("s");
        Assertions.assertNotNull((Object)field, (String)"field 's' should not be null");
        Schema param = field.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)param.getType());
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)param.getTypes().get(0)).getType());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)param.getTypes().get(1)).getType());
        Assertions.assertEquals(String.class, (Object)ReflectData.get().getClass(response));
        Assertions.assertEquals(String.class, (Object)ReflectData.get().getClass(param));
    }

    @Test
    void r10() throws Exception {
        Schema r10Schema = ReflectData.get().getSchema(R10.class);
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)r10Schema.getType());
        Assertions.assertEquals((Object)R10.class.getName(), (Object)r10Schema.getProp("java-class"));
        this.checkReadWrite(new R10("foo"), r10Schema);
    }

    @Test
    void r11() throws Exception {
        Schema r11Record = ReflectData.get().getSchema(R11.class);
        Assertions.assertEquals((Object)Schema.Type.RECORD, (Object)r11Record.getType());
        Schema.Field r11Field = r11Record.getField("text");
        Assertions.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)r11Field.defaultVal());
        Schema r11FieldSchema = r11Field.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)r11FieldSchema.getType());
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)r11FieldSchema.getTypes().get(0)).getType());
        Schema r11String = (Schema)r11FieldSchema.getTypes().get(1);
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)r11String.getType());
        R11 r11 = new R11();
        this.checkReadWrite(r11, r11Record);
        r11.text = "foo";
        this.checkReadWrite(r11, r11Record);
    }

    @Test
    @DisabledIfEnvironmentVariable(named="WithinInvokerPlugin", matches="true", disabledReason="Doesn't work, no clue why")
    void p1() throws Exception {
        Protocol p1 = ReflectData.get().getProtocol(P1.class);
        Protocol.Message message = (Protocol.Message)p1.getMessages().get("foo");
        Schema response = message.getResponse();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)response.getType());
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)response.getTypes().get(0)).getType());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)response.getTypes().get(1)).getType());
        Schema request = message.getRequest();
        Schema.Field field = request.getField("s");
        Assertions.assertNotNull((Object)field, (String)"field 's' should not be null");
        Schema param = field.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)param.getType());
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)param.getTypes().get(0)).getType());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)param.getTypes().get(1)).getType());
        Assertions.assertEquals(String.class, (Object)ReflectData.get().getClass(response));
        Assertions.assertEquals(String.class, (Object)ReflectData.get().getClass(param));
    }

    @Test
    void r12() throws Exception {
        Schema s = ReflectData.get().getSchema(R12.class);
        Assertions.assertEquals((Object)Schema.Type.INT, (Object)s.getField("x").schema().getType());
        Assertions.assertEquals((Object)new Schema.Parser().parse("{\"type\":\"array\",\"items\":[\"null\",\"string\"]}"), (Object)s.getField("strings").schema());
    }

    @Test
    void r13() throws Exception {
        Schema s = ReflectData.get().getSchema(R13.class);
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)s.getType());
    }

    @Test
    @DisabledIfEnvironmentVariable(named="WithinInvokerPlugin", matches="true", disabledReason="Doesn't work, no clue why")
    void p4() throws Exception {
        Protocol p = ReflectData.get().getProtocol(P4.class);
        Protocol.Message message = (Protocol.Message)p.getMessages().get("foo");
        Assertions.assertEquals((Object)Schema.Type.INT, (Object)message.getResponse().getType());
        Schema.Field field = message.getRequest().getField("x");
        Assertions.assertEquals((Object)Schema.Type.INT, (Object)field.schema().getType());
    }

    @Test
    public void testAvroNullableDefault() {
        this.check((Type)((Object)NullableDefaultTest.class), "{\"type\":\"record\",\"name\":\"NullableDefaultTest\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"foo\",\"type\":[\"null\",\"int\"],\"default\":1}]}");
    }

    @Test
    public void testAvroUnionDefault() {
        this.check((Type)((Object)UnionDefaultTest.class), "{\"type\":\"record\",\"name\":\"UnionDefaultTest\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"foo\",\"type\":[\"int\",\"string\"],\"default\":1}]}");
    }

    @Test
    void p2() throws Exception {
        Schema e1 = ReflectData.get().getSchema(E1.class);
        Assertions.assertEquals((Object)Schema.Type.RECORD, (Object)e1.getType());
        Assertions.assertTrue((boolean)e1.isError());
        Schema.Field message = e1.getField("detailMessage");
        Assertions.assertNotNull((Object)message, (String)"field 'detailMessage' should not be null");
        Schema messageSchema = message.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)messageSchema.getType());
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)messageSchema.getTypes().get(0)).getType());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)messageSchema.getTypes().get(1)).getType());
        Protocol p2 = ReflectData.get().getProtocol(P2.class);
        Protocol.Message m = (Protocol.Message)p2.getMessages().get("error");
        Schema response = m.getErrors();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)response.getType());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)((Schema)response.getTypes().get(0)).getType());
        Assertions.assertEquals((Object)e1, response.getTypes().get(1));
    }

    @Test
    void noPackage() throws Exception {
        Class<?> noPackage = Class.forName("NoPackage");
        Schema s = ReflectData.get().getSchema(noPackage);
        Assertions.assertEquals((Object)noPackage.getName(), (Object)ReflectData.getClassName((Schema)s));
    }

    void checkReadWrite(Object object) throws Exception {
        this.checkReadWrite(object, ReflectData.get().getSchema(object.getClass()));
    }

    void checkReadWrite(Object object, Schema s) throws Exception {
        ReflectDatumWriter writer = new ReflectDatumWriter(s);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.write(object, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(s);
        Object after = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assertions.assertEquals((Object)object, (Object)after);
        if (s.getType().equals((Object)Schema.Type.RECORD)) {
            Object copy = object.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Schema.Field f : s.getFields()) {
                Object val = ReflectData.get().getField(object, f.name(), f.pos());
                ReflectData.get().setField(copy, f.name(), f.pos(), val);
            }
            Assertions.assertEquals((Object)object, copy, (String)"setField");
        }
    }

    @Test
    void testEnum() throws Exception {
        this.check((Type)((Object)E.class), "{\"type\":\"enum\",\"name\":\"E\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"symbols\":[\"A\",\"B\"]}");
    }

    @Test
    void record() throws Exception {
        this.check((Type)((Object)R.class), "{\"type\":\"record\",\"name\":\"R\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"a\",\"type\":\"int\"},{\"name\":\"b\",\"type\":\"long\"}]}");
    }

    @Test
    void annotationAvroIgnore() throws Exception {
        this.check((Type)((Object)RAvroIgnore.class), "{\"type\":\"record\",\"name\":\"RAvroIgnore\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[]}");
    }

    @Test
    void annotationAvroMeta() throws Exception {
        this.check((Type)((Object)RAvroMeta.class), "{\"type\":\"record\",\"name\":\"RAvroMeta\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"a\",\"type\":\"int\",\"K\":\"V\"}],\"X\":\"Y\"}");
    }

    @Test
    void annotationMultiAvroMeta() {
        this.check((Type)((Object)RAvroMultiMeta.class), "{\"type\":\"record\",\"name\":\"RAvroMultiMeta\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"a\",\"type\":\"int\",\"K\":\"V\",\"L\":\"W\"}],\"X\":\"Y\",\"A\":\"B\"}");
    }

    @Test
    void annotationDuplicateFieldAvroMeta() {
        Assertions.assertThrows(AvroTypeException.class, () -> ReflectData.get().getSchema(RAvroDuplicateFieldMeta.class));
    }

    @Test
    void annotationDuplicateTypeAvroMeta() {
        Assertions.assertThrows(AvroTypeException.class, () -> ReflectData.get().getSchema(RAvroDuplicateTypeMeta.class));
    }

    @Test
    void annotationAvroName() throws Exception {
        this.check((Type)((Object)RAvroName.class), "{\"type\":\"record\",\"name\":\"RAvroName\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"b\",\"type\":\"int\"}]}");
    }

    @Test
    void annotationAvroNameCollide() throws Exception {
        Assertions.assertThrows(Exception.class, () -> this.check((Type)((Object)RAvroNameCollide.class), "{\"type\":\"record\",\"name\":\"RAvroNameCollide\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"b\",\"type\":\"int\"},{\"name\":\"b\",\"type\":\"int\"}]}"));
    }

    @Test
    void annotationAvroStringableFields() throws Exception {
        this.check((Type)((Object)RAvroStringableField.class), "{\"type\":\"record\",\"name\":\"RAvroStringableField\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"a\",\"type\":\"string\"}]}");
    }

    private void check(Object o, String schemaJson) {
        this.check(o.getClass(), schemaJson);
    }

    private void check(Type type, String schemaJson) {
        Assertions.assertEquals((Object)schemaJson, (Object)ReflectData.get().getSchema(type).toString());
    }

    @Test
    void recordIO() throws IOException {
        Schema schm = ReflectData.get().getSchema(SampleRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SampleRecord record = new SampleRecord();
        record.x = 5;
        record.y = 10;
        writer.write((Object)record, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        SampleRecord decoded = (SampleRecord)reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assertions.assertEquals((Object)record, (Object)decoded);
    }

    @Test
    void multipleAnnotations() throws IOException {
        Schema schm = ReflectData.get().getSchema(multipleAnnotationRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipleAnnotationRecord record = new multipleAnnotationRecord();
        record.i1 = 1;
        record.i2 = 2;
        record.i3 = 3;
        record.i4 = new Date(4L);
        record.i5 = 5;
        record.i6 = 6;
        record.i7 = new Date(7L);
        record.i8 = 8;
        record.i9 = new Date(9L);
        record.i10 = new Date(10L);
        record.i11 = new Date(11L);
        writer.write((Object)record, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        multipleAnnotationRecord decoded = (multipleAnnotationRecord)reader.read((Object)new multipleAnnotationRecord(), (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assertions.assertNull((Object)decoded.i1);
        Assertions.assertNull((Object)decoded.i2);
        Assertions.assertNull((Object)decoded.i3);
        Assertions.assertNull((Object)decoded.i4);
        Assertions.assertEquals((Integer)decoded.i5, (int)5);
        Assertions.assertEquals((Integer)decoded.i6, (int)6);
        Assertions.assertEquals((long)decoded.i7.getTime(), (long)7L);
        Assertions.assertEquals((Integer)decoded.i8, (int)8);
        Assertions.assertEquals((long)decoded.i9.getTime(), (long)9L);
        Assertions.assertEquals((long)decoded.i10.getTime(), (long)10L);
        Assertions.assertEquals((long)decoded.i11.getTime(), (long)11L);
    }

    @Test
    void avroEncodeInducing() throws IOException {
        Schema schm = ReflectData.get().getSchema(AvroEncRecord.class);
        Assertions.assertEquals((Object)schm.toString(), (Object)"{\"type\":\"record\",\"name\":\"AvroEncRecord\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"date\",\"type\":{\"type\":\"long\",\"CustomEncoding\":\"DateAsLongEncoding\"}}]}");
    }

    @Test
    void avroEncodeIO() throws IOException {
        Schema schm = ReflectData.get().getSchema(AvroEncRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AvroEncRecord record = new AvroEncRecord();
        record.date = new Date(948833323L);
        writer.write((Object)record, (Encoder)this.factory.directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        AvroEncRecord decoded = (AvroEncRecord)reader.read((Object)new AvroEncRecord(), (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assertions.assertEquals((Object)record, (Object)decoded);
    }

    @Test
    void recordWithNullIO() throws IOException {
        ReflectData.AllowNull reflectData = ReflectData.AllowNull.get();
        Schema schm = reflectData.getSchema(SampleRecord.AnotherSampleRecord.class);
        ReflectDatumWriter writer = new ReflectDatumWriter(schm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e = this.factory.directBinaryEncoder((OutputStream)out, null);
        SampleRecord.AnotherSampleRecord a = new SampleRecord.AnotherSampleRecord();
        writer.write((Object)a, (Encoder)e);
        SampleRecord.AnotherSampleRecord b = new SampleRecord.AnotherSampleRecord(10);
        writer.write((Object)b, (Encoder)e);
        e.flush();
        ReflectDatumReader reader = new ReflectDatumReader(schm);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BinaryDecoder d = DecoderFactory.get().binaryDecoder((InputStream)in, null);
        SampleRecord.AnotherSampleRecord decoded = (SampleRecord.AnotherSampleRecord)reader.read(null, (Decoder)d);
        Assertions.assertEquals((Object)a, (Object)decoded);
        decoded = (SampleRecord.AnotherSampleRecord)reader.read(null, (Decoder)d);
        Assertions.assertEquals((Object)b, (Object)decoded);
    }

    @Test
    void forwardReference() {
        ReflectData data = ReflectData.get();
        Protocol reflected = data.getProtocol(C.class);
        String ref = reflected.toString();
        Protocol reparsed = Protocol.parse((String)ref);
        Assertions.assertEquals((Object)reflected, (Object)reparsed);
        assert (reparsed.getTypes().contains(data.getSchema(A.class)));
        assert (reparsed.getTypes().contains(data.getSchema(B1.class)));
        assert (reparsed.getTypes().contains(data.getSchema(B2.class)));
        assert (reparsed.getTypes().contains(data.getSchema(X.class)));
    }

    @Test
    void overloadedMethod() {
        Assertions.assertThrows(AvroTypeException.class, () -> ReflectData.get().getProtocol(P3.class));
    }

    @Test
    void noPackageSchema() throws Exception {
        ReflectData.get().getSchema(Class.forName("NoPackage"));
    }

    @Test
    void noPackageProtocol() throws Exception {
        ReflectData.get().getProtocol(Class.forName("NoPackage"));
    }

    @Test
    void reflectWithinGeneric() throws Exception {
        ReflectData data = ReflectData.get();
        Schema schema = Schema.createRecord((String)"Foo", (String)"", (String)"x.y.z", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("f", data.getSchema(Y.class), "", null));
        schema.setFields(fields);
        Y y = new Y();
        y.i = 1;
        GenericData.Record record = new GenericData.Record(schema);
        record.put("f", (Object)y);
        TestReflect.checkBinary(schema, record);
    }

    @Test
    void primitiveArray() throws Exception {
        this.testPrimitiveArrays(false);
    }

    @Test
    void primitiveArrayBlocking() throws Exception {
        this.testPrimitiveArrays(true);
    }

    private void testPrimitiveArrays(boolean blocking) throws Exception {
        this.testPrimitiveArray(Boolean.TYPE, blocking);
        this.testPrimitiveArray(Byte.TYPE, blocking);
        this.testPrimitiveArray(Short.TYPE, blocking);
        this.testPrimitiveArray(Character.TYPE, blocking);
        this.testPrimitiveArray(Integer.TYPE, blocking);
        this.testPrimitiveArray(Long.TYPE, blocking);
        this.testPrimitiveArray(Float.TYPE, blocking);
        this.testPrimitiveArray(Double.TYPE, blocking);
    }

    private void testPrimitiveArray(Class<?> c, boolean blocking) throws Exception {
        ReflectData data = new ReflectData();
        Random r = new Random();
        int size = 200;
        Object array = Array.newInstance(c, size);
        Schema s = data.getSchema(array.getClass());
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, this.randomFor(c, r));
        }
        TestReflect.checkBinary(data, s, array, false, blocking);
    }

    private Object randomFor(Class<?> c, Random r) {
        if (c == Boolean.TYPE) {
            return r.nextBoolean();
        }
        if (c == Integer.TYPE) {
            return r.nextInt();
        }
        if (c == Long.TYPE) {
            return r.nextLong();
        }
        if (c == Byte.TYPE) {
            return (byte)r.nextInt();
        }
        if (c == Float.TYPE) {
            return Float.valueOf(r.nextFloat());
        }
        if (c == Double.TYPE) {
            return r.nextDouble();
        }
        if (c == Character.TYPE) {
            return Character.valueOf((char)r.nextInt());
        }
        if (c == Short.TYPE) {
            return (short)r.nextInt();
        }
        return null;
    }

    @Test
    void nullArray() throws Exception {
        String json = "[{\"type\":\"array\", \"items\": \"long\"}, \"null\"]";
        Schema schema = new Schema.Parser().parse(json);
        TestReflect.checkBinary(schema, null);
    }

    @Test
    void stringables() throws Exception {
        this.checkStringable(BigDecimal.class, "10");
        this.checkStringable(BigInteger.class, "20");
        this.checkStringable(URI.class, "foo://bar:9000/baz");
        this.checkStringable(URL.class, "http://bar:9000/baz");
        this.checkStringable(File.class, "foo.bar");
    }

    public void checkStringable(Class c, String value) throws Exception {
        ReflectData data = new ReflectData();
        Schema schema = data.getSchema((Type)c);
        Assertions.assertEquals((Object)("{\"type\":\"string\",\"java-class\":\"" + c.getName() + "\"}"), (Object)schema.toString());
        TestReflect.checkBinary(schema, c.getConstructor(String.class).newInstance(value));
    }

    @Test
    void stringableMapKeys() throws Exception {
        M1 record = new M1();
        record.integerKeyMap = new HashMap<Integer, String>(1);
        record.integerKeyMap.put(10, "foo");
        record.bigIntegerKeyMap = new HashMap<BigInteger, String>(1);
        record.bigIntegerKeyMap.put(BigInteger.TEN, "bar");
        record.bigDecimalKeyMap = new HashMap<BigDecimal, String>(1);
        record.bigDecimalKeyMap.put(BigDecimal.ONE, "bigDecimal");
        record.fileKeyMap = new HashMap<File, String>(1);
        record.fileKeyMap.put(new File("foo.bar"), "file");
        ReflectData data = new ReflectData().addStringable(Integer.class);
        TestReflect.checkBinary(data, data.getSchema(M1.class), record, true);
    }

    @Test
    void nullableStringableField() throws Exception {
        NullableStringable datum = new NullableStringable();
        datum.number = BigDecimal.TEN;
        Schema schema = ReflectData.AllowNull.get().getSchema(NullableStringable.class);
        TestReflect.checkBinary(schema, datum);
    }

    public static void checkBinary(ReflectData reflectData, Schema schema, Object datum, boolean equals) throws IOException {
        TestReflect.checkBinary(reflectData, schema, datum, equals, false);
    }

    private static void checkBinary(ReflectData reflectData, Schema schema, Object datum, boolean equals, boolean blocking) throws IOException {
        ReflectDatumWriter writer = new ReflectDatumWriter(schema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!blocking) {
            writer.write(datum, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)out, null));
        } else {
            writer.write(datum, (Encoder)new EncoderFactory().configureBlockSize(64).blockingBinaryEncoder((OutputStream)out, null));
        }
        writer.write(datum, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)out, null));
        byte[] data = out.toByteArray();
        ReflectDatumReader reader = new ReflectDatumReader(schema);
        Object decoded = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(data, null));
        Assertions.assertEquals((int)0, (int)reflectData.compare(datum, decoded, schema, equals));
    }

    public static void checkBinary(Schema schema, Object datum) throws IOException {
        TestReflect.checkBinary(ReflectData.get(), schema, datum, false);
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_8, max=JRE.JAVA_11, disabledReason="Java 11 announced: All illegal access operations will be denied in a future release")
    void reflectFieldError() throws Exception {
        String datum = "";
        try {
            ReflectData.get().getField((Object)datum, "notAFieldOfString", 0);
        }
        catch (AvroRuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(datum.getClass().getName()));
        }
    }

    @Test
    void avroAliasOnClass() {
        this.check((Type)((Object)AliasA.class), "{\"type\":\"record\",\"name\":\"AliasA\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[],\"aliases\":[\"b.a\"]}");
        this.check((Type)((Object)AliasB.class), "{\"type\":\"record\",\"name\":\"AliasB\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[],\"aliases\":[\"a\"]}");
        this.check((Type)((Object)AliasC.class), "{\"type\":\"record\",\"name\":\"AliasC\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[],\"aliases\":[\"a\"]}");
    }

    @Test
    void multipleAliasAnnotationsOnClass() {
        this.check((Type)((Object)MultipleAliasRecord.class), "{\"type\":\"record\",\"name\":\"MultipleAliasRecord\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[],\"aliases\":[\"space1.alias1\",\"space2.alias2\"]}");
    }

    @Test
    void dollarTerminatedNamespaceCompatibility() {
        ReflectData data = ReflectData.get();
        Schema s = new Schema.Parser(NameValidator.NO_VALIDATION).parse("{\"type\":\"record\",\"name\":\"Z\",\"namespace\":\"org.apache.avro.reflect.TestReflect$\",\"fields\":[]}");
        Assertions.assertEquals((Object)data.getSchema((Type)data.getClass(s)).toString(), (Object)"{\"type\":\"record\",\"name\":\"Z\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[]}");
    }

    @Test
    void dollarTerminatedNestedStaticClassNamespaceCompatibility() {
        ReflectData data = ReflectData.get();
        Schema s = new Schema.Parser(NameValidator.NO_VALIDATION).parse("{\"type\":\"record\",\"name\":\"AnotherSampleRecord\",\"namespace\":\"org.apache.avro.reflect.TestReflect$SampleRecord\",\"fields\":[]}");
        MatcherAssert.assertThat((Object)data.getSchema((Type)data.getClass(s)).getFullName(), (Matcher)Matchers.is((Object)"org.apache.avro.reflect.TestReflect.SampleRecord.AnotherSampleRecord"));
    }

    @Test
    void avroAliasOnField() {
        Schema expectedSchema = (Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)ClassWithAliasOnField.class.getSimpleName()).namespace("org.apache.avro.reflect.TestReflect")).fields().name("primitiveField").aliases(new String[]{"aliasName"})).type(Schema.create((Schema.Type)Schema.Type.INT)).noDefault().endRecord();
        this.check((Type)((Object)ClassWithAliasOnField.class), expectedSchema.toString());
    }

    @Test
    void namespaceDefinitionOnFieldAliasMustThrowException() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> ReflectData.get().getSchema(ClassWithAliasAndNamespaceOnField.class));
    }

    @Test
    public void testMultipleFieldAliases() {
        Schema.Field field = new Schema.Field("primitiveField", Schema.create((Schema.Type)Schema.Type.INT));
        field.addAlias("alias1");
        field.addAlias("alias2");
        Schema avroMultiMeta = Schema.createRecord((String)"ClassWithMultipleAliasesOnField", null, (String)"org.apache.avro.reflect.TestReflect", (boolean)false, Arrays.asList(field));
        Schema schema = ReflectData.get().getSchema(ClassWithMultipleAliasesOnField.class);
        Assertions.assertEquals((Object)avroMultiMeta, (Object)schema);
    }

    @Test
    public void testOptional() {
        this.check((Type)((Object)OptionalTest.class), "{\"type\":\"record\",\"name\":\"OptionalTest\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"foo\",\"type\":[\"null\",\"int\"],\"default\":null}]}");
    }

    @Test
    void avroDefault() {
        this.check((Type)((Object)DefaultTest.class), "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"fields\":[{\"name\":\"foo\",\"type\":\"int\",\"default\":1}]}");
    }

    @Test
    void nullableByteArrayNotNullValue() throws Exception {
        this.checkReadWrite(new NullableBytesTest("foo".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    void nullableByteArrayNullValue() throws Exception {
        this.checkReadWrite(new NullableBytesTest());
    }

    @Test
    void avroDoc() {
        this.check((Type)((Object)DocTest.class), "{\"type\":\"record\",\"name\":\"DocTest\",\"namespace\":\"org.apache.avro.reflect.TestReflect\",\"doc\":\"DocTest class docs\",\"fields\":[{\"name\":\"defaultTest\",\"type\":{\"type\":\"record\",\"name\":\"DefaultTest\",\"fields\":[{\"name\":\"foo\",\"type\":\"int\",\"default\":1}]},\"doc\":\"And again\"},{\"name\":\"enums\",\"type\":{\"type\":\"enum\",\"name\":\"DocTestEnum\",\"symbols\":[\"ENUM_1\",\"ENUM_2\"]},\"doc\":\"Some other Documentation\"},{\"name\":\"foo\",\"type\":\"int\",\"doc\":\"Some Documentation\"}]}");
    }

    public static enum E {
        A,
        B;

    }

    public static class R1 {
        private Map<String, String> mapField = new HashMap<String, String>();
        private String[] arrayField = new String[]{"foo"};
        private List<String> listField = new ArrayList<String>();

        public R1() {
            this.mapField.put("foo", "bar");
            this.listField.add("foo");
        }

        public boolean equals(Object o) {
            if (!(o instanceof R1)) {
                return false;
            }
            R1 that = (R1)o;
            return this.mapField.equals(that.mapField) && Arrays.equals(this.arrayField, that.arrayField) && this.listField.equals(that.listField);
        }
    }

    public static class R2 {
        private String[] arrayField;
        private Collection<String> collectionField;

        public boolean equals(Object o) {
            if (!(o instanceof R2)) {
                return false;
            }
            R2 that = (R2)o;
            return Arrays.equals(this.arrayField, that.arrayField) && this.collectionField.equals(that.collectionField);
        }
    }

    public static class R3 {
        private int[] intArray;

        public boolean equals(Object o) {
            if (!(o instanceof R3)) {
                return false;
            }
            R3 that = (R3)o;
            return Arrays.equals(this.intArray, that.intArray);
        }
    }

    public static class R5
    extends R4 {
    }

    public static class R7
    extends R6 {
        public int value;

        public boolean equals(Object o) {
            if (!(o instanceof R7)) {
                return false;
            }
            return this.value == ((R7)o).value;
        }
    }

    @Union(value={R7.class, R8.class})
    public static class R6 {
    }

    public static class R8
    extends R6 {
        public float value;

        public boolean equals(Object o) {
            if (!(o instanceof R8)) {
                return false;
            }
            return this.value == ((R8)o).value;
        }
    }

    public static class R9 {
        public R6[] r6s;

        public boolean equals(Object o) {
            if (!(o instanceof R9)) {
                return false;
            }
            return Arrays.equals(this.r6s, ((R9)o).r6s);
        }
    }

    public static class R9_1 {
        @Union(value={Void.class, R7.class, R8.class})
        public Object value;

        public boolean equals(Object o) {
            if (!(o instanceof R9_1)) {
                return false;
            }
            if (this.value == null) {
                return ((R9_1)o).value == null;
            }
            return this.value.equals(((R9_1)o).value);
        }
    }

    public static interface P0 {
        @Union(value={Void.class, String.class})
        public String foo(@Union(value={Void.class, String.class}) String var1);
    }

    @Stringable
    public static class R10 {
        private String text;

        public R10(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (!(o instanceof R10)) {
                return false;
            }
            return this.text.equals(((R10)o).text);
        }
    }

    public static class R11 {
        @Nullable
        private String text;

        public boolean equals(Object o) {
            if (!(o instanceof R11)) {
                return false;
            }
            R11 that = (R11)o;
            if (this.text == null) {
                return that.text == null;
            }
            return this.text.equals(that.text);
        }
    }

    public static interface P1 {
        @Nullable
        public String foo(@Nullable String var1);
    }

    public static class R12 {
        @AvroSchema(value="\"int\"")
        Object x;
        @AvroSchema(value="{\"type\":\"array\",\"items\":[\"null\",\"string\"]}")
        List<String> strings;
    }

    @AvroSchema(value="\"null\"")
    public static class R13 {
    }

    public static interface P4 {
        @AvroSchema(value="\"int\"")
        public Object foo(@AvroSchema(value="\"int\"") Object var1);
    }

    private static class NullableDefaultTest {
        @Nullable
        @AvroDefault(value="1")
        int foo;

        private NullableDefaultTest() {
        }
    }

    private static class UnionDefaultTest {
        @Union(value={Integer.class, String.class})
        @AvroDefault(value="1")
        Object foo;

        private UnionDefaultTest() {
        }
    }

    public static class E1
    extends Exception {
    }

    public static interface P2 {
        public void error() throws E1;
    }

    public static class R {
        int a;
        long b;
    }

    public static class RAvroIgnore {
        @AvroIgnore
        int a;
    }

    @AvroMeta(key="X", value="Y")
    public static class RAvroMeta {
        @AvroMeta(key="K", value="V")
        int a;
    }

    @AvroMeta.AvroMetas(value={@AvroMeta(key="X", value="Y"), @AvroMeta(key="A", value="B")})
    public static class RAvroMultiMeta {
        @AvroMeta.AvroMetas(value={@AvroMeta(key="K", value="V"), @AvroMeta(key="L", value="W")})
        int a;
    }

    public static class RAvroName {
        @AvroName(value="b")
        int a;
    }

    public static class RAvroStringableField {
        @Stringable
        int a;
    }

    public static class SampleRecord {
        public int x = 1;
        private int y = 2;

        public int hashCode() {
            return this.x + this.y;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleRecord other = (SampleRecord)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }

        public static class AnotherSampleRecord {
            private Integer a = null;
            private SampleRecord s = null;

            public AnotherSampleRecord() {
            }

            AnotherSampleRecord(Integer a) {
                this.a = a;
                this.s = new SampleRecord();
            }

            public int hashCode() {
                int hash = this.a != null ? this.a.hashCode() : 0;
                return hash += this.s != null ? this.s.hashCode() : 0;
            }

            public boolean equals(Object other) {
                if (other instanceof AnotherSampleRecord) {
                    AnotherSampleRecord o = (AnotherSampleRecord)other;
                    return !(this.a == null && o.a != null || this.a != null && !this.a.equals(o.a) || this.s == null && o.s != null || this.s != null && !this.s.equals(o.s));
                }
                return false;
            }
        }
    }

    public static class multipleAnnotationRecord {
        @AvroIgnore
        @Stringable
        Integer i1;
        @AvroIgnore
        @Nullable
        Integer i2;
        @AvroIgnore
        @AvroName(value="j")
        Integer i3;
        @AvroIgnore
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i4;
        @Stringable
        @Nullable
        Integer i5;
        @Stringable
        @AvroName(value="j6")
        Integer i6 = 6;
        @Stringable
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i7 = new Date(7L);
        @Nullable
        @AvroName(value="j8")
        Integer i8;
        @Nullable
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i9;
        @AvroName(value="j10")
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i10 = new Date(10L);
        @Stringable
        @Nullable
        @AvroName(value="j11")
        @AvroEncode(using=DateAsLongEncoding.class)
        Date i11;
    }

    public static class AvroEncRecord {
        @AvroEncode(using=DateAsLongEncoding.class)
        Date date;

        public boolean equals(Object o) {
            if (!(o instanceof AvroEncRecord)) {
                return false;
            }
            return this.date.equals(((AvroEncRecord)o).date);
        }
    }

    public static interface C {
        public void foo(A var1);
    }

    public static class A {
        B1 b1;
        B2 b2;
    }

    public static class B1 {
        X x;
    }

    public static class B2 {
        X x;
    }

    public static class X {
        int i;
    }

    public static class Y {
        int i;
    }

    public static class M1 {
        Map<Integer, String> integerKeyMap;
        Map<BigInteger, String> bigIntegerKeyMap;
        Map<BigDecimal, String> bigDecimalKeyMap;
        Map<File, String> fileKeyMap;
    }

    public static class NullableStringable {
        BigDecimal number;
    }

    @AvroAlias(alias="a", space="b")
    private static class AliasA {
        private AliasA() {
        }
    }

    @AvroAlias(alias="a", space="")
    private static class AliasB {
        private AliasB() {
        }
    }

    @AvroAlias(alias="a")
    private static class AliasC {
        private AliasC() {
        }
    }

    @AvroAliases(value={@AvroAlias(alias="alias1", space="space1"), @AvroAlias(alias="alias2", space="space2")})
    private static class MultipleAliasRecord {
        private MultipleAliasRecord() {
        }
    }

    private static class ClassWithAliasOnField {
        @AvroAlias(alias="aliasName")
        int primitiveField;

        private ClassWithAliasOnField() {
        }
    }

    private static class ClassWithMultipleAliasesOnField {
        @AvroAliases(value={@AvroAlias(alias="alias1"), @AvroAlias(alias="alias2")})
        int primitiveField;

        private ClassWithMultipleAliasesOnField() {
        }
    }

    private static class OptionalTest {
        Optional<Integer> foo;

        private OptionalTest() {
        }
    }

    private static class DefaultTest {
        @AvroDefault(value="1")
        int foo;

        private DefaultTest() {
        }
    }

    public static class NullableBytesTest {
        @Nullable
        byte[] bytes;

        NullableBytesTest() {
        }

        NullableBytesTest(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object obj) {
            return obj instanceof NullableBytesTest && Arrays.equals(((NullableBytesTest)obj).bytes, this.bytes);
        }
    }

    @AvroDoc(value="DocTest class docs")
    private static class DocTest {
        @AvroDoc(value="Some Documentation")
        int foo;
        @AvroDoc(value="Some other Documentation")
        DocTestEnum enums;
        @AvroDoc(value="And again")
        DefaultTest defaultTest;

        private DocTest() {
        }
    }

    private static class ClassWithAliasAndNamespaceOnField {
        @AvroAlias(alias="aliasName", space="forbidden.space.entry")
        int primitiveField;

        private ClassWithAliasAndNamespaceOnField() {
        }
    }

    public static interface P3 {
        public void m1();

        public void m1(int var1);
    }

    public static class RAvroNameCollide {
        @AvroName(value="b")
        int a;
        int b;
    }

    @AvroMeta.AvroMetas(value={@AvroMeta(key="K", value="V"), @AvroMeta(key="K", value="W")})
    public static class RAvroDuplicateTypeMeta {
        int a;
    }

    public static class RAvroDuplicateFieldMeta {
        @AvroMeta.AvroMetas(value={@AvroMeta(key="K", value="V"), @AvroMeta(key="K", value="W")})
        int a;
    }

    private static enum DocTestEnum {
        ENUM_1,
        ENUM_2;

    }

    private static class Z {
        private Z() {
        }
    }

    public static class R4 {
        public short value;
        public short[] shorts;
        public byte b;
        public char c;

        public boolean equals(Object o) {
            if (!(o instanceof R4)) {
                return false;
            }
            R4 that = (R4)o;
            return this.value == that.value && Arrays.equals(this.shorts, that.shorts) && this.b == that.b && this.c == that.c;
        }
    }
}

