/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.Company;
import org.apache.avro.reflect.Company2;
import org.apache.avro.reflect.EmployeeId;
import org.apache.avro.reflect.EmployeeId2;
import org.apache.avro.reflect.EmployeeInfo;
import org.apache.avro.reflect.EmployeeInfo2;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.reflect.SameMapSignature;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNonStringMapKeys {
    @Test
    void nonStringMapKeys() throws Exception {
        Company entityObj1 = this.buildCompany();
        Company entityObj2 = this.buildCompany();
        String testType = "NonStringKeysTest";
        Company[] entityObjs = new Company[]{entityObj1, entityObj2};
        byte[] bytes = this.testSerialization(testType, entityObj1, entityObj2);
        List<GenericRecord> records = this.testGenericDatumRead(testType, bytes, entityObjs);
        GenericRecord record = records.get(0);
        Object employees = record.get("employees");
        Assertions.assertTrue((boolean)(employees instanceof GenericArray), (String)"Unable to read 'employees' map");
        GenericArray arrayEmployees = (GenericArray)employees;
        Object employeeRecord = arrayEmployees.get(0);
        Assertions.assertTrue((boolean)(employeeRecord instanceof GenericRecord));
        Object key = ((GenericRecord)employeeRecord).get("key");
        Object value = ((GenericRecord)employeeRecord).get("value");
        Assertions.assertTrue((boolean)(key instanceof GenericRecord));
        Assertions.assertTrue((boolean)(value instanceof GenericRecord));
        Object id = ((GenericRecord)key).get("id");
        String name = ((GenericRecord)value).get("name").toString();
        Assertions.assertTrue((id.equals(1) && name.equals("Foo") || id.equals(2) && name.equals("Bar") ? 1 : 0) != 0);
        List<Company> records2 = this.testReflectDatumRead(testType, bytes, entityObjs);
        Company co = records2.get(0);
        this.log("Read: " + co);
        Assertions.assertNotNull(co.getEmployees());
        Assertions.assertEquals((int)2, (int)co.getEmployees().size());
        for (Map.Entry<EmployeeId, EmployeeInfo> e : co.getEmployees().entrySet()) {
            id = e.getKey().getId();
            name = e.getValue().getName();
            Assertions.assertTrue((id.equals(1) && name.equals("Foo") || id.equals(2) && name.equals("Bar") ? 1 : 0) != 0);
        }
        byte[] jsonBytes = this.testJsonEncoder(testType, entityObj1);
        Assertions.assertNotNull((Object)jsonBytes, (String)"Unable to serialize using jsonEncoder");
        GenericRecord jsonRecord = this.testJsonDecoder(testType, jsonBytes, entityObj1);
        Assertions.assertEquals((Object)record, (Object)jsonRecord, (String)"JSON decoder output not same as Binary Decoder");
    }

    @Test
    void nonStringMapKeysInNestedMaps() throws Exception {
        Company2 entityObj1 = this.buildCompany2();
        String testType = "NestedMapsTest";
        Company2[] entityObjs = new Company2[]{entityObj1};
        byte[] bytes = this.testSerialization(testType, entityObj1);
        List<GenericRecord> records = this.testGenericDatumRead(testType, bytes, entityObjs);
        GenericRecord record = records.get(0);
        Object employees = record.get("employees");
        Assertions.assertTrue((boolean)(employees instanceof GenericArray), (String)"Unable to read 'employees' map");
        GenericArray employeesMapArray = (GenericArray)employees;
        Object employeeMapElement = employeesMapArray.get(0);
        Assertions.assertTrue((boolean)(employeeMapElement instanceof GenericRecord));
        Object key = ((GenericRecord)employeeMapElement).get("key");
        Object value = ((GenericRecord)employeeMapElement).get("value");
        Assertions.assertEquals((Object)11, (Object)key);
        Assertions.assertTrue((boolean)(value instanceof GenericRecord));
        GenericRecord employeeInfo = (GenericRecord)value;
        String name = employeeInfo.get("name").toString();
        Assertions.assertEquals((Object)"Foo", (Object)name);
        Object companyMap = employeeInfo.get("companyMap");
        Assertions.assertTrue((boolean)(companyMap instanceof GenericArray));
        GenericArray companyMapArray = (GenericArray)companyMap;
        Object companyMapElement = companyMapArray.get(0);
        Assertions.assertTrue((boolean)(companyMapElement instanceof GenericRecord));
        key = ((GenericRecord)companyMapElement).get("key");
        value = ((GenericRecord)companyMapElement).get("value");
        Assertions.assertEquals((Object)14, (Object)key);
        if (value instanceof Utf8) {
            value = ((Utf8)value).toString();
        }
        Assertions.assertEquals((Object)"CompanyFoo", (Object)value);
        List<Company2> records2 = this.testReflectDatumRead(testType, bytes, entityObjs);
        Company2 co = records2.get(0);
        this.log("Read: " + co);
        Assertions.assertNotNull(co.getEmployees());
        Assertions.assertEquals((int)1, (int)co.getEmployees().size());
        for (Map.Entry<Integer, EmployeeInfo2> e : co.getEmployees().entrySet()) {
            Integer id = e.getKey();
            name = e.getValue().getName();
            Assertions.assertTrue((id.equals(11) && name.equals("Foo") ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"CompanyFoo", (Object)e.getValue().companyMap.values().iterator().next());
        }
        byte[] jsonBytes = this.testJsonEncoder(testType, entityObj1);
        Assertions.assertNotNull((Object)jsonBytes, (String)"Unable to serialize using jsonEncoder");
        GenericRecord jsonRecord = this.testJsonDecoder(testType, jsonBytes, entityObj1);
        Assertions.assertEquals((Object)record, (Object)jsonRecord, (String)"JSON decoder output not same as Binary Decoder");
    }

    @Test
    void recordNameInvariance() throws Exception {
        SameMapSignature entityObj1 = this.buildSameMapSignature();
        String testType = "RecordNameInvariance";
        SameMapSignature[] entityObjs = new SameMapSignature[]{entityObj1};
        byte[] bytes = this.testSerialization(testType, entityObj1);
        List<GenericRecord> records = this.testGenericDatumRead(testType, bytes, entityObjs);
        GenericRecord record = records.get(0);
        Object map1obj = record.get("map1");
        Assertions.assertTrue((boolean)(map1obj instanceof GenericArray), (String)"Unable to read map1");
        GenericArray map1array = (GenericArray)map1obj;
        Object map1element = map1array.get(0);
        Assertions.assertTrue((boolean)(map1element instanceof GenericRecord));
        Object key = ((GenericRecord)map1element).get("key");
        Object value = ((GenericRecord)map1element).get("value");
        Assertions.assertEquals((Object)1, (Object)key);
        Assertions.assertEquals((Object)"Foo", (Object)value.toString());
        Object map2obj = record.get("map2");
        Assertions.assertEquals((Object)map1obj, (Object)map2obj);
        List<SameMapSignature> records2 = this.testReflectDatumRead(testType, bytes, entityObjs);
        SameMapSignature entity = records2.get(0);
        this.log("Read: " + entity);
        Assertions.assertNotNull(entity.getMap1());
        Assertions.assertEquals((int)1, (int)entity.getMap1().size());
        for (Map.Entry<Integer, String> e : entity.getMap1().entrySet()) {
            key = e.getKey();
            value = e.getValue();
            Assertions.assertEquals((Object)1, (Object)key);
            Assertions.assertEquals((Object)"Foo", (Object)value.toString());
        }
        Assertions.assertEquals(entity.getMap1(), entity.getMap2());
        Assertions.assertEquals(entity.getMap1(), entity.getMap3());
        Assertions.assertEquals(entity.getMap1(), entity.getMap4());
        ReflectData rdata = ReflectData.get();
        Schema schema = rdata.getSchema(SameMapSignature.class);
        Schema map1schema = schema.getField("map1").schema().getElementType();
        Schema map2schema = schema.getField("map2").schema().getElementType();
        Schema map3schema = schema.getField("map3").schema().getElementType();
        Schema map4schema = schema.getField("map4").schema().getElementType();
        this.log("Schema for map1 = " + map1schema);
        this.log("Schema for map2 = " + map2schema);
        this.log("Schema for map3 = " + map3schema);
        this.log("Schema for map4 = " + map4schema);
        Assertions.assertEquals((Object)map1schema.getFullName(), (Object)"org.apache.avro.reflect.PairIntegerString");
        Assertions.assertEquals((Object)map1schema, (Object)map2schema);
        Assertions.assertEquals((Object)map1schema, (Object)map3schema);
        Assertions.assertEquals((Object)map1schema, (Object)map4schema);
        byte[] jsonBytes = this.testJsonEncoder(testType, entityObj1);
        Assertions.assertNotNull((Object)jsonBytes, (String)"Unable to serialize using jsonEncoder");
        GenericRecord jsonRecord = this.testJsonDecoder(testType, jsonBytes, entityObj1);
        Assertions.assertEquals((Object)record.get("map1"), (Object)jsonRecord.get("map1"), (String)"JSON decoder output not same as Binary Decoder");
        Assertions.assertEquals((Object)record.get("map2"), (Object)jsonRecord.get("map2"), (String)"JSON decoder output not same as Binary Decoder");
    }

    public <T> byte[] testSerialization(String testType, T ... entityObjs) throws Exception {
        this.log("---- Beginning " + testType + " ----");
        T entityObj1 = entityObjs[0];
        ReflectData.AllowNull rdata = ReflectData.AllowNull.get();
        Schema schema = rdata.getSchema(entityObj1.getClass());
        Assertions.assertNotNull((Object)schema, (String)("Unable to get schema for " + testType));
        this.log(schema.toString(true));
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(entityObj1.getClass(), (ReflectData)rdata);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)datumWriter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        fileWriter.create(schema, (OutputStream)baos);
        for (T entityObj : entityObjs) {
            fileWriter.append(entityObj);
        }
        fileWriter.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    private <T> List<GenericRecord> testGenericDatumRead(String testType, byte[] bytes, T ... entityObjs) throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader();
        SeekableByteArrayInput avroInputStream = new SeekableByteArrayInput(bytes);
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try (DataFileReader fileReader = new DataFileReader((SeekableInput)avroInputStream, (DatumReader)datumReader);){
            Schema schema = fileReader.getSchema();
            Assertions.assertNotNull((Object)schema, (String)("Unable to get schema for " + testType));
            Object record = null;
            while (fileReader.hasNext()) {
                try {
                    records.add((GenericRecord)fileReader.next(record));
                }
                catch (Exception e) {
                    Assertions.fail((String)("Fail with schema: " + schema));
                }
            }
        }
        return records;
    }

    private <T> List<T> testReflectDatumRead(String testType, byte[] bytes, T ... entityObjs) throws IOException {
        ReflectDatumReader datumReader = new ReflectDatumReader();
        SeekableByteArrayInput avroInputStream = new SeekableByteArrayInput(bytes);
        ArrayList<Object> records = new ArrayList<Object>();
        try (DataFileReader fileReader = new DataFileReader((SeekableInput)avroInputStream, (DatumReader)datumReader);){
            Schema schema = fileReader.getSchema();
            Object record = null;
            while (fileReader.hasNext()) {
                records.add(fileReader.next(record));
            }
        }
        return records;
    }

    private <T> byte[] testJsonEncoder(String testType, T entityObj) throws IOException {
        ReflectData.AllowNull rdata = ReflectData.AllowNull.get();
        Schema schema = rdata.getSchema(entityObj.getClass());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)os);
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(schema, (ReflectData)rdata);
        datumWriter.write(entityObj, (Encoder)encoder);
        encoder.flush();
        byte[] bytes = os.toByteArray();
        System.out.println("JSON encoder output:\n" + new String(bytes, StandardCharsets.UTF_8));
        return bytes;
    }

    private <T> GenericRecord testJsonDecoder(String testType, byte[] bytes, T entityObj) throws IOException {
        ReflectData.AllowNull rdata = ReflectData.AllowNull.get();
        Schema schema = rdata.getSchema(entityObj.getClass());
        GenericDatumReader datumReader = new GenericDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, new String(bytes, StandardCharsets.UTF_8));
        GenericRecord r = (GenericRecord)datumReader.read(null, (Decoder)decoder);
        return r;
    }

    private Company buildCompany() {
        Company co = new Company();
        HashMap<EmployeeId, EmployeeInfo> employees = new HashMap<EmployeeId, EmployeeInfo>();
        co.setEmployees(employees);
        employees.put(new EmployeeId(1), new EmployeeInfo("Foo"));
        employees.put(new EmployeeId(2), new EmployeeInfo("Bar"));
        return co;
    }

    private Company2 buildCompany2() {
        Company2 co = new Company2();
        HashMap<Integer, EmployeeInfo2> employees = new HashMap<Integer, EmployeeInfo2>();
        co.setEmployees(employees);
        EmployeeId2 empId = new EmployeeId2(1);
        EmployeeInfo2 empInfo = new EmployeeInfo2("Foo");
        HashMap<Integer, String> companyMap = new HashMap<Integer, String>();
        empInfo.setCompanyMap(companyMap);
        companyMap.put(14, "CompanyFoo");
        employees.put(11, empInfo);
        return co;
    }

    private SameMapSignature buildSameMapSignature() {
        SameMapSignature obj = new SameMapSignature();
        obj.setMap1(new HashMap<Integer, String>());
        obj.getMap1().put(1, "Foo");
        obj.setMap2(new ConcurrentHashMap<Integer, String>());
        obj.getMap2().put(1, "Foo");
        obj.setMap3(new LinkedHashMap<Integer, String>());
        obj.getMap3().put(1, "Foo");
        obj.setMap4(new TreeMap<Integer, String>());
        obj.getMap4().put(1, "Foo");
        return obj;
    }

    private void log(String msg) {
        System.out.println(msg);
    }
}

