/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestByteBuffer {
    @TempDir
    public File DIR;
    File content;

    @BeforeEach
    public void before() throws IOException {
        this.content = new File(this.DIR.getPath(), "test-content");
        try (FileOutputStream out = new FileOutputStream(this.content);){
            for (int i = 0; i < 100000; ++i) {
                out.write("hello world\n".getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    @Test
    void test() throws Exception {
        Schema schema = ReflectData.get().getSchema(X.class);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeOneXAsAvro(schema, bout);
        X record = this.readOneXFromAvro(schema, bout);
        String expected = this.getmd5(this.content);
        String actual = this.getmd5(record.content);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"md5 for result differed from input");
    }

    private X readOneXFromAvro(Schema schema, ByteArrayOutputStream bout) throws IOException {
        SeekableByteArrayInput input = new SeekableByteArrayInput(bout.toByteArray());
        ReflectDatumReader datumReader = new ReflectDatumReader(schema);
        FileReader reader = DataFileReader.openReader((SeekableInput)input, (DatumReader)datumReader);
        Iterator it = reader.iterator();
        Assertions.assertTrue((boolean)it.hasNext(), (String)"missing first record");
        X record = (X)it.next();
        Assertions.assertFalse((boolean)it.hasNext(), (String)"should be no more records - only wrote one out");
        return record;
    }

    private void writeOneXAsAvro(Schema schema, ByteArrayOutputStream bout) throws IOException, FileNotFoundException {
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(schema);
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)datumWriter);){
            writer.create(schema, (OutputStream)bout);
            X x = new X();
            x.name = "xxx";
            try (FileInputStream fis = new FileInputStream(this.content);
                 FileChannel channel = fis.getChannel();){
                long contentLength = this.content.length();
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, contentLength);
                x.content = buffer;
                writer.append((Object)x);
            }
            writer.flush();
        }
    }

    private String getmd5(File content) throws Exception {
        try (FileInputStream fis = new FileInputStream(content);){
            String string;
            block11: {
                FileChannel channel = fis.getChannel();
                try {
                    long contentLength = content.length();
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, contentLength);
                    string = this.getmd5(buffer);
                    if (channel == null) break block11;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return string;
        }
    }

    String getmd5(ByteBuffer buffer) throws NoSuchAlgorithmException {
        MessageDigest mdEnc = MessageDigest.getInstance("MD5");
        mdEnc.reset();
        mdEnc.update(buffer);
        return new BigInteger(1, mdEnc.digest()).toString(16);
    }

    static class X {
        String name = "";
        ByteBuffer content;

        X() {
        }
    }
}

