/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestInteropSingleObjectEncoding {
    private static final String RESOURCES_FOLDER = System.getProperty("share.dir", "target/test-classes/share") + "/test/data/messageV1";
    private static final File SCHEMA_FILE = new File(RESOURCES_FOLDER + "/test_schema.avsc");
    private static final File MESSAGE_FILE = new File(RESOURCES_FOLDER + "/test_message.bin");
    private static Schema SCHEMA;
    private static GenericRecordBuilder BUILDER;

    @BeforeAll
    public static void setup() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(SCHEMA_FILE);){
            SCHEMA = new Schema.Parser().parse((InputStream)fileInputStream);
            BUILDER = new GenericRecordBuilder(SCHEMA);
        }
    }

    @Test
    void checkSingleObjectEncoding() throws IOException {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA);
        ByteBuffer buffer = encoder.encode((Object)BUILDER.set("id", (Object)42L).set("name", (Object)"Bill").set("tags", Arrays.asList("dog_lover", "cat_hater")).build());
        byte[] fileBuffer = Files.readAllBytes(MESSAGE_FILE.toPath());
        Assertions.assertArrayEquals((byte[])fileBuffer, (byte[])buffer.array());
    }
}

