/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io.parsing;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.TestSchemas;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ValidatingEncoder;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestResolvingGrammarGenerator {
    @ParameterizedTest
    @MethodSource(value={"data"})
    void test(Schema schema, JsonNode data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        EncoderFactory factory = EncoderFactory.get();
        ValidatingEncoder e = factory.validatingEncoder(schema, (Encoder)factory.binaryEncoder((OutputStream)baos, null));
        ResolvingGrammarGenerator.encode((Encoder)e, (Schema)schema, (JsonNode)data);
        e.flush();
    }

    @Test
    void recordMissingRequiredFieldError() throws Exception {
        Schema schemaWithoutField = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"MyRecord").namespace("ns")).fields().name("field1").type().stringType().noDefault().endRecord();
        Schema schemaWithField = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"MyRecord").namespace("ns")).fields().name("field1").type().stringType().noDefault().name("field2").type().stringType().noDefault().endRecord();
        GenericData.Record record = new GenericRecordBuilder(schemaWithoutField).set("field1", (Object)"someValue").build();
        byte[] data = this.writeRecord(schemaWithoutField, record);
        try {
            this.readRecord(schemaWithField, data);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (AvroTypeException typeException) {
            Assertions.assertEquals((Object)"Found ns.MyRecord, expecting ns.MyRecord, missing required field field2", (Object)typeException.getMessage(), (String)"Incorrect exception message");
        }
    }

    @Test
    void differingEnumNamespaces() throws Exception {
        Schema schema1 = (Schema)SchemaBuilder.record((String)"MyRecord").fields().name("field").type(TestSchemas.ENUM1_AB_SCHEMA_NAMESPACE_1).noDefault().endRecord();
        Schema schema2 = (Schema)SchemaBuilder.record((String)"MyRecord").fields().name("field").type(TestSchemas.ENUM1_AB_SCHEMA_NAMESPACE_2).noDefault().endRecord();
        GenericData.EnumSymbol genericEnumSymbol = new GenericData.EnumSymbol(TestSchemas.ENUM1_AB_SCHEMA_NAMESPACE_1, "A");
        GenericData.Record record = new GenericRecordBuilder(schema1).set("field", (Object)genericEnumSymbol).build();
        byte[] data = this.writeRecord(schema1, record);
        Assertions.assertEquals((Object)genericEnumSymbol, (Object)this.readRecord(schema1, data).get("field"));
        Assertions.assertEquals((Object)genericEnumSymbol, (Object)this.readRecord(schema2, data).get("field"));
    }

    public static Stream<Arguments> data() {
        List ret = Arrays.asList({"{ \"type\": \"record\", \"name\": \"r\", \"fields\": [  { \"name\" : \"f1\", \"type\": \"int\" },  { \"name\" : \"f2\", \"type\": \"float\" } ] }", "{ \"f2\": 10.4, \"f1\": 10 } "}, {"{ \"type\": \"enum\", \"name\": \"e\", \"symbols\": [ \"s1\", \"s2\"] }", " \"s1\" "}, {"{ \"type\": \"enum\", \"name\": \"e\", \"symbols\": [ \"s1\", \"s2\"] }", " \"s2\" "}, {"{ \"type\": \"fixed\", \"name\": \"f\", \"size\": 10 }", "\"hello\""}, {"{ \"type\": \"array\", \"items\": \"int\" }", "[ 10, 20, 30 ]"}, {"{ \"type\": \"map\", \"values\": \"int\" }", "{ \"k1\": 10, \"k3\": 20, \"k3\": 30 }"}, {"[ \"int\", \"long\" ]", "10"}, {"\"string\"", "\"hello\""}, {"\"bytes\"", "\"hello\""}, {"\"int\"", "10"}, {"\"long\"", "10"}, {"\"float\"", "10.0"}, {"\"double\"", "10.0"}, {"\"boolean\"", "true"}, {"\"boolean\"", "false"}, {"\"null\"", "null"});
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        return ret.stream().map(args -> {
            Schema schema = new Schema.Parser().parse(args[0]);
            try {
                JsonNode data = mapper.readTree((Reader)new StringReader(args[1]));
                return Arguments.of((Object[])new Object[]{schema, data});
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    private byte[] writeRecord(Schema schema, GenericData.Record record) throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)datumWriter);){
            writer.create(schema, (OutputStream)byteStream);
            writer.append((Object)record);
        }
        return byteStream.toByteArray();
    }

    private GenericData.Record readRecord(Schema schema, byte[] data) throws Exception {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        GenericDatumReader datumReader = new GenericDatumReader(schema);
        try (DataFileStream reader = new DataFileStream((InputStream)byteStream, (DatumReader)datumReader);){
            GenericData.Record record = (GenericData.Record)reader.next();
            return record;
        }
    }
}

