/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io.parsing;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.avro.io.parsing.Symbol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SymbolTest {
    private static final String SCHEMA = "{\"type\":\"record\",\"name\":\"SampleNode\",\"namespace\":\"org.spf4j.ssdump2.avro\",\n \"fields\":[\n    {\"name\":\"count\",\"type\":\"int\",\"default\":0},\n    {\"name\":\"subNodes\",\"type\":\n       {\"type\":\"array\",\"items\":{\n           \"type\":\"record\",\"name\":\"SamplePair\",\n           \"fields\":[\n              {\"name\":\"method\",\"type\":\n                  {\"type\":\"record\",\"name\":\"Method\",\n                  \"fields\":[\n                     {\"name\":\"declaringClass\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\n                     {\"name\":\"methodName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}\n                  ]}},\n              {\"name\":\"node\",\"type\":\"SampleNode\"}]}}}]}";

    @Test
    void someMethod() throws IOException {
        Schema schema = new Schema.Parser().parse(SCHEMA);
        Symbol root = new ResolvingGrammarGenerator().generate(schema, schema);
        SymbolTest.validateNonNull(root, new HashSet<Symbol>());
    }

    private static void validateNonNull(Symbol symb, Set<Symbol> seen) {
        if (seen.contains(symb)) {
            return;
        }
        seen.add(symb);
        if (symb.production != null) {
            for (Symbol s : symb.production) {
                if (s == null) {
                    Assertions.fail((String)"invalid parsing tree should not contain nulls");
                    continue;
                }
                if (s.kind == Symbol.Kind.ROOT) continue;
                SymbolTest.validateNonNull(s, seen);
            }
        }
    }
}

