/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestEncoders {
    private static final int ENCODER_BUFFER_SIZE = 32;
    private static final int EXAMPLE_DATA_SIZE = 17;
    private static final EncoderFactory FACTORY = EncoderFactory.get();
    @TempDir
    public Path dataDir;

    @Test
    void binaryEncoderInit() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder enc = FACTORY.binaryEncoder((OutputStream)out, null);
        Assertions.assertSame((Object)enc, (Object)FACTORY.binaryEncoder((OutputStream)out, enc));
    }

    @Test
    void badBinaryEncoderInit() {
        Assertions.assertThrows(NullPointerException.class, () -> FACTORY.binaryEncoder(null, null));
    }

    @Test
    void blockingBinaryEncoderInit() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder reuse = null;
        reuse = FACTORY.blockingBinaryEncoder((OutputStream)out, reuse);
        Assertions.assertSame((Object)reuse, (Object)FACTORY.blockingBinaryEncoder((OutputStream)out, reuse));
    }

    @Test
    void badBlockintBinaryEncoderInit() {
        Assertions.assertThrows(NullPointerException.class, () -> FACTORY.binaryEncoder(null, null));
    }

    @Test
    void directBinaryEncoderInit() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder enc = FACTORY.directBinaryEncoder((OutputStream)out, null);
        Assertions.assertSame((Object)enc, (Object)FACTORY.directBinaryEncoder((OutputStream)out, enc));
    }

    @Test
    void badDirectBinaryEncoderInit() {
        Assertions.assertThrows(NullPointerException.class, () -> FACTORY.directBinaryEncoder(null, null));
    }

    @Test
    void blockingDirectBinaryEncoderInit() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder enc = FACTORY.blockingDirectBinaryEncoder((OutputStream)out, null);
        Assertions.assertSame((Object)enc, (Object)FACTORY.blockingDirectBinaryEncoder((OutputStream)out, enc));
    }

    @Test
    void badBlockingDirectBinaryEncoderInit() {
        Assertions.assertThrows(NullPointerException.class, () -> FACTORY.blockingDirectBinaryEncoder(null, null));
    }

    @Test
    void jsonEncoderInit() throws IOException {
        Schema s = new Schema.Parser().parse("\"int\"");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FACTORY.jsonEncoder(s, (OutputStream)out);
        JsonEncoder enc = FACTORY.jsonEncoder(s, new JsonFactory().createGenerator((OutputStream)out, JsonEncoding.UTF8));
        enc.configure((OutputStream)out);
    }

    @Test
    void badJsonEncoderInitOS() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> FACTORY.jsonEncoder(Schema.create((Schema.Type)Schema.Type.INT), (OutputStream)null));
    }

    @Test
    void badJsonEncoderInit() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> FACTORY.jsonEncoder(Schema.create((Schema.Type)Schema.Type.INT), (JsonGenerator)null));
    }

    @Test
    void jsonEncoderNewlineDelimited() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Schema ints = Schema.create((Schema.Type)Schema.Type.INT);
        JsonEncoder e = FACTORY.jsonEncoder(ints, (OutputStream)out);
        String separator = System.getProperty("line.separator");
        GenericDatumWriter writer = new GenericDatumWriter(ints);
        writer.write((Object)1, (Encoder)e);
        writer.write((Object)2, (Encoder)e);
        e.flush();
        Assertions.assertEquals((Object)("1" + separator + "2"), (Object)((Object)out).toString());
    }

    @Test
    void jsonEncoderWhenIncludeNamespaceOptionIsFalse() throws IOException {
        String value = "{\"b\": {\"string\":\"myVal\"}, \"a\": 1}";
        String schemaStr = "{\"type\": \"record\", \"name\": \"ab\", \"fields\": [{\"name\": \"a\", \"type\": \"int\"}, {\"name\": \"b\", \"type\": [\"null\", \"string\"]}]}";
        Schema schema = new Schema.Parser().parse(schemaStr);
        byte[] avroBytes = this.fromJsonToAvro(value, schema);
        ObjectMapper mapper = new ObjectMapper();
        Assertions.assertEquals((Object)mapper.readTree("{\"b\":\"myVal\",\"a\":1}"), (Object)mapper.readTree(this.fromAvroToJson(avroBytes, schema, false)));
    }

    @Test
    void jsonEncoderWhenIncludeNamespaceOptionIsTrue() throws IOException {
        String value = "{\"b\": {\"string\":\"myVal\"}, \"a\": 1}";
        String schemaStr = "{\"type\": \"record\", \"name\": \"ab\", \"fields\": [{\"name\": \"a\", \"type\": \"int\"}, {\"name\": \"b\", \"type\": [\"null\", \"string\"]}]}";
        Schema schema = new Schema.Parser().parse(schemaStr);
        byte[] avroBytes = this.fromJsonToAvro(value, schema);
        ObjectMapper mapper = new ObjectMapper();
        Assertions.assertEquals((Object)mapper.readTree("{\"b\":{\"string\":\"myVal\"},\"a\":1}"), (Object)mapper.readTree(this.fromAvroToJson(avroBytes, schema, true)));
    }

    @Test
    void validatingEncoderInit() throws IOException {
        Schema s = new Schema.Parser().parse("\"int\"");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e = FACTORY.directBinaryEncoder((OutputStream)out, null);
        FACTORY.validatingEncoder(s, (Encoder)e).configure((Encoder)e);
    }

    @Test
    void jsonRecordOrdering() throws IOException {
        String value = "{\"b\": 2, \"a\": 1}";
        Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [{\"name\": \"a\", \"type\": \"int\"}, {\"name\": \"b\", \"type\": \"int\"}]}");
        GenericDatumReader reader = new GenericDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assertions.assertEquals((Object)"{\"a\": 1, \"b\": 2}", (Object)o.toString());
    }

    @Test
    void jsonExcessFields() throws IOException {
        Assertions.assertThrows(AvroTypeException.class, () -> {
            String value = "{\"b\": { \"b3\": 1.4, \"b2\": 3.14, \"b1\": \"h\"}, \"a\": {\"a0\": 45, \"a2\":true, \"a1\": null}}";
            Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":\"float\"}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
            GenericDatumReader reader = new GenericDatumReader(schema);
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, value);
            reader.read(null, (Decoder)decoder);
        });
    }

    @Test
    void jsonRecordOrdering2() throws IOException {
        String value = "{\"b\": { \"b3\": 1.4, \"b2\": 3.14, \"b1\": \"h\"}, \"a\": {\"a2\":true, \"a1\": null}}";
        Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":\"float\"}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
        GenericDatumReader reader = new GenericDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assertions.assertEquals((Object)"{\"a\": {\"a1\": null, \"a2\": true}, \"b\": {\"b1\": \"h\", \"b2\": 3.14, \"b3\": 1.4}}", (Object)o.toString());
    }

    @Test
    void jsonRecordOrderingWithProjection() throws IOException {
        String value = "{\"b\": { \"b3\": 1.4, \"b2\": 3.14, \"b1\": \"h\"}, \"a\": {\"a2\":true, \"a1\": null}}";
        Schema writerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":\"float\"}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
        Schema readerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}}\n]}");
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(writerSchema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assertions.assertEquals((Object)"{\"a\": {\"a1\": null, \"a2\": true}}", (Object)o.toString());
    }

    @Test
    void jsonRecordOrderingWithProjection2() throws IOException {
        String value = "{\"b\": { \"b1\": \"h\", \"b2\": [3.14, 3.56], \"b3\": 1.4}, \"a\": {\"a2\":true, \"a1\": null}}";
        Schema writerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":{\"type\":\"array\", \"items\":\"float\"}}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
        Schema readerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}}\n]}");
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(writerSchema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assertions.assertEquals((Object)"{\"a\": {\"a1\": null, \"a2\": true}}", (Object)o.toString());
    }

    @Test
    void arrayBackedByteBuffer() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(this.someBytes(17));
        this.testWithBuffer(buffer);
    }

    @Test
    void mappedByteBuffer() throws IOException {
        Path file = this.dataDir.resolve("testMappedByteBuffer.avro");
        Files.write(file, this.someBytes(17), new OpenOption[0]);
        MappedByteBuffer buffer = FileChannel.open(file, StandardOpenOption.READ).map(FileChannel.MapMode.READ_ONLY, 0L, 17L);
        this.testWithBuffer(buffer);
    }

    private void testWithBuffer(ByteBuffer buffer) throws IOException {
        MatcherAssert.assertThat(Arrays.asList(buffer.position(), buffer.remaining()), (Matcher)Matchers.is(Arrays.asList(0, 17)));
        ByteArrayOutputStream output = new ByteArrayOutputStream(34);
        EncoderFactory encoderFactory = new EncoderFactory();
        encoderFactory.configureBufferSize(32);
        BinaryEncoder encoder = encoderFactory.binaryEncoder((OutputStream)output, null);
        new GenericDatumWriter(Schema.create((Schema.Type)Schema.Type.BYTES)).write((Object)buffer, (Encoder)encoder);
        encoder.flush();
        MatcherAssert.assertThat((Object)output.toByteArray(), (Matcher)Matchers.equalTo((Object)this.avroEncoded(this.someBytes(17))));
        MatcherAssert.assertThat(Arrays.asList(buffer.position(), buffer.remaining()), (Matcher)Matchers.is(Arrays.asList(0, 17)));
    }

    private byte[] someBytes(int size) {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)i;
        }
        return result;
    }

    private byte[] avroEncoded(byte[] bytes) {
        assert (bytes.length < 64);
        byte[] result = new byte[1 + bytes.length];
        result[0] = (byte)(bytes.length * 2);
        System.arraycopy(bytes, 0, result, 1, bytes.length);
        return result;
    }

    private byte[] fromJsonToAvro(String json, Schema schema) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(schema);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, json);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)output, null);
        Object datum = reader.read(null, (Decoder)decoder);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        return output.toByteArray();
    }

    private String fromAvroToJson(byte[] avroBytes, Schema schema, boolean includeNamespace) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(schema);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JsonEncoder encoder = FACTORY.jsonEncoder(schema, (OutputStream)output);
        encoder.setIncludeNamespace(includeNamespace);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(avroBytes, null);
        Object datum = reader.read(null, (Decoder)decoder);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        output.flush();
        return new String(output.toByteArray(), StandardCharsets.UTF_8.name());
    }

    @Test
    public void testJsonEncoderInitAutoFlush() throws IOException {
        Schema s = new Schema.Parser().parse("\"int\"");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream(baos);
        JsonEncoder enc = FACTORY.jsonEncoder(s, (OutputStream)out, false);
        enc.configure((OutputStream)out, false);
        enc.writeInt(24);
        enc.flush();
        Assertions.assertEquals((Object)"", (Object)((Object)baos).toString());
        ((OutputStream)out).flush();
        Assertions.assertEquals((Object)"24", (Object)((Object)baos).toString());
    }

    @Test
    public void testJsonEncoderInitAutoFlushDisabled() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream(baos);
        Schema ints = Schema.create((Schema.Type)Schema.Type.INT);
        JsonEncoder e = FACTORY.jsonEncoder(ints, (OutputStream)out, false, false);
        String separator = System.getProperty("line.separator");
        GenericDatumWriter writer = new GenericDatumWriter(ints);
        writer.write((Object)1, (Encoder)e);
        writer.write((Object)2, (Encoder)e);
        e.flush();
        Assertions.assertEquals((Object)"", (Object)baos.toString());
        ((OutputStream)out).flush();
        Assertions.assertEquals((Object)("1" + separator + "2"), (Object)baos.toString());
        ((OutputStream)out).close();
    }
}

