/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.specific.TestRecordWithMapsAndArrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestBlockingDirectBinaryEncoder {
    private void writeToArray(BinaryEncoder encoder, int[] numbers) throws IOException {
        encoder.writeArrayStart();
        encoder.setItemCount((long)numbers.length);
        for (int number : numbers) {
            encoder.startItem();
            encoder.writeString(Integer.toString(number));
        }
        encoder.writeArrayEnd();
    }

    private void writeToMap(BinaryEncoder encoder, long[] numbers) throws IOException {
        encoder.writeMapStart();
        encoder.setItemCount((long)numbers.length);
        for (long number : numbers) {
            encoder.startItem();
            encoder.writeString(Long.toString(number));
            encoder.writeLong(number);
        }
        encoder.writeMapEnd();
    }

    @Test
    void blockingDirectBinaryEncoder() throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().blockingDirectBinaryEncoder((OutputStream)baos, null);
        encoder.writeFixed(new byte[]{-61, 1});
        encoder.writeFixed(SchemaNormalization.parsingFingerprint((String)"CRC-64-AVRO", (Schema)TestRecordWithMapsAndArrays.SCHEMA$));
        this.writeToArray(encoder, new int[]{1, 2, 3, 4, 5});
        this.writeToMap(encoder, new long[]{1L, 2L, 3L, 4L, 5L});
        encoder.writeArrayStart();
        encoder.setItemCount(2L);
        this.writeToArray(encoder, new int[]{1, 2});
        this.writeToArray(encoder, new int[]{3, 4, 5});
        encoder.writeArrayEnd();
        encoder.writeMapStart();
        encoder.setItemCount(2L);
        encoder.writeString("first");
        this.writeToMap(encoder, new long[]{1L, 2L});
        encoder.writeString("second");
        this.writeToMap(encoder, new long[]{3L, 4L, 5L});
        encoder.writeMapEnd();
        encoder.flush();
        BinaryMessageDecoder<TestRecordWithMapsAndArrays> decoder = TestRecordWithMapsAndArrays.getDecoder();
        TestRecordWithMapsAndArrays r = (TestRecordWithMapsAndArrays)((Object)decoder.decode(baos.toByteArray()));
        MatcherAssert.assertThat(r.getArr(), (Matcher)Matchers.is(Arrays.asList("1", "2", "3", "4", "5")));
        Map<String, Long> map = r.getMap();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)5));
        for (long i = 1L; i <= 5L; ++i) {
            MatcherAssert.assertThat((Object)map.get(Long.toString(i)), (Matcher)Matchers.is((Object)i));
        }
        MatcherAssert.assertThat(r.getNestedArr(), (Matcher)Matchers.is(Arrays.asList(Arrays.asList("1", "2"), Arrays.asList("3", "4", "5"))));
        Map<String, Map<String, Long>> nestedMap = r.getNestedMap();
        MatcherAssert.assertThat((Object)nestedMap.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)nestedMap.get("first").size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)nestedMap.get("first").get("1"), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)nestedMap.get("first").get("2"), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)nestedMap.get("second").size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)nestedMap.get("second").get("3"), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((Object)nestedMap.get("second").get("4"), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)nestedMap.get("second").get("5"), (Matcher)Matchers.is((Object)5L));
    }

    @Test
    void testSkippingUsingBlocks() throws IOException, NoSuchAlgorithmException {
        Schema emptySchema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TestRecordWithMapsAndArrays\",\"namespace\":\"org.apache.avro.specific\",\"fields\":[]}");
        GenericDatumReader in = new GenericDatumReader(TestRecordWithMapsAndArrays.SCHEMA$, emptySchema);
        Decoder mockDecoder = (Decoder)Mockito.mock(BinaryDecoder.class);
        for (long i = 0L; i < 1L; ++i) {
            in.read(null, mockDecoder);
        }
        ((Decoder)Mockito.verify((Object)mockDecoder, (VerificationMode)Mockito.times((int)2))).skipMap();
        ((Decoder)Mockito.verify((Object)mockDecoder, (VerificationMode)Mockito.times((int)2))).skipArray();
        ((Decoder)Mockito.verify((Object)mockDecoder, (VerificationMode)Mockito.times((int)0))).readString();
        ((Decoder)Mockito.verify((Object)mockDecoder, (VerificationMode)Mockito.times((int)0))).readLong();
    }
}

