/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.LegacyBinaryEncoder;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestBinaryEncoderFidelity {
    static byte[] legacydata;
    static byte[] complexdata;
    EncoderFactory factory = EncoderFactory.get();

    public static void generateData(Encoder e, boolean useReadOnlyByteBuffer) throws IOException {
        Random r = new Random(665321L);
        e.writeNull();
        e.writeBoolean(true);
        e.writeBoolean(false);
        byte[] bytes = new byte[10];
        ByteBuffer bb = useReadOnlyByteBuffer ? ByteBuffer.wrap(bytes, 4, 4).asReadOnlyBuffer() : ByteBuffer.wrap(bytes, 4, 4);
        r.nextBytes(bytes);
        e.writeBytes(bytes);
        e.writeBytes(new byte[0]);
        e.writeBytes(bytes, 3, 3);
        e.writeBytes(new byte[0], 0, 0);
        e.writeBytes(ByteBuffer.wrap(bytes, 2, 2));
        e.writeBytes(bb);
        e.writeBytes(bb);
        e.writeDouble(0.0);
        e.writeDouble(-0.0);
        e.writeDouble(Double.NaN);
        e.writeDouble(r.nextDouble());
        e.writeDouble(Double.NEGATIVE_INFINITY);
        e.writeEnum(65);
        e.writeFixed(bytes);
        e.writeFixed(bytes, 7, 2);
        e.writeFloat(1.0f);
        e.writeFloat(r.nextFloat());
        e.writeFloat(Float.POSITIVE_INFINITY);
        e.writeFloat(Float.MIN_NORMAL);
        e.writeIndex(-2);
        e.writeInt(0);
        e.writeInt(-1);
        e.writeInt(1);
        e.writeInt(64);
        e.writeInt(-65);
        e.writeInt(8192);
        e.writeInt(-8193);
        e.writeInt(524288);
        e.writeInt(-524289);
        e.writeInt(0x4000000);
        e.writeInt(-67108865);
        e.writeInt(r.nextInt());
        e.writeInt(r.nextInt());
        e.writeInt(Integer.MAX_VALUE);
        e.writeInt(Integer.MIN_VALUE);
        e.writeLong(0L);
        e.writeLong(-1L);
        e.writeLong(1L);
        e.writeLong(64L);
        e.writeLong(-65L);
        e.writeLong(8192L);
        e.writeLong(-8193L);
        e.writeLong(524288L);
        e.writeLong(-524289L);
        e.writeLong(0x4000000L);
        e.writeLong(-67108865L);
        e.writeLong(0x200000000L);
        e.writeLong(-8589934593L);
        e.writeLong(0x10000000000L);
        e.writeLong(-1099511627777L);
        e.writeLong(0x800000000000L);
        e.writeLong(-140737488355329L);
        e.writeLong(0x40000000000000L);
        e.writeLong(-18014398509481985L);
        e.writeLong(0x2000000000000000L);
        e.writeLong(-2305843009213693953L);
        e.writeLong(r.nextLong());
        e.writeLong(r.nextLong());
        e.writeLong(Long.MAX_VALUE);
        e.writeLong(Long.MIN_VALUE);
        e.writeString((CharSequence)new StringBuilder("StringBuilder\u00a2"));
        e.writeString("String\u20ac");
        e.writeString("");
        e.writeString(new Utf8("Utf8\ud834\udd1e"));
        if (e instanceof BinaryEncoder) {
            int count = ((BinaryEncoder)e).bytesBuffered();
            System.out.println(e.getClass().getSimpleName() + " buffered: " + count);
        }
        e.flush();
    }

    static void generateComplexData(Encoder e) throws IOException {
        e.writeArrayStart();
        e.setItemCount(1L);
        e.startItem();
        e.writeInt(1);
        e.writeArrayEnd();
        e.writeMapStart();
        e.setItemCount(2L);
        e.startItem();
        e.writeString("foo");
        e.writeInt(-1);
        e.writeDouble(33.3);
        e.startItem();
        e.writeString("bar");
        e.writeInt(1);
        e.writeDouble(-33.3);
        e.writeMapEnd();
        e.flush();
    }

    @BeforeAll
    public static void generateLegacyData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LegacyBinaryEncoder e = new LegacyBinaryEncoder(baos);
        TestBinaryEncoderFidelity.generateData(e, false);
        legacydata = baos.toByteArray();
        baos.reset();
        TestBinaryEncoderFidelity.generateComplexData(e);
        complexdata = baos.toByteArray();
    }

    @Test
    void binaryEncoder() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder e = this.factory.binaryEncoder((OutputStream)baos, null);
        TestBinaryEncoderFidelity.generateData((Encoder)e, true);
        byte[] result = baos.toByteArray();
        Assertions.assertEquals((int)legacydata.length, (int)result.length);
        Assertions.assertArrayEquals((byte[])legacydata, (byte[])result);
        baos.reset();
        TestBinaryEncoderFidelity.generateComplexData((Encoder)e);
        byte[] result2 = baos.toByteArray();
        Assertions.assertEquals((int)complexdata.length, (int)result2.length);
        Assertions.assertArrayEquals((byte[])complexdata, (byte[])result2);
    }

    @Test
    void directBinaryEncoder() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder e = this.factory.directBinaryEncoder((OutputStream)baos, null);
        TestBinaryEncoderFidelity.generateData((Encoder)e, true);
        byte[] result = baos.toByteArray();
        Assertions.assertEquals((int)legacydata.length, (int)result.length);
        Assertions.assertArrayEquals((byte[])legacydata, (byte[])result);
        baos.reset();
        TestBinaryEncoderFidelity.generateComplexData((Encoder)e);
        byte[] result2 = baos.toByteArray();
        Assertions.assertEquals((int)complexdata.length, (int)result2.length);
        Assertions.assertArrayEquals((byte[])complexdata, (byte[])result2);
    }

    @Test
    void blockingDirectBinaryEncoder() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder e = this.factory.blockingDirectBinaryEncoder((OutputStream)baos, null);
        TestBinaryEncoderFidelity.generateData((Encoder)e, true);
        byte[] result = baos.toByteArray();
        Assertions.assertEquals((int)legacydata.length, (int)result.length);
        Assertions.assertArrayEquals((byte[])legacydata, (byte[])result);
        baos.reset();
        TestBinaryEncoderFidelity.generateComplexData((Encoder)e);
        byte[] result2 = baos.toByteArray();
        Assertions.assertEquals((int)(complexdata.length + 2), (int)result2.length);
        Assertions.assertEquals((int)(complexdata[0] >>> 1), (int)result2[0]);
        baos.reset();
        e.writeArrayStart();
        e.setItemCount(1L);
        e.startItem();
        e.writeInt(1);
        e.writeArrayEnd();
        Assertions.assertArrayEquals((byte[])baos.toByteArray(), (byte[])new byte[]{1, 2, 2, 0});
        baos.reset();
        e.writeArrayStart();
        e.setItemCount(0L);
        e.writeArrayEnd();
        Assertions.assertArrayEquals((byte[])baos.toByteArray(), (byte[])new byte[]{0});
        baos.reset();
    }

    @Test
    void blockingBinaryEncoder() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder e = this.factory.blockingBinaryEncoder((OutputStream)baos, null);
        TestBinaryEncoderFidelity.generateData((Encoder)e, true);
        byte[] result = baos.toByteArray();
        Assertions.assertEquals((int)legacydata.length, (int)result.length);
        Assertions.assertArrayEquals((byte[])legacydata, (byte[])result);
        baos.reset();
        TestBinaryEncoderFidelity.generateComplexData((Encoder)e);
        byte[] result2 = baos.toByteArray();
        Assertions.assertEquals((int)(complexdata.length + 2), (int)result2.length);
        Assertions.assertEquals((int)(complexdata[0] >>> 1), (int)result2[0]);
    }
}

