/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ValidatingDecoder;
import org.apache.avro.io.ValidatingEncoder;
import org.junit.jupiter.api.Test;

public class TestSkipEnumSchema {
    @Test
    void skipEnum() throws IOException {
        Schema enumSchema = (Schema)SchemaBuilder.builder().enumeration("enum").symbols(new String[]{"en1", "en2"});
        GenericData.EnumSymbol enumSymbol = new GenericData.EnumSymbol(enumSchema, "en1");
        GenericDatumWriter datumWriter = new GenericDatumWriter(enumSchema);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ValidatingEncoder encoder = EncoderFactory.get().validatingEncoder(enumSchema, (Encoder)EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null));
        datumWriter.write((Object)enumSymbol, (Encoder)encoder);
        encoder.flush();
        ValidatingDecoder decoder = DecoderFactory.get().validatingDecoder(enumSchema, (Decoder)DecoderFactory.get().binaryDecoder(byteArrayOutputStream.toByteArray(), null));
        GenericDatumReader.skip((Schema)enumSchema, (Decoder)decoder);
    }
}

