/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.TestCircularReferences;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryData;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGenericData {
    @Test
    void recordConstructorNullSchema() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> new GenericData.Record(null));
    }

    @Test
    void recordConstructorWrongSchema() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> new GenericData.Record(Schema.create((Schema.Type)Schema.Type.INT)));
    }

    @Test
    void arrayConstructorNullSchema() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> new GenericData.Array(1, null));
    }

    @Test
    void arrayConstructorWrongSchema() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> new GenericData.Array(1, Schema.create((Schema.Type)Schema.Type.INT)));
    }

    @Test
    void recordCreateEmptySchema() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> {
            Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
            new GenericData.Record(s);
        });
    }

    @Test
    void getEmptySchemaFields() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> {
            Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
            s.getFields();
        });
    }

    @Test
    void getEmptySchemaField() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> {
            Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
            s.getField("foo");
        });
    }

    @Test
    void recordPutInvalidField() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> {
            Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            fields.add(new Schema.Field("someFieldName", s, "docs", null));
            s.setFields(fields);
            GenericData.Record r = new GenericData.Record(s);
            r.put("invalidFieldName", (Object)"someValue");
        });
    }

    @Test
    void testHashCode() {
        GenericData.get().hashCode(null, Schema.create((Schema.Type)Schema.Type.NULL));
        GenericData.get().hashCode(null, Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.STRING))));
        ArrayList<String> stuff = new ArrayList<String>();
        stuff.add("string");
        Schema schema = this.recordSchema();
        GenericData.Record r = new GenericData.Record(schema);
        r.put(0, stuff);
        GenericData.get().hashCode((Object)r, schema);
    }

    @Test
    void testEquals() {
        Schema s = this.recordSchema();
        GenericData.Record r0 = new GenericData.Record(s);
        GenericData.Record r1 = new GenericData.Record(s);
        GenericData.Record r2 = new GenericData.Record(s);
        ArrayDeque<StringBuilder> l0 = new ArrayDeque<StringBuilder>();
        ArrayList<String> l1 = new ArrayList<String>();
        GenericData.Array l2 = new GenericData.Array(1, ((Schema.Field)s.getFields().get(0)).schema());
        String foo = "foo";
        l0.add(new StringBuilder(foo));
        l1.add(foo);
        l2.add((Object)new Utf8(foo));
        r0.put(0, l0);
        r1.put(0, l1);
        r2.put(0, (Object)l2);
        Assertions.assertEquals((Object)r0, (Object)r1);
        Assertions.assertEquals((Object)r0, (Object)r2);
        Assertions.assertEquals((Object)r1, (Object)r2);
    }

    @Test
    public void testMapKeyEqualsStringAndUtf8Compatibility() {
        Schema.Field myMapField = new Schema.Field("my_map", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myMapField));
        GenericData.Record r0 = new GenericData.Record(schema);
        GenericData.Record r1 = new GenericData.Record(schema);
        HashMap<String, String> pair1 = new HashMap<String, String>();
        pair1.put("keyOne", "valueOne");
        r0.put("my_map", pair1);
        HashMap<Utf8, String> pair2 = new HashMap<Utf8, String>();
        pair2.put(new Utf8("keyOne"), "valueOne");
        r1.put("my_map", pair2);
        Assertions.assertEquals((Object)r0, (Object)r1);
        Assertions.assertEquals((Object)r1, (Object)r0);
    }

    @Test
    public void testMapValuesEqualsStringAndUtf8Compatibility() {
        Schema.Field myMapField = new Schema.Field("my_map", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myMapField));
        GenericData.Record r0 = new GenericData.Record(schema);
        GenericData.Record r1 = new GenericData.Record(schema);
        HashMap<String, String> pair1 = new HashMap<String, String>();
        pair1.put("keyOne", "valueOne");
        r0.put("my_map", pair1);
        HashMap<String, Utf8> pair2 = new HashMap<String, Utf8>();
        pair2.put("keyOne", new Utf8("valueOne"));
        r1.put("my_map", pair2);
        Assertions.assertEquals((Object)r0, (Object)r1);
        Assertions.assertEquals((Object)r1, (Object)r0);
    }

    @Test
    public void testEqualsEmptyMaps() {
        Schema.Field myMapField = new Schema.Field("my_map", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myMapField));
        GenericData.Record r0 = new GenericData.Record(schema);
        r0.put("my_map", new HashMap());
        GenericData.Record r1 = new GenericData.Record(schema);
        r1.put("my_map", new HashMap());
        Assertions.assertEquals((Object)r0, (Object)r1);
        Assertions.assertEquals((Object)r1, (Object)r0);
    }

    @Test
    public void testEqualsEmptyMapAndNonEmptyMap() {
        Schema.Field myMapField = new Schema.Field("my_map", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myMapField));
        GenericData.Record r0 = new GenericData.Record(schema);
        r0.put("my_map", new HashMap());
        GenericData.Record r1 = new GenericData.Record(schema);
        HashMap<String, String> pair1 = new HashMap<String, String>();
        pair1.put("keyOne", "valueOne");
        r1.put("my_map", pair1);
        Assertions.assertNotEquals((Object)r0, (Object)r1);
        Assertions.assertNotEquals((Object)r1, (Object)r0);
    }

    @Test
    public void testEqualsMapAndSubset() {
        Schema.Field myMapField = new Schema.Field("my_map", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myMapField));
        GenericData.Record r0 = new GenericData.Record(schema);
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("keyOne", "valueOne");
        m1.put("keyTwo", "valueTwo");
        r0.put("my_map", m1);
        GenericData.Record r1 = new GenericData.Record(schema);
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("keyOne", "valueOne");
        r1.put("my_map", m2);
        Assertions.assertNotEquals((Object)r0, (Object)r1);
        Assertions.assertNotEquals((Object)r1, (Object)r0);
    }

    @Test
    public void testEqualsMapAndSameSizeMapWithDifferentKeys() {
        Schema.Field myMapField = new Schema.Field("my_map", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myMapField));
        GenericData.Record r0 = new GenericData.Record(schema);
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("keyOne", "valueOne");
        r0.put("my_map", m1);
        GenericData.Record r1 = new GenericData.Record(schema);
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("keyTwo", "valueTwo");
        r1.put("my_map", m2);
        Assertions.assertNotEquals((Object)r0, (Object)r1);
        Assertions.assertNotEquals((Object)r1, (Object)r0);
    }

    @Test
    public void testEqualsMapAndSameSizeMapWithDifferentValues() {
        Schema.Field myMapField = new Schema.Field("my_map", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myMapField));
        GenericData.Record r0 = new GenericData.Record(schema);
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("keyOne", "valueOne");
        r0.put("my_map", m1);
        GenericData.Record r1 = new GenericData.Record(schema);
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("keyOne", "valueTwo");
        r1.put("my_map", m2);
        Assertions.assertNotEquals((Object)r0, (Object)r1);
        Assertions.assertNotEquals((Object)r1, (Object)r0);
    }

    @Test
    public void testArrayValuesEqualsStringAndUtf8Compatibility() {
        Schema.Field myArrayField = new Schema.Field("my_array", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(myArrayField));
        GenericData.Record r0 = new GenericData.Record(schema);
        GenericData.Record r1 = new GenericData.Record(schema);
        List<CharSequence> array1 = Arrays.asList("valueOne");
        r0.put("my_array", array1);
        List<CharSequence> array2 = Arrays.asList(new Utf8("valueOne"));
        r1.put("my_array", array2);
        Assertions.assertEquals((Object)r0, (Object)r1);
        Assertions.assertEquals((Object)r1, (Object)r0);
    }

    private Schema recordSchema() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("anArray", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        Schema schema = Schema.createRecord((String)"arrayFoo", (String)"test", (String)"mytest", (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    @Test
    void equals2() {
        Schema schema1 = Schema.createRecord((String)"r", null, (String)"x", (boolean)false);
        ArrayList<Schema.Field> fields1 = new ArrayList<Schema.Field>();
        fields1.add(new Schema.Field("a", Schema.create((Schema.Type)Schema.Type.STRING), null, null, Schema.Field.Order.IGNORE));
        schema1.setFields(fields1);
        Schema schema2 = Schema.createRecord((String)"r", null, (String)"x", (boolean)false);
        ArrayList<Schema.Field> fields2 = new ArrayList<Schema.Field>();
        fields2.add(new Schema.Field("a", Schema.create((Schema.Type)Schema.Type.STRING), null, null, Schema.Field.Order.ASCENDING));
        schema2.setFields(fields2);
        GenericData.Record record1 = new GenericData.Record(schema1);
        record1.put("a", (Object)"1");
        GenericData.Record record2 = new GenericData.Record(schema2);
        record2.put("a", (Object)"2");
        Assertions.assertNotEquals((Object)record2, (Object)record1);
        Assertions.assertNotEquals((Object)record1, (Object)record2);
    }

    @Test
    void recordGetFieldDoesntExist() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> {
            Schema schema = Schema.createRecord((String)"test", (String)"doc", (String)"test", (boolean)false, (List)Collections.EMPTY_LIST);
            GenericData.Record record = new GenericData.Record(schema);
            record.get("does not exist");
        });
    }

    @Test
    void arrayReversal() {
        int i;
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array forward = new GenericData.Array(10, schema);
        GenericData.Array backward = new GenericData.Array(10, schema);
        for (i = 0; i <= 9; ++i) {
            forward.add((Object)i);
        }
        for (i = 9; i >= 0; --i) {
            backward.add((Object)i);
        }
        forward.reverse();
        Assertions.assertEquals((Object)forward, (Object)backward);
    }

    @Test
    void arrayListInterface() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(1, schema);
        array.add((Object)99);
        Assertions.assertEquals((Integer)99, (Integer)((Integer)array.get(0)));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(99);
        Assertions.assertEquals((Object)array, list);
        Assertions.assertEquals(list, (Object)array);
        Assertions.assertEquals((int)list.hashCode(), (int)array.hashCode());
        try {
            array.get(2);
            Assertions.fail((String)"Expected IndexOutOfBoundsException getting index 2");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        array.clear();
        Assertions.assertEquals((int)0, (int)array.size());
        try {
            array.get(0);
            Assertions.fail((String)"Expected IndexOutOfBoundsException getting index 0 after clear()");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    void arrayAddAtLocation() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(6, schema);
        array.clear();
        for (int i = 0; i < 5; ++i) {
            array.add((Object)i);
        }
        Assertions.assertEquals((int)5, (int)array.size());
        array.add(0, (Object)6);
        Assertions.assertEquals((Integer)6, (Integer)((Integer)array.get(0)));
        Assertions.assertEquals((int)6, (int)array.size());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)array.get(1)));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)array.get(5)));
        array.add(6, (Object)7);
        Assertions.assertEquals((Integer)7, (Integer)((Integer)array.get(6)));
        Assertions.assertEquals((int)7, (int)array.size());
        Assertions.assertEquals((Integer)6, (Integer)((Integer)array.get(0)));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)array.get(5)));
        array.add(1, (Object)8);
        Assertions.assertEquals((Integer)8, (Integer)((Integer)array.get(1)));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)array.get(2)));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)array.get(0)));
        Assertions.assertEquals((int)8, (int)array.size());
        try {
            array.get(9);
            Assertions.fail((String)"Expected IndexOutOfBoundsException after adding elements");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    void arrayRemove() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(10, schema);
        array.clear();
        for (int i = 0; i < 10; ++i) {
            array.add((Object)i);
        }
        Assertions.assertEquals((int)10, (int)array.size());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)array.get(0)));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)array.get(9)));
        array.remove(0);
        Assertions.assertEquals((int)9, (int)array.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)array.get(0)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)array.get(1)));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)array.get(8)));
        try {
            array.get(9);
            Assertions.fail((String)"Expected IndexOutOfBoundsException after removing an element");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            array.set(9, (Object)99);
            Assertions.fail((String)"Expected IndexOutOfBoundsException after removing an element");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            array.remove(9);
            Assertions.fail((String)"Expected IndexOutOfBoundsException after removing an element");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assertions.assertEquals((Integer)9, (Integer)((Integer)array.remove(8)));
        Assertions.assertEquals((int)8, (int)array.size());
        array.add((Object)88);
        Assertions.assertEquals((Integer)88, (Integer)((Integer)array.get(8)));
    }

    @Test
    void arraySet() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(10, schema);
        array.clear();
        for (int i = 0; i < 10; ++i) {
            array.add((Object)i);
        }
        Assertions.assertEquals((int)10, (int)array.size());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)array.get(0)));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)array.get(5)));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)array.set(5, (Object)55)));
        Assertions.assertEquals((int)10, (int)array.size());
        Assertions.assertEquals((Integer)55, (Integer)((Integer)array.get(5)));
    }

    @Test
    void toStringIsJson() throws JsonParseException, IOException {
        Schema.Field stringField = new Schema.Field("string", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field enumField = new Schema.Field("enum", Schema.createEnum((String)"my_enum", (String)"doc", null, Arrays.asList("a", "b", "c")), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(stringField, enumField));
        GenericData.Record r = new GenericData.Record(schema);
        r.put(stringField.name(), (Object)"hello\nthere\"\tyou\u2013}");
        r.put(enumField.name(), (Object)new GenericData.EnumSymbol(enumField.schema(), "a"));
        String json = r.toString();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(json);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readTree(parser);
    }

    @Test
    void mapWithNonStringKeyToStringIsJson() throws Exception {
        Schema intMapSchema = new Schema.Parser().parse("{\"type\": \"map\", \"values\": \"string\", \"java-key-class\" : \"java.lang.Integer\"}");
        Schema.Field intMapField = new Schema.Field("intMap", Schema.createMap((Schema)intMapSchema), null, null);
        Schema decMapSchema = new Schema.Parser().parse("{\"type\": \"map\", \"values\": \"string\", \"java-key-class\" : \"java.math.BigDecimal\"}");
        Schema.Field decMapField = new Schema.Field("decMap", Schema.createMap((Schema)decMapSchema), null, null);
        Schema boolMapSchema = new Schema.Parser().parse("{\"type\": \"map\", \"values\": \"string\", \"java-key-class\" : \"java.lang.Boolean\"}");
        Schema.Field boolMapField = new Schema.Field("boolMap", Schema.createMap((Schema)boolMapSchema), null, null);
        Schema fileMapSchema = new Schema.Parser().parse("{\"type\": \"map\", \"values\": \"string\", \"java-key-class\" : \"java.io.File\"}");
        Schema.Field fileMapField = new Schema.Field("fileMap", Schema.createMap((Schema)fileMapSchema), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(intMapField, decMapField, boolMapField, fileMapField));
        HashMap<Integer, String> intPair = new HashMap<Integer, String>();
        intPair.put(1, "one");
        intPair.put(2, "two");
        HashMap<BigDecimal, String> decPair = new HashMap<BigDecimal, String>();
        decPair.put(BigDecimal.valueOf(1L), "one");
        decPair.put(BigDecimal.valueOf(2L), "two");
        HashMap<Boolean, String> boolPair = new HashMap<Boolean, String>();
        boolPair.put(true, "isTrue");
        boolPair.put(false, "isFalse");
        boolPair.put(null, null);
        HashMap<File, String> filePair = new HashMap<File, String>();
        File f = new File(this.getClass().getResource("/SchemaBuilder.avsc").toURI());
        filePair.put(f, "File");
        GenericData.Record r = new GenericData.Record(schema);
        r.put(intMapField.name(), intPair);
        r.put(decMapField.name(), decPair);
        r.put(boolMapField.name(), boolPair);
        r.put(fileMapField.name(), filePair);
        String json = r.toString();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(json);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readTree(parser);
    }

    @Test
    void toStringEscapesControlCharsInBytes() throws Exception {
        GenericData data = GenericData.get();
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 10, 98});
        Assertions.assertEquals((Object)"\"a\\nb\"", (Object)data.toString((Object)bytes));
        Assertions.assertEquals((Object)"\"a\\nb\"", (Object)data.toString((Object)bytes));
    }

    @Test
    void toStringEscapesControlCharsInMap() {
        GenericData data = GenericData.get();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a\n\\b", "a\n\\b");
        Assertions.assertEquals((Object)"{\"a\\n\\\\b\": \"a\\n\\\\b\"}", (Object)data.toString(m));
    }

    @Test
    void toStringFixed() throws Exception {
        GenericData data = GenericData.get();
        Assertions.assertEquals((Object)"[97, 10, 98]", (Object)data.toString((Object)new GenericData.Fixed(Schema.createFixed((String)"test", null, null, (int)3), new byte[]{97, 10, 98})));
    }

    @Test
    void toStringDoesNotEscapeForwardSlash() throws Exception {
        GenericData data = GenericData.get();
        Assertions.assertEquals((Object)"\"/\"", (Object)data.toString((Object)"/"));
    }

    @Test
    void toStringNanInfinity() throws Exception {
        GenericData data = GenericData.get();
        Assertions.assertEquals((Object)"\"Infinity\"", (Object)data.toString((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        Assertions.assertEquals((Object)"\"-Infinity\"", (Object)data.toString((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        Assertions.assertEquals((Object)"\"NaN\"", (Object)data.toString((Object)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Object)"\"Infinity\"", (Object)data.toString((Object)Double.POSITIVE_INFINITY));
        Assertions.assertEquals((Object)"\"-Infinity\"", (Object)data.toString((Object)Double.NEGATIVE_INFINITY));
        Assertions.assertEquals((Object)"\"NaN\"", (Object)data.toString((Object)Double.NaN));
    }

    @Test
    void toStringConvertsDatesAsStrings() throws Exception {
        GenericData data = GenericData.get();
        Assertions.assertEquals((Object)"\"1961-04-12T06:07:10Z\"", (Object)data.toString((Object)Instant.parse("1961-04-12T06:07:10Z")));
        Assertions.assertEquals((Object)"\"1961-04-12\"", (Object)data.toString((Object)LocalDate.parse("1961-04-12")));
        Assertions.assertEquals((Object)"\"1961-04-12T06:07:10\"", (Object)data.toString((Object)LocalDateTime.parse("1961-04-12T06:07:10")));
        Assertions.assertEquals((Object)"\"10:10:10\"", (Object)data.toString((Object)LocalTime.parse("10:10:10")));
    }

    @Test
    void ToStringConvertsUuidsAsStrings() throws Exception {
        GenericData data = GenericData.get();
        Assertions.assertEquals((Object)"\"abf2f1e8-cece-4fdc-290a-babaca09ec74\"", (Object)data.toString((Object)UUID.fromString("abf2f1e8-cece-4fdc-290a-babaca09ec74")));
    }

    @Test
    void compare() {
        Schema.Field integerField = new Schema.Field("test", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(integerField);
        Schema record = Schema.createRecord((String)"test", null, null, (boolean)false);
        record.setFields(fields);
        ByteArrayOutputStream b1 = new ByteArrayOutputStream(5);
        ByteArrayOutputStream b2 = new ByteArrayOutputStream(5);
        BinaryEncoder b1Enc = EncoderFactory.get().binaryEncoder((OutputStream)b1, null);
        BinaryEncoder b2Enc = EncoderFactory.get().binaryEncoder((OutputStream)b2, null);
        GenericData.Record testDatum1 = new GenericData.Record(record);
        testDatum1.put(0, (Object)1);
        GenericData.Record testDatum2 = new GenericData.Record(record);
        testDatum2.put(0, (Object)2);
        GenericDatumWriter gWriter = new GenericDatumWriter(record);
        Integer start1 = 0;
        Integer start2 = 0;
        try {
            gWriter.write((Object)testDatum1, (Encoder)b1Enc);
            b1Enc.flush();
            start1 = b1.size();
            gWriter.write((Object)testDatum1, (Encoder)b1Enc);
            b1Enc.flush();
            b1.close();
            gWriter.write((Object)testDatum2, (Encoder)b2Enc);
            b2Enc.flush();
            start2 = b2.size();
            gWriter.write((Object)testDatum2, (Encoder)b2Enc);
            b2Enc.flush();
            b2.close();
            Assertions.assertEquals((int)-1, (int)BinaryData.compare((byte[])b1.toByteArray(), (int)start1, (byte[])b2.toByteArray(), (int)start2, (Schema)record));
        }
        catch (IOException e) {
            Assertions.fail((String)"IOException while writing records to output stream.");
        }
    }

    @Test
    void enumCompare() {
        Schema s = Schema.createEnum((String)"Kind", null, null, Arrays.asList("Z", "Y", "X"));
        GenericData.EnumSymbol z = new GenericData.EnumSymbol(s, "Z");
        GenericData.EnumSymbol z2 = new GenericData.EnumSymbol(s, "Z");
        Assertions.assertEquals((int)0, (int)z.compareTo((Object)z2));
        GenericData.EnumSymbol y = new GenericData.EnumSymbol(s, "Y");
        Assertions.assertTrue((y.compareTo((Object)z) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((z.compareTo((Object)y) < 0 ? 1 : 0) != 0);
    }

    @Test
    void byteBufferDeepCopy() {
        byte[] buffer_value = new byte[]{0, 1, 2, 3, 0, 0, 0};
        ByteBuffer buffer = ByteBuffer.wrap(buffer_value, 1, 4);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        Schema.Field byte_field = new Schema.Field("bytes", Schema.create((Schema.Type)Schema.Type.BYTES), null, null);
        schema.setFields(Collections.singletonList(byte_field));
        GenericData.Record record = new GenericData.Record(schema);
        record.put(byte_field.name(), (Object)buffer);
        GenericRecord copy = (GenericRecord)GenericData.get().deepCopy(schema, (Object)record);
        ByteBuffer buffer_copy = (ByteBuffer)copy.get(byte_field.name());
        Assertions.assertEquals((Object)buffer, (Object)buffer_copy);
    }

    @Test
    void validateNullableEnum() {
        ArrayList<Schema> unionTypes = new ArrayList<Schema>();
        Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        Schema enumSchema = Schema.createEnum((String)"AnEnum", null, null, Arrays.asList("X", "Y", "Z"));
        GenericData.EnumSymbol w = new GenericData.EnumSymbol(enumSchema, "W");
        GenericData.EnumSymbol x = new GenericData.EnumSymbol(enumSchema, "X");
        GenericData.EnumSymbol y = new GenericData.EnumSymbol(enumSchema, "Y");
        GenericData.EnumSymbol z = new GenericData.EnumSymbol(enumSchema, "Z");
        unionTypes.clear();
        unionTypes.add(nullSchema);
        unionTypes.add(enumSchema);
        Schema schema = Schema.createUnion(unionTypes);
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, (Object)z));
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, (Object)y));
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, (Object)x));
        Assertions.assertFalse((boolean)GenericData.get().validate(schema, (Object)w));
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, null));
        unionTypes.clear();
        unionTypes.add(enumSchema);
        unionTypes.add(nullSchema);
        schema = Schema.createUnion(unionTypes);
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, (Object)z));
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, (Object)y));
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, (Object)x));
        Assertions.assertFalse((boolean)GenericData.get().validate(schema, (Object)w));
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, null));
    }

    @Test
    void validateRequiresGenericSymbolForEnumSchema() {
        Schema schema = Schema.createEnum((String)"my_enum", (String)"doc", (String)"namespace", Arrays.asList("ONE", "TWO", "THREE"));
        GenericData gd = GenericData.get();
        Assertions.assertTrue((boolean)gd.validate(schema, (Object)new GenericData.EnumSymbol(schema, "ONE")));
        Assertions.assertTrue((boolean)gd.validate(schema, (Object)new GenericData.EnumSymbol(schema, (Object)anEnum.ONE)));
        Assertions.assertFalse((boolean)gd.validate(schema, (Object)"ONE"), (String)"We don't expect GenericData to allow a String datum for an enum schema");
        Assertions.assertFalse((boolean)gd.validate(schema, (Object)anEnum.ONE), (String)"We don't expect GenericData to allow a Java Enum for an enum schema");
    }

    @Test
    void validateUnion() {
        Schema type1Schema = (Schema)SchemaBuilder.record((String)"Type1").fields().requiredString("myString").requiredInt("myInt").endRecord();
        Schema type2Schema = (Schema)SchemaBuilder.record((String)"Type2").fields().requiredString("myString").endRecord();
        Schema unionSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().type(type1Schema)).and().type(type2Schema)).endUnion();
        GenericData.Record record = new GenericData.Record(type2Schema);
        record.put("myString", (Object)"myValue");
        Assertions.assertTrue((boolean)GenericData.get().validate(unionSchema, (Object)record));
    }

    @Test
    void toStringSameValues() throws IOException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("nullstring1", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        fields.add(new Schema.Field("nullstring2", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        fields.add(new Schema.Field("string1", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        fields.add(new Schema.Field("string2", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        fields.add(new Schema.Field("bytes1", Schema.create((Schema.Type)Schema.Type.BYTES), null, null));
        fields.add(new Schema.Field("bytes2", Schema.create((Schema.Type)Schema.Type.BYTES), null, null));
        fields.add(new Schema.Field("int1", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        fields.add(new Schema.Field("int2", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        fields.add(new Schema.Field("long1", Schema.create((Schema.Type)Schema.Type.LONG), null, null));
        fields.add(new Schema.Field("long2", Schema.create((Schema.Type)Schema.Type.LONG), null, null));
        fields.add(new Schema.Field("float1", Schema.create((Schema.Type)Schema.Type.FLOAT), null, null));
        fields.add(new Schema.Field("float2", Schema.create((Schema.Type)Schema.Type.FLOAT), null, null));
        fields.add(new Schema.Field("double1", Schema.create((Schema.Type)Schema.Type.DOUBLE), null, null));
        fields.add(new Schema.Field("double2", Schema.create((Schema.Type)Schema.Type.DOUBLE), null, null));
        fields.add(new Schema.Field("boolean1", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null));
        fields.add(new Schema.Field("boolean2", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null));
        ArrayList<String> enumValues = new ArrayList<String>();
        enumValues.add("One");
        enumValues.add("Two");
        Schema enumSchema = Schema.createEnum((String)"myEnum", null, null, enumValues);
        fields.add(new Schema.Field("enum1", enumSchema, null, null));
        fields.add(new Schema.Field("enum2", enumSchema, null, null));
        Schema recordSchema = (Schema)SchemaBuilder.record((String)"aRecord").fields().requiredString("myString").endRecord();
        fields.add(new Schema.Field("record1", recordSchema, null, null));
        fields.add(new Schema.Field("record2", recordSchema, null, null));
        Schema arraySchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        fields.add(new Schema.Field("array1", arraySchema, null, null));
        fields.add(new Schema.Field("array2", arraySchema, null, null));
        Schema mapSchema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        fields.add(new Schema.Field("map1", mapSchema, null, null));
        fields.add(new Schema.Field("map2", mapSchema, null, null));
        Schema schema = Schema.createRecord((String)"Foo", (String)"test", (String)"mytest", (boolean)false);
        schema.setFields(fields);
        GenericData.Record testRecord = new GenericData.Record(schema);
        testRecord.put("nullstring1", null);
        testRecord.put("nullstring2", null);
        String fortyTwo = "42";
        testRecord.put("string1", (Object)fortyTwo);
        testRecord.put("string2", (Object)fortyTwo);
        testRecord.put("bytes1", (Object)66);
        testRecord.put("bytes2", (Object)66);
        testRecord.put("int1", (Object)42);
        testRecord.put("int2", (Object)42);
        testRecord.put("long1", (Object)42L);
        testRecord.put("long2", (Object)42L);
        testRecord.put("float1", (Object)Float.valueOf(42.0f));
        testRecord.put("float2", (Object)Float.valueOf(42.0f));
        testRecord.put("double1", (Object)42.0);
        testRecord.put("double2", (Object)42.0);
        testRecord.put("boolean1", (Object)true);
        testRecord.put("boolean2", (Object)true);
        testRecord.put("enum1", (Object)"One");
        testRecord.put("enum2", (Object)"One");
        GenericData.Record record = new GenericData.Record(recordSchema);
        record.put("myString", (Object)"42");
        testRecord.put("record1", (Object)record);
        testRecord.put("record2", (Object)record);
        GenericData.Array array = new GenericData.Array(1, arraySchema);
        array.clear();
        array.add((Object)"42");
        testRecord.put("array1", (Object)array);
        testRecord.put("array2", (Object)array);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("42", "42");
        testRecord.put("map1", map);
        testRecord.put("map2", map);
        String testString = testRecord.toString();
        Assertions.assertFalse((boolean)testString.contains("CIRCULAR REFERENCE"), (String)"Record with duplicated values results in wrong 'toString()'");
    }

    @Test
    void toStringRecursive() throws IOException {
        TestCircularReferences.ReferenceManager manager = new TestCircularReferences.ReferenceManager();
        GenericData model = new GenericData();
        model.addLogicalTypeConversion((Conversion)manager.getTracker());
        model.addLogicalTypeConversion((Conversion)manager.getHandler());
        Schema parentSchema = Schema.createRecord((String)"Parent", null, null, (boolean)false);
        Schema placeholderSchema = Schema.createRecord((String)"Placeholder", null, null, (boolean)false);
        ArrayList<Schema.Field> placeholderFields = new ArrayList<Schema.Field>();
        placeholderFields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.LONG), null, null));
        placeholderSchema.setFields(placeholderFields);
        TestCircularReferences.Referenceable idRef = new TestCircularReferences.Referenceable("id");
        Schema parentRefSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG), idRef.addToSchema(placeholderSchema)});
        TestCircularReferences.Reference parentRef = new TestCircularReferences.Reference("parent");
        ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
        childFields.add(new Schema.Field("c", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        childFields.add(new Schema.Field("parent", parentRefSchema, null, null));
        Schema childSchema = parentRef.addToSchema(Schema.createRecord((String)"Child", null, null, (boolean)false, childFields));
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>();
        parentFields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.LONG), null, null));
        parentFields.add(new Schema.Field("p", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        parentFields.add(new Schema.Field("child", childSchema, null, null));
        parentSchema.setFields(parentFields);
        Schema schema = idRef.addToSchema(parentSchema);
        GenericData.Record parent = new GenericData.Record(schema);
        parent.put("id", (Object)1L);
        parent.put("p", (Object)"parent data!");
        GenericData.Record child = new GenericData.Record(childSchema);
        child.put("c", (Object)"child data!");
        child.put("parent", (Object)parent);
        parent.put("child", (Object)child);
        try {
            Assertions.assertNotNull((Object)parent.toString());
        }
        catch (StackOverflowError e) {
            Assertions.fail((String)"StackOverflowError occurred");
        }
    }

    @Test
    void genericArrayPeek() {
        Schema elementSchema = (Schema)SchemaBuilder.record((String)"element").fields().requiredString("value").endRecord();
        Schema arraySchema = Schema.createArray((Schema)elementSchema);
        GenericData.Record record = new GenericData.Record(elementSchema);
        record.put("value", (Object)"string");
        GenericData.Array list = new GenericData.Array(1, arraySchema);
        list.add((Object)record);
        list.reset();
        Assertions.assertTrue((record == list.peek() ? 1 : 0) != 0);
        list.prune();
        Assertions.assertNull((Object)list.peek());
    }

    private static enum anEnum {
        ONE,
        TWO,
        THREE;

    }
}

