/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.avro.FooBarSpecificRecord;
import org.apache.avro.TypeEnum;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGenericConcreteEnum {
    private static byte[] serializeRecord(FooBarSpecificRecord fooBarSpecificRecord) throws IOException {
        GenericDatumWriter datumWriter = new GenericDatumWriter(FooBarSpecificRecord.SCHEMA$);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        datumWriter.write((Object)fooBarSpecificRecord, (Encoder)encoder);
        encoder.flush();
        return byteArrayOutputStream.toByteArray();
    }

    @Test
    void genericWriteAndRead() throws IOException {
        FooBarSpecificRecord specificRecord = this.getRecord();
        byte[] bytes = TestGenericConcreteEnum.serializeRecord(specificRecord);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, null);
        GenericDatumReader genericDatumReader = new GenericDatumReader(FooBarSpecificRecord.SCHEMA$);
        GenericData.Record deserialized = new GenericData.Record(FooBarSpecificRecord.SCHEMA$);
        genericDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((int)0, (int)GenericData.get().compare((Object)specificRecord, (Object)deserialized, FooBarSpecificRecord.SCHEMA$));
    }

    @Test
    void genericWriteSpecificRead() throws IOException {
        FooBarSpecificRecord specificRecord = this.getRecord();
        byte[] bytes = TestGenericConcreteEnum.serializeRecord(specificRecord);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, null);
        SpecificDatumReader specificDatumReader = new SpecificDatumReader(FooBarSpecificRecord.SCHEMA$);
        FooBarSpecificRecord deserialized = new FooBarSpecificRecord();
        specificDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)((Object)specificRecord), (Object)((Object)deserialized));
    }

    private FooBarSpecificRecord getRecord() {
        return FooBarSpecificRecord.newBuilder().setId(42).setName("foo").setNicknames(Collections.singletonList("bar")).setRelatedids(Collections.singletonList(3)).setTypeEnum(TypeEnum.a).build();
    }
}

