/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.file.Codec;

public class CustomCodec
extends Codec {
    private static final String CODECNAME = "CUSTOMCODEC";

    public String getName() {
        return CODECNAME;
    }

    public ByteBuffer compress(ByteBuffer in) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(in.remaining());
        while (in.position() < in.capacity()) {
            out.put(~in.get());
        }
        return out;
    }

    public ByteBuffer decompress(ByteBuffer in) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(in.remaining());
        while (in.position() < in.capacity()) {
            out.put(~in.get());
        }
        return out;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Codec) {
            ByteBuffer original = ByteBuffer.allocate(this.getName().getBytes(StandardCharsets.UTF_8).length);
            original.put(this.getName().getBytes(StandardCharsets.UTF_8));
            original.rewind();
            try {
                return this.compareDecompress((Codec)other, original);
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private boolean compareDecompress(Codec other, ByteBuffer original) throws IOException {
        ByteBuffer compressedA = this.compress(original);
        original.rewind();
        ByteBuffer compressedB = other.compress(original);
        return this.decompress(compressedA).equals(other.decompress(compressedA.rewind())) && this.decompress(compressedB).equals(other.decompress(compressedB.rewind()));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

