/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSeekableByteArrayInput {
    private byte[] getSerializedMessage(IndexedRecord message, Schema schema) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        SpecificDatumWriter writer = new SpecificDatumWriter();
        try (DataFileWriter dfw = new DataFileWriter((DatumWriter)writer).create(schema, (OutputStream)baos);){
            dfw.append((Object)message);
        }
        return baos.toByteArray();
    }

    private Schema getTestSchema() throws Exception {
        Schema schema = Schema.createRecord((String)"TestRecord", (String)"this is a test record", (String)"org.apache.avro.file", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("name", Schema.create((Schema.Type)Schema.Type.STRING), "this is a test field"));
        schema.setFields(fields);
        return schema;
    }

    @Test
    void serialization() throws Exception {
        IndexedRecord result;
        Schema testSchema = this.getTestSchema();
        GenericData.Record message = new GenericData.Record(testSchema);
        message.put("name", (Object)"testValue");
        byte[] data = this.getSerializedMessage((IndexedRecord)message, testSchema);
        GenericDatumReader reader = new GenericDatumReader(testSchema);
        try (SeekableByteArrayInput in = new SeekableByteArrayInput(data);
             FileReader dfr = DataFileReader.openReader((SeekableInput)in, (DatumReader)reader);){
            result = (IndexedRecord)dfr.next();
        }
        Assertions.assertNotNull((Object)result);
        Assertions.assertInstanceOf(GenericRecord.class, (Object)result);
        Assertions.assertEquals((Object)new Utf8("testValue"), (Object)((GenericRecord)result).get("name"));
    }

    @Test
    void readingData() throws IOException {
        byte[] data = "0123456789ABCD".getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[16];
        try (SeekableByteArrayInput in = new SeekableByteArrayInput(data);){
            in.read(result, 0, 8);
            in.seek(4L);
            in.read(result, 8, 8);
            Assertions.assertEquals((long)12L, (long)in.tell());
            Assertions.assertEquals((long)data.length, (long)in.length());
            Assertions.assertEquals((Object)"01234567456789AB", (Object)new String(result, StandardCharsets.UTF_8));
        }
    }

    @Test
    void illegalSeeks() throws IOException {
        byte[] data = "0123456789ABCD".getBytes(StandardCharsets.UTF_8);
        try (SeekableByteArrayInput in = new SeekableByteArrayInput(data);){
            byte[] buf = new byte[2];
            in.read(buf, 0, buf.length);
            in.seek(-4L);
            Assertions.assertEquals((long)2L, (long)in.tell());
            Assertions.assertThrows(EOFException.class, () -> TestSeekableByteArrayInput.lambda$illegalSeeks$0((SeekableInput)in));
        }
    }

    private static /* synthetic */ void lambda$illegalSeeks$0(SeekableInput in) throws Throwable {
        in.seek(64L);
    }
}

