/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.file.Codec;
import org.apache.avro.file.SnappyCodec;
import org.apache.avro.file.codec.CustomCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCustomCodec {
    @Test
    void customCodec() {
        CustomCodec customCodec = new CustomCodec();
        Codec snappyCodec = new SnappyCodec.Option().createInstance();
        Assertions.assertEquals((Object)((Object)customCodec), (Object)((Object)new CustomCodec()));
        Assertions.assertNotEquals((Object)((Object)customCodec), (Object)snappyCodec);
        String testString = "Testing 123";
        ByteBuffer original = ByteBuffer.allocate(testString.getBytes(StandardCharsets.UTF_8).length);
        original.put(testString.getBytes(StandardCharsets.UTF_8));
        original.rewind();
        ByteBuffer decompressed = null;
        try {
            ByteBuffer compressed = customCodec.compress(original);
            compressed.rewind();
            decompressed = customCodec.decompress(compressed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assertions.assertEquals((Object)testString, (Object)new String(decompressed.array(), StandardCharsets.UTF_8));
    }
}

