/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import org.apache.avro.file.BZip2Codec;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DeflateCodec;
import org.apache.avro.file.NullCodec;
import org.apache.avro.file.SnappyCodec;
import org.apache.avro.file.XZCodec;
import org.apache.avro.file.ZstandardCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestAllCodecs {
    @ParameterizedTest
    @MethodSource(value={"codecTypes"})
    void codec(String codec, Class<? extends Codec> codecClass) throws IOException {
        int inputSize = 500000;
        byte[] input = TestAllCodecs.generateTestData(inputSize);
        Codec codecInstance = CodecFactory.fromString((String)codec).createInstance();
        Assertions.assertTrue((boolean)codecClass.isInstance(codecInstance));
        Assertions.assertTrue((boolean)codecInstance.getName().equals(codec));
        ByteBuffer inputByteBuffer = ByteBuffer.wrap(input);
        ByteBuffer compressedBuffer = codecInstance.compress(inputByteBuffer);
        int compressedSize = compressedBuffer.remaining();
        Assertions.assertTrue((compressedSize > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((compressedSize < inputSize || codec.equals("null") ? 1 : 0) != 0);
        ByteBuffer decompressedBuffer = codecInstance.decompress(compressedBuffer);
        inputByteBuffer.rewind();
        Assertions.assertEquals((Object)inputByteBuffer, (Object)decompressedBuffer);
    }

    @ParameterizedTest
    @MethodSource(value={"codecTypes"})
    void codecSlice(String codec, Class<? extends Codec> codecClass) throws IOException {
        int inputSize = 500000;
        byte[] input = TestAllCodecs.generateTestData(inputSize);
        Codec codecInstance = CodecFactory.fromString((String)codec).createInstance();
        Assertions.assertTrue((boolean)codecClass.isInstance(codecInstance));
        ByteBuffer partialBuffer = ByteBuffer.wrap(input);
        partialBuffer.position(17);
        ByteBuffer inputByteBuffer = partialBuffer.slice();
        ByteBuffer compressedBuffer = codecInstance.compress(inputByteBuffer);
        int compressedSize = compressedBuffer.remaining();
        Assertions.assertTrue((compressedSize > 0 ? 1 : 0) != 0);
        ByteBuffer sliceBuffer = ByteBuffer.allocate(compressedSize + 100);
        sliceBuffer.position(50);
        sliceBuffer.put(compressedBuffer);
        sliceBuffer.limit(compressedSize + 50);
        sliceBuffer.position(50);
        ByteBuffer decompressedBuffer = codecInstance.decompress(sliceBuffer.slice());
        inputByteBuffer.rewind();
        Assertions.assertEquals((Object)inputByteBuffer, (Object)decompressedBuffer);
    }

    public static Stream<Arguments> codecTypes() {
        return Stream.of(Arguments.of((Object[])new Object[]{"bzip2", BZip2Codec.class}), Arguments.of((Object[])new Object[]{"zstandard", ZstandardCodec.class}), Arguments.of((Object[])new Object[]{"null", NullCodec.class}), Arguments.of((Object[])new Object[]{"xz", XZCodec.class}), Arguments.of((Object[])new Object[]{"snappy", SnappyCodec.class}), Arguments.of((Object[])new Object[]{"deflate", DeflateCodec.class}));
    }

    public static byte[] generateTestData(int inputSize) {
        byte[] arr = new byte[inputSize];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)(65 + i % 10);
        }
        return arr;
    }
}

