/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUnionSelfReference {
    private static final Logger LOG = LoggerFactory.getLogger(TestUnionSelfReference.class);
    private static final String SIMPLE_BINARY_TREE = "{    \"namespace\": \"tree\",    \"type\": \"record\",    \"name\": \"Node\",    \"fields\": [      {        \"name\": \"left\",        \"type\": [          \"null\",          {            \"type\": \"Node\"          }        ],        \"default\": null      },      {        \"name\": \"right\",        \"type\": [          \"null\",          {            \"type\": \"Node\"          }        ],        \"default\": null      }    ]  }";
    private static final String THREE_TYPE_UNION = "{    \"namespace\": \"tree\",    \"type\": \"record\",    \"name\": \"Node\",    \"fields\": [      {        \"name\": \"left\",        \"type\": [          \"null\",          \"string\",          {            \"type\": \"Node\"          }        ],        \"default\": null      },      {        \"name\": \"right\",        \"type\": [          \"null\",          \"string\",          {            \"type\": \"Node\"          }        ],        \"default\": null      }    ]  }";

    @Test
    void selfReferenceInUnion() {
        Schema schema = new Schema.Parser().parse(SIMPLE_BINARY_TREE);
        Schema.Field leftField = schema.getField("left");
        Assertions.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)leftField.defaultVal());
        Schema leftFieldSchema = leftField.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)leftFieldSchema.getType());
        Assertions.assertEquals((Object)"null", (Object)((Schema)leftFieldSchema.getTypes().get(0)).getName());
        Assertions.assertEquals((Object)"Node", (Object)((Schema)leftFieldSchema.getTypes().get(1)).getName());
        Schema.Field rightField = schema.getField("right");
        Assertions.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)rightField.defaultVal());
        Schema rightFieldSchema = rightField.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)rightFieldSchema.getType());
        Assertions.assertEquals((Object)"null", (Object)((Schema)rightFieldSchema.getTypes().get(0)).getName());
        Assertions.assertEquals((Object)"Node", (Object)((Schema)rightFieldSchema.getTypes().get(1)).getName());
    }

    @Test
    void selfReferenceInThreeUnion() {
        Schema schema = new Schema.Parser().parse(THREE_TYPE_UNION);
        Schema.Field leftField = schema.getField("left");
        Assertions.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)leftField.defaultVal());
        Schema leftFieldSchema = leftField.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)leftFieldSchema.getType());
        Assertions.assertEquals((Object)"null", (Object)((Schema)leftFieldSchema.getTypes().get(0)).getName());
        Assertions.assertEquals((Object)"string", (Object)((Schema)leftFieldSchema.getTypes().get(1)).getName());
        Assertions.assertEquals((Object)"Node", (Object)((Schema)leftFieldSchema.getTypes().get(2)).getName());
        Schema.Field rightField = schema.getField("right");
        Assertions.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)rightField.defaultVal());
        Schema rightFieldSchema = rightField.schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)rightFieldSchema.getType());
        Assertions.assertEquals((Object)"null", (Object)((Schema)rightFieldSchema.getTypes().get(0)).getName());
        Assertions.assertEquals((Object)"string", (Object)((Schema)rightFieldSchema.getTypes().get(1)).getName());
        Assertions.assertEquals((Object)"Node", (Object)((Schema)rightFieldSchema.getTypes().get(2)).getName());
    }
}

