/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnionError {
    @Test
    void unionErrorMessage() throws IOException {
        String writerSchemaJson = "            {\n              \"type\" : \"record\",\n              \"name\" : \"C\",\n              \"fields\" : [ {\n                \"name\" : \"c\",\n                \"type\" : [ {\n                  \"type\" : \"record\",\n                  \"name\" : \"A\",\n                  \"fields\" : [ {\n                    \"name\" : \"amount\",\n                    \"type\" : \"int\"\n                  } ]\n                }, {\n                  \"type\" : \"record\",\n                  \"name\" : \"B\",\n                  \"fields\" : [ {\n                    \"name\" : \"amount1\",\n                    \"type\" : \"int\"\n                  } ]\n                } ]\n              } ]\n            }";
        Schema writerSchema = new Schema.Parser().parse(writerSchemaJson);
        String readerSchemaJson = " {\n              \"type\" : \"record\",\n              \"name\" : \"C1\",\n              \"fields\" : [ {\n                \"name\" : \"c\",\n                \"type\" : [ {\n                  \"type\" : \"record\",\n                  \"name\" : \"A\",\n                  \"fields\" : [ {\n                    \"name\" : \"amount\",\n                    \"type\" : \"int\"\n                  } ]\n                }, \"float\" ]\n              } ]\n            }";
        Schema readerSchema = new Schema.Parser().parse(readerSchemaJson);
        List unionSchemas = writerSchema.getField("c").schema().getTypes();
        GenericData.Record r = new GenericData.Record(writerSchema);
        GenericData.Record b = new GenericData.Record((Schema)unionSchemas.get(1));
        b.put("amount1", (Object)12);
        r.put("c", (Object)b);
        ByteArrayOutputStream outs = new ByteArrayOutputStream();
        GenericDatumWriter datumWriter = new GenericDatumWriter(writerSchema);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outs, null);
        datumWriter.write((Object)r, (Encoder)encoder);
        encoder.flush();
        ByteArrayInputStream ins = new ByteArrayInputStream(outs.toByteArray());
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)ins, null);
        GenericDatumReader datumReader = new GenericDatumReader(writerSchema, readerSchema);
        AvroTypeException avroException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> datumReader.read(null, (Decoder)decoder));
        Assertions.assertEquals((Object)"Found B, expecting union[A, float]", (Object)avroException.getMessage());
    }
}

