/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;

public class TestSchemaWarnings {
    private static final PrintStream originalErr = System.err;
    private final ByteArrayOutputStream capturedErr = new ByteArrayOutputStream();

    @BeforeEach
    public void setupStdErr() {
        this.capturedErr.reset();
        System.setErr(new PrintStream(this.capturedErr));
    }

    @AfterAll
    public static void restoreStdErr() {
        System.setErr(originalErr);
    }

    public String getCapturedStdErr() {
        System.out.flush();
        String stderr = new String(this.capturedErr.toByteArray(), StandardCharsets.UTF_8);
        this.capturedErr.reset();
        return stderr;
    }

    @Test
    @DisabledIfEnvironmentVariable(named="WithinInvokerPlugin", matches="true", disabledReason="Redirecting stderr does not work within the invoker plugin")
    void warnWhenTheLogicalTypeIsOnTheField() {
        Schema s = (Schema)SchemaBuilder.record((String)"A").fields().requiredInt("a1").endRecord();
        s = new Schema.Parser().parse(s.toString());
        MatcherAssert.assertThat((Object)s.getField("a1").schema().getLogicalType(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.getCapturedStdErr(), (Matcher)Matchers.is((Object)""));
        s.getField("a1").addProp("logicalType", LogicalTypes.date().getName());
        MatcherAssert.assertThat((Object)s.getField("a1").schema().getLogicalType(), (Matcher)Matchers.nullValue());
        s = new Schema.Parser().parse(s.toString());
        MatcherAssert.assertThat((Object)this.getCapturedStdErr(), (Matcher)Matchers.containsString((String)"Ignored the A.a1.logicalType property (\"date\"). It should probably be nested inside the \"type\" for the field."));
        MatcherAssert.assertThat((Object)s.getField("a1").schema().getLogicalType(), (Matcher)Matchers.nullValue());
        s.getField("a1").schema().addProp("logicalType", LogicalTypes.date().getName());
        MatcherAssert.assertThat((Object)s.getField("a1").schema().getLogicalType(), (Matcher)Matchers.nullValue());
        s = new Schema.Parser().parse(s.toString());
        MatcherAssert.assertThat((Object)this.getCapturedStdErr(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)s.getField("a1").schema().getLogicalType(), (Matcher)Matchers.is((Object)LogicalTypes.date()));
    }

    @Test
    @DisabledIfEnvironmentVariable(named="WithinInvokerPlugin", matches="true", disabledReason="Redirecting stderr does not work within the invoker plugin")
    void warnWhenTheLogicalTypeIsIgnored() {
        Schema s = (Schema)SchemaBuilder.record((String)"A").fields().requiredLong("a1").endRecord();
        s.getField("a1").schema().addProp("logicalType", LogicalTypes.date().getName());
        s = new Schema.Parser().parse(s.toString());
        MatcherAssert.assertThat((Object)s.getField("a1").schema().getLogicalType(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.getCapturedStdErr(), (Matcher)Matchers.containsString((String)"Ignoring invalid logical type for name: date"));
    }
}

