/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.avro.TestSchemas;
import org.apache.avro.reflect.ReflectData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchemaValidation {
    public static final List<TestSchemas.ReaderWriter> COMPATIBLE_READER_WRITER_TEST_CASES = TestSchemas.list(new TestSchemas.ReaderWriter(TestSchemas.BOOLEAN_SCHEMA, TestSchemas.BOOLEAN_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.FLOAT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.STRING_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_SCHEMA, TestSchemas.BYTES_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_ARRAY_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_MAP_SCHEMA, TestSchemas.INT_MAP_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_MAP_SCHEMA, TestSchemas.INT_MAP_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_ABC_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.BYTES_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_SCHEMA, TestSchemas.STRING_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.EMPTY_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_STRING_UNION_SCHEMA, TestSchemas.STRING_INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_UNION_SCHEMA, TestSchemas.BYTES_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_UNION_SCHEMA, TestSchemas.STRING_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.NULL_INT_ARRAY_UNION_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.NULL_INT_MAP_UNION_SCHEMA, TestSchemas.INT_MAP_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.INT_LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.INT_LONG_FLOAT_DOUBLE_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_UNION_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.EMPTY_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.EMPTY_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_RECORD1, TestSchemas.A_DINT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.A_DINT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_LONG_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.A_INT_B_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_RECORD1, TestSchemas.A_INT_B_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_B_DINT_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_B_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_INT_RECORD1, TestSchemas.A_DINT_B_DINT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.NULL_SCHEMA, TestSchemas.NULL_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.NS_RECORD1, TestSchemas.NS_RECORD2));
    public static final List<TestSchemas.ReaderWriter> INCOMPATIBLE_READER_WRITER_TEST_CASES = TestSchemas.list(new TestSchemas.ReaderWriter(TestSchemas.NULL_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.NULL_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BOOLEAN_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.NULL_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.BOOLEAN_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.FLOAT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.DOUBLE_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.FLOAT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.DOUBLE_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.DOUBLE_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.BOOLEAN_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_SCHEMA, TestSchemas.NULL_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.LONG_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_MAP_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.INT_MAP_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_MAP_SCHEMA, TestSchemas.LONG_MAP_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.ENUM2_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.ENUM2_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM2_AB_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_UNION_SCHEMA, TestSchemas.INT_STRING_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_UNION_SCHEMA, TestSchemas.INT_STRING_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.INT_LONG_FLOAT_DOUBLE_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_DINT_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.NULL_SCHEMA, TestSchemas.INT_SCHEMA));
    SchemaValidatorBuilder builder = new SchemaValidatorBuilder();
    Schema rec = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("a").type().intType().intDefault(1).name("b").type().longType().noDefault().endRecord();
    Schema rec2 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("a").type().intType().intDefault(1).name("b").type().longType().noDefault().name("c").type().intType().intDefault(0).endRecord();
    Schema rec3 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("b").type().longType().noDefault().name("c").type().intType().intDefault(0).endRecord();
    Schema rec4 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("b").type().longType().noDefault().name("c").type().intType().noDefault().endRecord();
    Schema rec5 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("a").type().stringType().stringDefault("").name("b").type().longType().noDefault().name("c").type().intType().intDefault(0).endRecord();
    public static final Schema circleSchema = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"Circle").fields().name("center").type().record("Point").fields().requiredDouble("x").requiredDouble("y").endRecord()).noDefault().requiredDouble("radius").endRecord();
    public static final Schema circleSchemaDifferentNames = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"crcl").fields().name("center").type().record("pt").fields().requiredDouble("x").requiredDouble("y").endRecord()).noDefault().requiredDouble("radius").endRecord();
    public static final Schema recursiveSchema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Node\",\"namespace\":\"avro\",\"fields\":[{\"name\":\"value\",\"type\":[\"null\",\"Node\"],\"default\":null}]}");

    @Test
    void allTypes() throws SchemaValidationException {
        Schema s = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.EnumDefault)((SchemaBuilder.FixedDefault)SchemaBuilder.record((String)"r").fields().requiredBoolean("boolF").requiredInt("intF").requiredLong("longF").requiredFloat("floatF").requiredDouble("doubleF").requiredString("stringF").requiredBytes("bytesF").name("fixedF1").type().fixed("F1").size(1)).noDefault().name("enumF").type().enumeration("E1").symbols(new String[]{"S"})).noDefault().name("mapF").type().map().values().stringType()).noDefault().name("arrayF").type().array().items().stringType()).noDefault().name("recordF").type().record("inner").fields().name("f").type().intType().noDefault().endRecord()).noDefault().optionalBoolean("boolO").endRecord();
        this.testValidatorPasses(this.builder.mutualReadStrategy().validateLatest(), s, s);
    }

    @Test
    void readOnePrior() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canReadStrategy().validateLatest(), this.rec3, this.rec);
        this.testValidatorPasses(this.builder.canReadStrategy().validateLatest(), this.rec5, this.rec3);
        this.testValidatorFails(this.builder.canReadStrategy().validateLatest(), this.rec4, this.rec);
    }

    @Test
    void readAllPrior() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), this.rec3, this.rec, this.rec2);
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), this.rec4, this.rec, this.rec2, this.rec3);
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), this.rec5, this.rec, this.rec2, this.rec3);
    }

    @Test
    void onePriorCanRead() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateLatest(), this.rec, this.rec3);
        this.testValidatorFails(this.builder.canBeReadStrategy().validateLatest(), this.rec, this.rec4);
    }

    @Test
    void allPriorCanRead() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateAll(), this.rec, this.rec3, this.rec2);
        this.testValidatorFails(this.builder.canBeReadStrategy().validateAll(), this.rec, this.rec4, this.rec3, this.rec2);
    }

    @Test
    void onePriorCompatible() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.mutualReadStrategy().validateLatest(), this.rec, this.rec3);
        this.testValidatorFails(this.builder.mutualReadStrategy().validateLatest(), this.rec, this.rec4);
    }

    @Test
    void allPriorCompatible() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.mutualReadStrategy().validateAll(), this.rec, this.rec3, this.rec2);
        this.testValidatorFails(this.builder.mutualReadStrategy().validateAll(), this.rec, this.rec4, this.rec3, this.rec2);
    }

    @Test
    void invalidBuild() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> this.builder.strategy(null).validateAll());
    }

    @Test
    void reflectMatchStructure() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateAll(), circleSchemaDifferentNames, ReflectData.get().getSchema(Circle.class));
    }

    @Test
    void reflectWithAllowNullMatchStructure() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateAll(), circleSchemaDifferentNames, ReflectData.AllowNull.get().getSchema(Circle.class));
    }

    @Test
    void unionWithIncompatibleElements() throws SchemaValidationException {
        Schema union1 = Schema.createUnion(Collections.singletonList(this.rec));
        Schema union2 = Schema.createUnion(Collections.singletonList(this.rec4));
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), union2, union1);
    }

    @Test
    void unionWithCompatibleElements() throws SchemaValidationException {
        Schema union1 = Schema.createUnion(Collections.singletonList(this.rec));
        Schema union2 = Schema.createUnion(Collections.singletonList(this.rec3));
        this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), union2, union1);
    }

    @Test
    void schemaCompatibilitySuccesses() throws SchemaValidationException {
        for (TestSchemas.ReaderWriter tc : COMPATIBLE_READER_WRITER_TEST_CASES) {
            this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), tc.getReader(), tc.getWriter());
        }
    }

    @Test
    void schemaCompatibilityFailures() {
        for (TestSchemas.ReaderWriter tc : INCOMPATIBLE_READER_WRITER_TEST_CASES) {
            Schema reader = tc.getReader();
            Schema writer = tc.getWriter();
            String expectedMsg = "Unable to read schema: \n" + writer.toString(false);
            SchemaValidator validator = this.builder.canReadStrategy().validateAll();
            SchemaValidationException exception = (SchemaValidationException)Assertions.assertThrows(SchemaValidationException.class, () -> validator.validate(reader, Collections.singleton(writer)), (String)("No or wrong exception for (" + reader.toString(false) + "; " + writer.toString(false) + ")"));
            Assertions.assertTrue((boolean)exception.getMessage().contains("Unable to read schema:"), (String)("'" + expectedMsg + "' != '" + exception.getMessage() + "'"));
        }
    }

    private void testValidatorPasses(SchemaValidator validator, Schema schema, Schema ... prev) throws SchemaValidationException {
        ArrayList<Schema> prior = new ArrayList<Schema>();
        for (int i = prev.length - 1; i >= 0; --i) {
            prior.add(prev[i]);
        }
        validator.validate(schema, prior);
    }

    private void testValidatorFails(SchemaValidator validator, Schema schemaFails, Schema ... prev) throws SchemaValidationException {
        ArrayList<Schema> prior = new ArrayList<Schema>();
        for (int i = prev.length - 1; i >= 0; --i) {
            prior.add(prev[i]);
        }
        boolean threw = false;
        try {
            validator.validate(schemaFails, prior);
        }
        catch (SchemaValidationException sve) {
            threw = true;
        }
        Assertions.assertTrue((boolean)threw);
    }

    @Test
    void recursiveSchemaValidation() throws SchemaValidationException {
        SchemaValidator backwardValidator = this.builder.canReadStrategy().validateLatest();
        backwardValidator.validate(recursiveSchema, Collections.singletonList(recursiveSchema));
    }

    public static class Circle {
        Point center;
        double radius;
    }

    public static class Point {
        double x;
        double y;
    }
}

