/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.util.CaseFinder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchemaNormalization {
    private static String DATA_FILE = System.getProperty("share.dir", "../../../share") + "/test/data/schema-tests.txt";
    private static final long ONE = Long.MIN_VALUE;
    private static final byte[] POSTFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    private static BufferedReader data() throws IOException {
        return Files.newBufferedReader(Paths.get(DATA_FILE, new String[0]), StandardCharsets.UTF_8);
    }

    public static long altFingerprint(String s) {
        long tmp = TestSchemaNormalization.altExtend(-4513414715797952619L, 64, Long.MIN_VALUE, s.getBytes(StandardCharsets.UTF_8));
        return TestSchemaNormalization.altExtend(-4513414715797952619L, 64, tmp, POSTFIX);
    }

    private static long altExtend(long poly, int degree, long fp, byte[] b) {
        long overflowBit = 1L << 64 - degree;
        for (byte b1 : b) {
            for (int j = 1; j < 129; j <<= 1) {
                boolean overflow = 0L != (fp & overflowBit);
                fp >>>= 1;
                if (0 != (j & b1)) {
                    fp |= Long.MIN_VALUE;
                }
                if (!overflow) continue;
                fp ^= poly;
            }
        }
        return fp;
    }

    private static void assertEqHex(long expected, long actual) {
        Assertions.assertEquals((long)expected, (long)actual, () -> TestSchemaNormalization.format("0x%016x != 0x%016x", expected, actual));
    }

    private static String format(String f, Object ... args) {
        return new Formatter().format(f, args).toString();
    }

    @Nested
    public static class TestFingerprintInternationalization {
        public static List<Object[]> cases() throws IOException {
            return CaseFinder.find(TestSchemaNormalization.data(), "fingerprint", new ArrayList<Object[]>());
        }

        @ParameterizedTest
        @MethodSource(value={"cases"})
        void canonicalization(String input, String expectedOutput) {
            Locale originalDefaultLocale = Locale.getDefault();
            Locale.setDefault(Locale.forLanguageTag("tr"));
            Schema s = new Schema.Parser().parse(input);
            long carefulFP = TestSchemaNormalization.altFingerprint(SchemaNormalization.toParsingForm((Schema)s));
            Assertions.assertEquals((long)carefulFP, (long)Long.parseLong(expectedOutput));
            TestSchemaNormalization.assertEqHex(carefulFP, SchemaNormalization.parsingFingerprint64((Schema)s));
            Locale.setDefault(originalDefaultLocale);
        }
    }

    @Nested
    public static class TestFingerprint {
        public static List<Object[]> cases() throws IOException {
            return CaseFinder.find(TestSchemaNormalization.data(), "fingerprint", new ArrayList<Object[]>());
        }

        @ParameterizedTest
        @MethodSource(value={"cases"})
        void canonicalization(String input, String expectedOutput) {
            Schema s = new Schema.Parser().parse(input);
            long carefulFP = TestSchemaNormalization.altFingerprint(SchemaNormalization.toParsingForm((Schema)s));
            Assertions.assertEquals((long)carefulFP, (long)Long.parseLong(expectedOutput));
            TestSchemaNormalization.assertEqHex(carefulFP, SchemaNormalization.parsingFingerprint64((Schema)s));
        }
    }

    @Nested
    public static class TestCanonical {
        public static List<Object[]> cases() throws IOException {
            return CaseFinder.find(TestSchemaNormalization.data(), "canonical", new ArrayList<Object[]>());
        }

        @ParameterizedTest
        @MethodSource(value={"cases"})
        void canonicalization(String input, String expectedOutput) {
            Assertions.assertEquals((Object)SchemaNormalization.toParsingForm((Schema)new Schema.Parser().parse(input)), (Object)expectedOutput);
        }
    }
}

