/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.TestSchemaCompatibility;
import org.apache.avro.TestSchemas;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchemaCompatibilityNameMismatch {
    private static final Schema FIXED_4_ANOTHER_NAME = Schema.createFixed((String)"AnotherName", null, null, (int)4);

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.ENUM2_AB_SCHEMA, "expected: Enum2", "/name"}), Arguments.of((Object[])new Object[]{TestSchemas.EMPTY_RECORD2, TestSchemas.EMPTY_RECORD1, "expected: Record1", "/name"}), Arguments.of((Object[])new Object[]{TestSchemas.FIXED_4_BYTES, FIXED_4_ANOTHER_NAME, "expected: AnotherName", "/name"}), Arguments.of((Object[])new Object[]{TestSchemas.A_DINT_B_DENUM_1_RECORD1, TestSchemas.A_DINT_B_DENUM_2_RECORD1, "expected: Enum2", "/fields/1/type/name"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testNameMismatchSchemas(Schema reader, Schema writer, String details, String location) throws Exception {
        TestSchemaCompatibility.validateIncompatibleSchemas(reader, writer, SchemaCompatibility.SchemaIncompatibilityType.NAME_MISMATCH, details, location);
    }
}

