/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.TestSchemaCompatibility;
import org.junit.jupiter.api.Test;

public class TestSchemaCompatibilityMultiple {
    @Test
    void multipleIncompatibilities() throws Exception {
        Schema reader = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)((SchemaBuilder.BooleanDefault)((SchemaBuilder.BooleanDefault)((SchemaBuilder.FixedDefault)((SchemaBuilder.EnumDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"base").fields().name("check_enum_symbols_field").type().enumeration("check_enum_symbols_type").symbols(new String[]{"A", "C"})).noDefault().name("check_enum_name_field").type().enumeration("check_enum_name_type").symbols(new String[]{"A", "B", "C", "D"})).noDefault().name("type_mismatch_field").type().stringType().noDefault().name("sub_record").type().record("sub_record_type").fields().name("identical_1_field").type().longType().longDefault(42L).name("extra_no_default_field").type().longType().noDefault().name("fixed_length_mismatch_field").type().fixed("fixed_length_mismatch_type").size(4)).noDefault().name("union_missing_branches_field").type().unionOf().booleanType().endUnion()).noDefault().name("reader_union_does_not_support_type_field").type().unionOf().booleanType().endUnion()).noDefault().name("record_fqn_mismatch_field").type().record("recordA").namespace("not_nsA")).fields().name("A_field_0").type().booleanType().booleanDefault(true).name("array_type_mismatch_field").type().array().items().stringType()).noDefault().endRecord()).noDefault().endRecord()).noDefault().endRecord();
        Schema writer = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)((SchemaBuilder.BooleanDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FixedDefault)((SchemaBuilder.EnumDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"base").fields().name("check_enum_symbols_field").type().enumeration("check_enum_symbols_type").symbols(new String[]{"A", "B", "C", "D"})).noDefault().name("check_enum_name_field").type().enumeration("check_enum_name_type_ERR").symbols(new String[]{"A", "B", "C", "D"})).noDefault().name("type_mismatch_field").type().longType().noDefault().name("sub_record").type().record("sub_record_type").fields().name("identical_1_field").type().longType().longDefault(42L).name("fixed_length_mismatch_field").type().fixed("fixed_length_mismatch_type").size(8)).noDefault().name("union_missing_branches_field").type().unionOf().booleanType().and().doubleType()).and().stringType()).endUnion()).noDefault().name("reader_union_does_not_support_type_field").type().longType().noDefault().name("record_fqn_mismatch_field").type().record("recordA").namespace("nsA")).fields().name("A_field_0").type().booleanType().booleanDefault(true).name("array_type_mismatch_field").type().array().items().booleanType()).noDefault().endRecord()).noDefault().endRecord()).noDefault().endRecord();
        List<SchemaCompatibility.SchemaIncompatibilityType> types = Arrays.asList(SchemaCompatibility.SchemaIncompatibilityType.MISSING_ENUM_SYMBOLS, SchemaCompatibility.SchemaIncompatibilityType.NAME_MISMATCH, SchemaCompatibility.SchemaIncompatibilityType.TYPE_MISMATCH, SchemaCompatibility.SchemaIncompatibilityType.READER_FIELD_MISSING_DEFAULT_VALUE, SchemaCompatibility.SchemaIncompatibilityType.FIXED_SIZE_MISMATCH, SchemaCompatibility.SchemaIncompatibilityType.MISSING_UNION_BRANCH, SchemaCompatibility.SchemaIncompatibilityType.MISSING_UNION_BRANCH, SchemaCompatibility.SchemaIncompatibilityType.MISSING_UNION_BRANCH, SchemaCompatibility.SchemaIncompatibilityType.TYPE_MISMATCH);
        List<String> details = Arrays.asList("[B, D]", "expected: check_enum_name_type_ERR", "reader type: STRING not compatible with writer type: LONG", "extra_no_default_field", "expected: 8, found: 4", "reader union lacking writer type: DOUBLE", "reader union lacking writer type: STRING", "reader union lacking writer type: LONG", "reader type: STRING not compatible with writer type: BOOLEAN");
        List<String> location = Arrays.asList("/fields/0/type/symbols", "/fields/1/type/name", "/fields/2/type", "/fields/3/type/fields/1", "/fields/3/type/fields/2/type/size", "/fields/3/type/fields/3/type/1", "/fields/3/type/fields/3/type/2", "/fields/3/type/fields/4/type", "/fields/3/type/fields/5/type/fields/1/type/items");
        TestSchemaCompatibility.validateIncompatibleSchemas(reader, writer, types, details, location);
    }
}

