/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.TestSchemaCompatibility;
import org.apache.avro.TestSchemas;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchemaCompatibilityMissingUnionBranch {
    private static final Schema RECORD1_WITH_INT = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.INT_SCHEMA).noDefault().endRecord();
    private static final Schema RECORD2_WITH_INT = (Schema)SchemaBuilder.record((String)"Record2").fields().name("field1").type(TestSchemas.INT_SCHEMA).noDefault().endRecord();
    private static final Schema UNION_INT_RECORD1 = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, RECORD1_WITH_INT));
    private static final Schema UNION_INT_RECORD2 = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, RECORD2_WITH_INT));
    private static final Schema UNION_INT_ENUM1_AB = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA));
    private static final Schema UNION_INT_FIXED_4_BYTES = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.FIXED_4_BYTES));
    private static final Schema UNION_INT_BOOLEAN = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.BOOLEAN_SCHEMA));
    private static final Schema UNION_INT_ARRAY_INT = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA));
    private static final Schema UNION_INT_MAP_INT = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.INT_MAP_SCHEMA));
    private static final Schema UNION_INT_NULL = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.NULL_SCHEMA));

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, TestSchemas.INT_STRING_UNION_SCHEMA, Collections.singletonList("reader union lacking writer type: STRING"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.STRING_UNION_SCHEMA, TestSchemas.INT_STRING_UNION_SCHEMA, Collections.singletonList("reader union lacking writer type: INT"), Collections.singletonList("/0")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_RECORD1, Collections.singletonList("reader union lacking writer type: RECORD"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_RECORD2, Collections.singletonList("reader union lacking writer type: RECORD"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{UNION_INT_RECORD1, UNION_INT_RECORD2, Collections.singletonList("reader union lacking writer type: RECORD"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_ENUM1_AB, Collections.singletonList("reader union lacking writer type: ENUM"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_FIXED_4_BYTES, Collections.singletonList("reader union lacking writer type: FIXED"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_BOOLEAN, Collections.singletonList("reader union lacking writer type: BOOLEAN"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, TestSchemas.LONG_UNION_SCHEMA, Collections.singletonList("reader union lacking writer type: LONG"), Collections.singletonList("/0")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, TestSchemas.FLOAT_UNION_SCHEMA, Collections.singletonList("reader union lacking writer type: FLOAT"), Collections.singletonList("/0")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, TestSchemas.DOUBLE_UNION_SCHEMA, Collections.singletonList("reader union lacking writer type: DOUBLE"), Collections.singletonList("/0")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, TestSchemas.BYTES_UNION_SCHEMA, Collections.singletonList("reader union lacking writer type: BYTES"), Collections.singletonList("/0")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_ARRAY_INT, Collections.singletonList("reader union lacking writer type: ARRAY"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_MAP_INT, Collections.singletonList("reader union lacking writer type: MAP"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, UNION_INT_NULL, Collections.singletonList("reader union lacking writer type: NULL"), Collections.singletonList("/1")}), Arguments.of((Object[])new Object[]{TestSchemas.INT_UNION_SCHEMA, TestSchemas.INT_LONG_FLOAT_DOUBLE_UNION_SCHEMA, Arrays.asList("reader union lacking writer type: LONG", "reader union lacking writer type: FLOAT", "reader union lacking writer type: DOUBLE"), Arrays.asList("/1", "/2", "/3")}), Arguments.of((Object[])new Object[]{TestSchemas.A_DINT_B_DINT_UNION_RECORD1, TestSchemas.A_DINT_B_DINT_STRING_UNION_RECORD1, Collections.singletonList("reader union lacking writer type: STRING"), Collections.singletonList("/fields/1/type/1")}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testMissingUnionBranch(Schema reader, Schema writer, List<String> details, List<String> location) throws Exception {
        List<SchemaCompatibility.SchemaIncompatibilityType> types = Collections.nCopies(details.size(), SchemaCompatibility.SchemaIncompatibilityType.MISSING_UNION_BRANCH);
        TestSchemaCompatibility.validateIncompatibleSchemas(reader, writer, types, details, location);
    }
}

