/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.TestSchemaCompatibility;
import org.apache.avro.TestSchemas;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchemaCompatibilityMissingEnumSymbols {
    private static final Schema RECORD1_WITH_ENUM_AB = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM1_AB_SCHEMA).noDefault().endRecord();
    private static final Schema RECORD1_WITH_ENUM_ABC = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM1_ABC_SCHEMA).noDefault().endRecord();

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.ENUM1_ABC_SCHEMA, "[C]", "/symbols"}), Arguments.of((Object[])new Object[]{TestSchemas.ENUM1_BC_SCHEMA, TestSchemas.ENUM1_ABC_SCHEMA, "[A]", "/symbols"}), Arguments.of((Object[])new Object[]{RECORD1_WITH_ENUM_AB, RECORD1_WITH_ENUM_ABC, "[C]", "/fields/0/type/symbols"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testTypeMismatchSchemas(Schema reader, Schema writer, String details, String location) {
        TestSchemaCompatibility.validateIncompatibleSchemas(reader, writer, SchemaCompatibility.SchemaIncompatibilityType.MISSING_ENUM_SYMBOLS, details, location);
    }
}

