/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.TestSchemas;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSchemaCompatibility {
    private static final Logger LOG = LoggerFactory.getLogger(TestSchemaCompatibility.class);
    private static final Schema WRITER_SCHEMA = Schema.createRecord(TestSchemas.list(new Schema.Field("oldfield1", TestSchemas.INT_SCHEMA, null, null), new Schema.Field("oldfield2", TestSchemas.STRING_SCHEMA, null, null)));
    public static final List<TestSchemas.ReaderWriter> COMPATIBLE_READER_WRITER_TEST_CASES = TestSchemas.list(new TestSchemas.ReaderWriter(TestSchemas.BOOLEAN_SCHEMA, TestSchemas.BOOLEAN_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.LONG_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.FLOAT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.STRING_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_SCHEMA, TestSchemas.BYTES_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_ARRAY_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_MAP_SCHEMA, TestSchemas.INT_MAP_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_MAP_SCHEMA, TestSchemas.INT_MAP_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_ABC_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA_DEFAULT, TestSchemas.ENUM1_ABC_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA, TestSchemas.ENUM1_AB_SCHEMA_NAMESPACE_1), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA_NAMESPACE_1, TestSchemas.ENUM1_AB_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM1_AB_SCHEMA_NAMESPACE_1, TestSchemas.ENUM1_AB_SCHEMA_NAMESPACE_2), new TestSchemas.ReaderWriter(TestSchemas.STRING_SCHEMA, TestSchemas.BYTES_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_SCHEMA, TestSchemas.STRING_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.EMPTY_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.INT_LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_STRING_UNION_SCHEMA, TestSchemas.STRING_INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.STRING_UNION_SCHEMA, TestSchemas.BYTES_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_UNION_SCHEMA, TestSchemas.EMPTY_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.BYTES_UNION_SCHEMA, TestSchemas.STRING_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_UNION_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.LONG_SCHEMA, TestSchemas.INT_LONG_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.DOUBLE_SCHEMA, TestSchemas.INT_LONG_FLOAT_DOUBLE_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FLOAT_SCHEMA, TestSchemas.FLOAT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_UNION_SCHEMA, TestSchemas.INT_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.INT_SCHEMA, TestSchemas.INT_UNION_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.FIXED_4_BYTES, TestSchemas.FIXED_4_BYTES), new TestSchemas.ReaderWriter(TestSchemas.EMPTY_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.EMPTY_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_RECORD1, TestSchemas.A_DINT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.A_DINT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_LONG_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_RECORD1, TestSchemas.A_INT_B_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_RECORD1, TestSchemas.A_INT_B_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_B_DINT_RECORD1, TestSchemas.EMPTY_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_DINT_B_DINT_RECORD1, TestSchemas.A_INT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.A_INT_B_INT_RECORD1, TestSchemas.A_DINT_B_DINT_RECORD1), new TestSchemas.ReaderWriter(TestSchemas.INT_LIST_RECORD, TestSchemas.INT_LIST_RECORD), new TestSchemas.ReaderWriter(TestSchemas.LONG_LIST_RECORD, TestSchemas.LONG_LIST_RECORD), new TestSchemas.ReaderWriter(TestSchemas.LONG_LIST_RECORD, TestSchemas.INT_LIST_RECORD), new TestSchemas.ReaderWriter(TestSchemas.NULL_SCHEMA, TestSchemas.NULL_SCHEMA), new TestSchemas.ReaderWriter(TestSchemas.ENUM_AB_ENUM_DEFAULT_A_RECORD, TestSchemas.ENUM_ABC_ENUM_DEFAULT_A_RECORD), new TestSchemas.ReaderWriter(TestSchemas.ENUM_AB_FIELD_DEFAULT_A_ENUM_DEFAULT_B_RECORD, TestSchemas.ENUM_ABC_FIELD_DEFAULT_B_ENUM_DEFAULT_A_RECORD), new TestSchemas.ReaderWriter(TestSchemas.NS_RECORD1, TestSchemas.NS_RECORD2), new TestSchemas.ReaderWriter(TestSchemas.WITHOUT_NS, TestSchemas.WITH_NS));
    public static final List<DecodingTestCase> DECODING_COMPATIBILITY_TEST_CASES = TestSchemas.list(new DecodingTestCase(TestSchemas.INT_SCHEMA, 1, TestSchemas.INT_SCHEMA, 1), new DecodingTestCase(TestSchemas.INT_SCHEMA, 1, TestSchemas.LONG_SCHEMA, 1L), new DecodingTestCase(TestSchemas.INT_SCHEMA, 1, TestSchemas.FLOAT_SCHEMA, Float.valueOf(1.0f)), new DecodingTestCase(TestSchemas.INT_SCHEMA, 1, TestSchemas.DOUBLE_SCHEMA, 1.0), new DecodingTestCase(TestSchemas.INT_SCHEMA, 0x1000001, TestSchemas.FLOAT_SCHEMA, Float.valueOf(1.6777216E7f)), new DecodingTestCase(TestSchemas.ENUM1_AB_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM1_AB_SCHEMA, "A"), TestSchemas.ENUM1_ABC_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM1_ABC_SCHEMA, "A")), new DecodingTestCase(TestSchemas.ENUM1_ABC_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM1_ABC_SCHEMA, "A"), TestSchemas.ENUM1_AB_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM1_AB_SCHEMA, "A")), new DecodingTestCase(TestSchemas.ENUM1_ABC_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM1_ABC_SCHEMA, "B"), TestSchemas.ENUM1_BC_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM1_BC_SCHEMA, "B")), new DecodingTestCase(TestSchemas.ENUM_ABC_ENUM_DEFAULT_A_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM_ABC_ENUM_DEFAULT_A_SCHEMA, "C"), TestSchemas.ENUM_AB_ENUM_DEFAULT_A_SCHEMA, new GenericData.EnumSymbol(TestSchemas.ENUM_AB_ENUM_DEFAULT_A_SCHEMA, "A")), new DecodingTestCase(TestSchemas.INT_STRING_UNION_SCHEMA, "the string", TestSchemas.STRING_SCHEMA, new Utf8("the string")), new DecodingTestCase(TestSchemas.INT_STRING_UNION_SCHEMA, "the string", TestSchemas.STRING_UNION_SCHEMA, new Utf8("the string")));

    @Test
    void validateSchemaPairMissingField() {
        ArrayList<Schema.Field> readerFields = TestSchemas.list(new Schema.Field("oldfield1", TestSchemas.INT_SCHEMA, null, null));
        Schema reader = Schema.createRecord(null, null, null, (boolean)false, readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.compatible(), reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assertions.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    void validateSchemaPairMissingSecondField() {
        ArrayList<Schema.Field> readerFields = TestSchemas.list(new Schema.Field("oldfield2", TestSchemas.STRING_SCHEMA, null, null));
        Schema reader = Schema.createRecord(null, null, null, (boolean)false, readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.compatible(), reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assertions.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    void validateSchemaPairAllFields() {
        ArrayList<Schema.Field> readerFields = TestSchemas.list(new Schema.Field("oldfield1", TestSchemas.INT_SCHEMA, null, null), new Schema.Field("oldfield2", TestSchemas.STRING_SCHEMA, null, null));
        Schema reader = Schema.createRecord(null, null, null, (boolean)false, readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.compatible(), reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assertions.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    void validateSchemaNewFieldWithDefault() {
        ArrayList<Schema.Field> readerFields = TestSchemas.list(new Schema.Field("oldfield1", TestSchemas.INT_SCHEMA, null, null), new Schema.Field("newfield1", TestSchemas.INT_SCHEMA, null, (Object)42));
        Schema reader = Schema.createRecord(null, null, null, (boolean)false, readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.compatible(), reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assertions.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    void validateSchemaNewField() {
        ArrayList<Schema.Field> readerFields = TestSchemas.list(new Schema.Field("oldfield1", TestSchemas.INT_SCHEMA, null, null), new Schema.Field("newfield1", TestSchemas.INT_SCHEMA, null, null));
        Schema reader = Schema.createRecord(null, null, null, (boolean)false, readerFields);
        SchemaCompatibility.SchemaPairCompatibility compatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA);
        Assertions.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, (Object)compatibility.getType());
        Assertions.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityResult.incompatible((SchemaCompatibility.SchemaIncompatibilityType)SchemaCompatibility.SchemaIncompatibilityType.READER_FIELD_MISSING_DEFAULT_VALUE, (Schema)reader, (Schema)WRITER_SCHEMA, (String)"newfield1", Arrays.asList("", "fields", "1")), (Object)compatibility.getResult());
        Assertions.assertEquals((Object)String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", WRITER_SCHEMA.toString(true), reader.toString(true)), (Object)compatibility.getDescription());
        Assertions.assertEquals((Object)reader, (Object)compatibility.getReader());
        Assertions.assertEquals((Object)WRITER_SCHEMA, (Object)compatibility.getWriter());
    }

    @Test
    void validateArrayWriterSchema() {
        Schema validReader = Schema.createArray((Schema)TestSchemas.STRING_SCHEMA);
        Schema invalidReader = Schema.createMap((Schema)TestSchemas.STRING_SCHEMA);
        SchemaCompatibility.SchemaPairCompatibility validResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.compatible(), validReader, TestSchemas.STRING_ARRAY_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        SchemaCompatibility.SchemaPairCompatibility invalidResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.incompatible((SchemaCompatibility.SchemaIncompatibilityType)SchemaCompatibility.SchemaIncompatibilityType.TYPE_MISMATCH, (Schema)invalidReader, (Schema)TestSchemas.STRING_ARRAY_SCHEMA, (String)"reader type: MAP not compatible with writer type: ARRAY", Collections.singletonList("")), invalidReader, TestSchemas.STRING_ARRAY_SCHEMA, String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", TestSchemas.STRING_ARRAY_SCHEMA.toString(true), invalidReader.toString(true)));
        Assertions.assertEquals((Object)validResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)validReader, (Schema)TestSchemas.STRING_ARRAY_SCHEMA));
        Assertions.assertEquals((Object)invalidResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)invalidReader, (Schema)TestSchemas.STRING_ARRAY_SCHEMA));
    }

    @Test
    void validatePrimitiveWriterSchema() {
        Schema validReader = Schema.create((Schema.Type)Schema.Type.STRING);
        SchemaCompatibility.SchemaPairCompatibility validResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.compatible(), validReader, TestSchemas.STRING_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        SchemaCompatibility.SchemaPairCompatibility invalidResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityResult.incompatible((SchemaCompatibility.SchemaIncompatibilityType)SchemaCompatibility.SchemaIncompatibilityType.TYPE_MISMATCH, (Schema)TestSchemas.INT_SCHEMA, (Schema)TestSchemas.STRING_SCHEMA, (String)"reader type: INT not compatible with writer type: STRING", Collections.singletonList("")), TestSchemas.INT_SCHEMA, TestSchemas.STRING_SCHEMA, String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", TestSchemas.STRING_SCHEMA.toString(true), TestSchemas.INT_SCHEMA.toString(true)));
        Assertions.assertEquals((Object)validResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)validReader, (Schema)TestSchemas.STRING_SCHEMA));
        Assertions.assertEquals((Object)invalidResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)TestSchemas.INT_SCHEMA, (Schema)TestSchemas.STRING_SCHEMA));
    }

    @Test
    void unionReaderWriterSubsetIncompatibility() {
        Schema unionWriter = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.STRING_SCHEMA, TestSchemas.LONG_SCHEMA));
        Schema unionReader = Schema.createUnion(TestSchemas.list(TestSchemas.INT_SCHEMA, TestSchemas.STRING_SCHEMA));
        SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)unionReader, (Schema)unionWriter);
        Assertions.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, (Object)result.getType());
        Assertions.assertEquals((Object)"/2", (Object)((SchemaCompatibility.Incompatibility)result.getResult().getIncompatibilities().get(0)).getLocation());
    }

    @Test
    void unionWriterSimpleReaderIncompatibility() {
        Schema mandatorySchema = (Schema)SchemaBuilder.record((String)"Account").fields().name("age").type().intType().noDefault().endRecord();
        Schema optionalSchema = (Schema)SchemaBuilder.record((String)"Account").fields().optionalInt("age").endRecord();
        SchemaCompatibility.SchemaPairCompatibility compatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)mandatorySchema, (Schema)optionalSchema);
        Assertions.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, (Object)compatibility.getType());
        SchemaCompatibility.Incompatibility incompatibility = (SchemaCompatibility.Incompatibility)compatibility.getResult().getIncompatibilities().get(0);
        Assertions.assertEquals((Object)"reader type: INT not compatible with writer type: NULL", (Object)incompatibility.getMessage());
        Assertions.assertEquals((Object)"/fields/0/type/0", (Object)incompatibility.getLocation());
    }

    public static void validateIncompatibleSchemas(Schema reader, Schema writer, SchemaCompatibility.SchemaIncompatibilityType incompatibility, String message, String location) {
        TestSchemaCompatibility.validateIncompatibleSchemas(reader, writer, Collections.singletonList(incompatibility), Collections.singletonList(message), Collections.singletonList(location));
    }

    public static void validateIncompatibleSchemas(Schema reader, Schema writer, List<SchemaCompatibility.SchemaIncompatibilityType> incompatibilityTypes, List<String> messages, List<String> locations) {
        SchemaCompatibility.SchemaPairCompatibility compatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)writer);
        SchemaCompatibility.SchemaCompatibilityResult compatibilityResult = compatibility.getResult();
        Assertions.assertEquals((Object)reader, (Object)compatibility.getReader());
        Assertions.assertEquals((Object)writer, (Object)compatibility.getWriter());
        Assertions.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, (Object)compatibilityResult.getCompatibility());
        Assertions.assertEquals((int)incompatibilityTypes.size(), (int)compatibilityResult.getIncompatibilities().size());
        for (int i = 0; i < incompatibilityTypes.size(); ++i) {
            SchemaCompatibility.Incompatibility incompatibility = (SchemaCompatibility.Incompatibility)compatibilityResult.getIncompatibilities().get(i);
            TestSchemas.assertSchemaContains(incompatibility.getReaderFragment(), reader);
            TestSchemas.assertSchemaContains(incompatibility.getWriterFragment(), writer);
            Assertions.assertEquals((Object)incompatibilityTypes.get(i), (Object)incompatibility.getType());
            Assertions.assertEquals((Object)messages.get(i), (Object)incompatibility.getMessage());
            Assertions.assertEquals((Object)locations.get(i), (Object)incompatibility.getLocation());
        }
        String description = String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", writer.toString(true), reader.toString(true));
        Assertions.assertEquals((Object)description, (Object)compatibility.getDescription());
    }

    @Test
    void readerWriterCompatibility() {
        for (TestSchemas.ReaderWriter readerWriter : COMPATIBLE_READER_WRITER_TEST_CASES) {
            Schema reader = readerWriter.getReader();
            Schema writer = readerWriter.getWriter();
            LOG.debug("Testing compatibility of reader {} with writer {}.", (Object)reader, (Object)writer);
            SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)writer);
            Assertions.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, (Object)result.getType(), (String)String.format("Expecting reader %s to be compatible with writer %s, but tested incompatible.", reader, writer));
        }
    }

    @Test
    void readerWriterDecodingCompatibility() throws Exception {
        for (DecodingTestCase testCase : DECODING_COMPATIBILITY_TEST_CASES) {
            Schema readerSchema = testCase.getReaderSchema();
            Schema writerSchema = testCase.getWriterSchema();
            Object datum = testCase.getDatum();
            Object expectedDecodedDatum = testCase.getDecodedDatum();
            LOG.debug("Testing incompatibility of reader {} with writer {}.", (Object)readerSchema, (Object)writerSchema);
            LOG.debug("Encode datum {} with writer {}.", datum, (Object)writerSchema);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
            GenericDatumWriter datumWriter = new GenericDatumWriter(writerSchema);
            datumWriter.write(datum, (Encoder)encoder);
            encoder.flush();
            LOG.debug("Decode datum {} whose writer is {} with reader {}.", new Object[]{datum, writerSchema, readerSchema});
            byte[] bytes = baos.toByteArray();
            ResolvingDecoder decoder = DecoderFactory.get().resolvingDecoder(writerSchema, readerSchema, (Decoder)DecoderFactory.get().binaryDecoder(bytes, null));
            GenericDatumReader datumReader = new GenericDatumReader(readerSchema);
            Object decodedDatum = datumReader.read(null, (Decoder)decoder);
            Assertions.assertEquals((Object)expectedDecodedDatum, (Object)decodedDatum, (String)String.format("Expecting decoded value %s when decoding value %s whose writer schema is %s using reader schema %s, but value was %s.", expectedDecodedDatum, datum, writerSchema, readerSchema, decodedDatum));
        }
    }

    private Schema readSchemaFromResources(String name) throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);){
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            Schema schema = new Schema.Parser().parse(result);
            return schema;
        }
    }

    @Test
    void checkResolvingDecoder() throws IOException {
        byte[] payload;
        Schema locationSchema = this.readSchemaFromResources("schema-location.json");
        Schema writeSchema = this.readSchemaFromResources("schema-location-write.json");
        Schema readSchema = this.readSchemaFromResources("schema-location-read.json");
        GenericData.Record record = new GenericData.Record(writeSchema);
        GenericData.Record location = new GenericData.Record(locationSchema);
        location.put("lat", (Object)Float.valueOf(52.995144f));
        location.put("long", (Object)Float.valueOf(-1.539054f));
        HashMap<String, GenericData.Record> locations = new HashMap<String, GenericData.Record>();
        locations.put("l1", location);
        record.put("location", locations);
        try (ByteArrayOutputStream bbos = new ByteArrayOutputStream();){
            GenericDatumWriter datumWriter = new GenericDatumWriter(writeSchema);
            BinaryEncoder enc = EncoderFactory.get().binaryEncoder((OutputStream)bbos, null);
            datumWriter.write((Object)record, (Encoder)enc);
            enc.flush();
            payload = bbos.toByteArray();
        }
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(payload, null);
        GenericDatumReader reader = new GenericDatumReader();
        reader.setSchema(writeSchema);
        reader.setExpected(readSchema);
        GenericData.Record r = (GenericData.Record)reader.read(null, (Decoder)decoder);
        HashMap locs = (HashMap)r.get("location");
        GenericData.Record loc = (GenericData.Record)locs.get(new Utf8("l1"));
        Assertions.assertNotNull((Object)loc.get("lat"));
        Assertions.assertNull((Object)loc.get("long_r2"));
    }

    private static final class DecodingTestCase {
        private final Schema mWriterSchema;
        private final Object mDatum;
        private final Schema mReaderSchema;
        private final Object mDecodedDatum;

        public DecodingTestCase(Schema writerSchema, Object datum, Schema readerSchema, Object decoded) {
            this.mWriterSchema = writerSchema;
            this.mDatum = datum;
            this.mReaderSchema = readerSchema;
            this.mDecodedDatum = decoded;
        }

        public Schema getReaderSchema() {
            return this.mReaderSchema;
        }

        public Schema getWriterSchema() {
            return this.mWriterSchema;
        }

        public Object getDatum() {
            return this.mDatum;
        }

        public Object getDecodedDatum() {
            return this.mDecodedDatum;
        }
    }
}

