/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSchemaCommons {
    private static final Logger LOG = LoggerFactory.getLogger(TestSchemaCommons.class);

    @ParameterizedTest
    @MethodSource(value={"sharedFolders"})
    void runFolder(File folder) throws IOException {
        File schemaSource = new File(folder, "schema.json");
        File data = new File(folder, "data.avro");
        if (!schemaSource.exists()) {
            LOG.warn("No 'schema.json' file on folder {}", (Object)folder.getPath());
            return;
        }
        Schema schema = new Schema.Parser().parse(schemaSource);
        Assertions.assertNotNull((Object)schema);
        if (!data.exists()) {
            LOG.warn("No 'data.avro' file on folder {}", (Object)folder.getPath());
            return;
        }
        String rootTest = Thread.currentThread().getContextClassLoader().getResource(".").getPath();
        File copyData = new File(rootTest, "copy.avro");
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        GenericDatumReader datumReader = new GenericDatumReader(schema);
        try (DataFileReader dataFileReader = new DataFileReader(data, (DatumReader)datumReader);
             DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, copyData);
            GenericRecord record = null;
            int counter = 0;
            while (dataFileReader.hasNext()) {
                record = (GenericRecord)dataFileReader.next();
                ++counter;
                Assertions.assertNotNull((Object)record);
                dataFileWriter.append((Object)record);
            }
            Assertions.assertTrue((counter > 0 ? 1 : 0) != 0, (String)"no data in file");
        }
        Assertions.assertTrue((boolean)copyData.delete());
    }

    public static Stream<Arguments> sharedFolders() {
        File root = new File("target/test-classes/share/test/data/schemas");
        return Arrays.stream(root.listFiles(File::isDirectory)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

