/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestReadingWritingDataInEvolvedSchemas {
    private static final String RECORD_A = "RecordA";
    private static final String FIELD_A = "fieldA";
    private static final char LATIN_SMALL_LETTER_O_WITH_DIARESIS = '\u00f6';
    private static final Schema DOUBLE_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().doubleType().noDefault().endRecord();
    private static final Schema FLOAT_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().floatType().noDefault().endRecord();
    private static final Schema LONG_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().longType().noDefault().endRecord();
    private static final Schema INT_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().intType().noDefault().endRecord();
    private static final Schema UNION_INT_LONG_FLOAT_DOUBLE_RECORD = (Schema)((SchemaBuilder.DoubleDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().doubleType().and().floatType()).and().longType()).and().intType()).endUnion()).noDefault().endRecord();
    private static final Schema STRING_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().stringType().noDefault().endRecord();
    private static final Schema BYTES_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().bytesType().noDefault().endRecord();
    private static final Schema UNION_STRING_BYTES_RECORD = (Schema)((SchemaBuilder.StringDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().stringType().and().bytesType()).endUnion()).noDefault().endRecord();
    private static final Schema ENUM_AB = (Schema)SchemaBuilder.enumeration((String)"Enum1").symbols(new String[]{"A", "B"});
    private static final Schema ENUM_AB_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type(ENUM_AB).noDefault().endRecord();
    private static final Schema ENUM_ABC = (Schema)SchemaBuilder.enumeration((String)"Enum1").symbols(new String[]{"A", "B", "C"});
    private static final Schema ENUM_ABC_RECORD = (Schema)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type(ENUM_ABC).noDefault().endRecord();
    private static final Schema UNION_INT_RECORD = (Schema)((SchemaBuilder.IntDefault)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().intType().endUnion()).noDefault().endRecord();
    private static final Schema UNION_LONG_RECORD = (Schema)((SchemaBuilder.LongDefault)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().longType().endUnion()).noDefault().endRecord();
    private static final Schema UNION_FLOAT_RECORD = (Schema)((SchemaBuilder.FloatDefault)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().floatType().endUnion()).noDefault().endRecord();
    private static final Schema UNION_DOUBLE_RECORD = (Schema)((SchemaBuilder.DoubleDefault)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().doubleType().endUnion()).noDefault().endRecord();
    private static final Schema UNION_LONG_FLOAT_RECORD = (Schema)((SchemaBuilder.FloatDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().floatType().and().longType()).endUnion()).noDefault().endRecord();
    private static final Schema UNION_FLOAT_DOUBLE_RECORD = (Schema)((SchemaBuilder.FloatDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"RecordA").fields().name("fieldA").type().unionOf().floatType().and().doubleType()).endUnion()).noDefault().endRecord();

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void doubleWrittenWithUnionSchemaIsConvertedToDoubleSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_LONG_FLOAT_DOUBLE_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42.0);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(DOUBLE_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)42.0, (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void longWrittenWithUnionSchemaIsConvertedToUnionLongFloatSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_LONG_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42L);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(UNION_LONG_FLOAT_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)42L, (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void longWrittenWithUnionSchemaIsConvertedToDoubleSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_LONG_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42L);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(UNION_DOUBLE_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)42.0, (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void intWrittenWithUnionSchemaIsConvertedToDoubleSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(UNION_DOUBLE_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)42.0, (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void intWrittenWithUnionSchemaIsReadableByFloatSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(FLOAT_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void intWrittenWithUnionSchemaIsReadableByFloatUnionSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(UNION_FLOAT_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void longWrittenWithUnionSchemaIsReadableByFloatSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_LONG_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42L);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(FLOAT_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void longWrittenWithUnionSchemaIsReadableByFloatUnionSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_LONG_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42L);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(UNION_FLOAT_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void longWrittenWithUnionSchemaIsConvertedToLongFloatUnionSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_LONG_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42L);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(UNION_LONG_FLOAT_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)42L, (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void longWrittenWithUnionSchemaIsConvertedToFloatDoubleUnionSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_LONG_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42L);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(UNION_FLOAT_DOUBLE_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)decoded.get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void doubleWrittenWithUnionSchemaIsNotConvertedToFloatSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_LONG_FLOAT_DOUBLE_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42.0);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        AvroTypeException exception = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> this.decodeGenericBlob(FLOAT_RECORD, writer, encoded, encoderType));
        Assertions.assertEquals((Object)"Found double, expecting float", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void floatWrittenWithUnionSchemaIsNotConvertedToLongSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_LONG_FLOAT_DOUBLE_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, Float.valueOf(42.0f));
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        AvroTypeException exception = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> this.decodeGenericBlob(LONG_RECORD, writer, encoded, encoderType));
        Assertions.assertEquals((Object)"Found float, expecting long", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void longWrittenWithUnionSchemaIsNotConvertedToIntSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_LONG_FLOAT_DOUBLE_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42L);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        AvroTypeException exception = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> this.decodeGenericBlob(INT_RECORD, writer, encoded, encoderType));
        Assertions.assertEquals((Object)"Found long, expecting int", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void intWrittenWithUnionSchemaIsConvertedToAllNumberSchemas(EncoderType encoderType) throws Exception {
        Schema writer = UNION_INT_LONG_FLOAT_DOUBLE_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        Assert.assertEquals((Object)42.0, (Object)this.decodeGenericBlob(DOUBLE_RECORD, writer, encoded, encoderType).get(FIELD_A));
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)this.decodeGenericBlob(FLOAT_RECORD, writer, encoded, encoderType).get(FIELD_A));
        Assert.assertEquals((Object)42L, (Object)this.decodeGenericBlob(LONG_RECORD, writer, encoded, encoderType).get(FIELD_A));
        Assert.assertEquals((Object)42, (Object)this.decodeGenericBlob(INT_RECORD, writer, encoded, encoderType).get(FIELD_A));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void asciiStringWrittenWithUnionSchemaIsConvertedToBytesSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_STRING_BYTES_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, "42");
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        ByteBuffer actual = (ByteBuffer)this.decodeGenericBlob(BYTES_RECORD, writer, encoded, encoderType).get(FIELD_A);
        Assert.assertArrayEquals((byte[])"42".getBytes(StandardCharsets.UTF_8), (byte[])actual.array());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void utf8StringWrittenWithUnionSchemaIsConvertedToBytesSchema(EncoderType encoderType) throws Exception {
        String goeran = String.format("G%sran", Character.valueOf('\u00f6'));
        Schema writer = UNION_STRING_BYTES_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, goeran);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        ByteBuffer actual = (ByteBuffer)this.decodeGenericBlob(BYTES_RECORD, writer, encoded, encoderType).get(FIELD_A);
        Assert.assertArrayEquals((byte[])goeran.getBytes(StandardCharsets.UTF_8), (byte[])actual.array());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void asciiBytesWrittenWithUnionSchemaIsConvertedToStringSchema(EncoderType encoderType) throws Exception {
        Schema writer = UNION_STRING_BYTES_RECORD;
        ByteBuffer buf = ByteBuffer.wrap("42".getBytes(StandardCharsets.UTF_8));
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, buf);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        CharSequence read = (CharSequence)this.decodeGenericBlob(STRING_RECORD, writer, encoded, encoderType).get(FIELD_A);
        Assert.assertEquals((Object)"42", (Object)read.toString());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void utf8BytesWrittenWithUnionSchemaIsConvertedToStringSchema(EncoderType encoderType) throws Exception {
        String goeran = String.format("G%sran", Character.valueOf('\u00f6'));
        Schema writer = UNION_STRING_BYTES_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, goeran);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        CharSequence read = (CharSequence)this.decodeGenericBlob(STRING_RECORD, writer, encoded, encoderType).get(FIELD_A);
        Assert.assertEquals((Object)goeran, (Object)read.toString());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void enumRecordCanBeReadWithExtendedEnumSchema(EncoderType encoderType) throws Exception {
        Schema writer = ENUM_AB_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, new GenericData.EnumSymbol(ENUM_AB, "A"));
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(ENUM_ABC_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)"A", (Object)decoded.get(FIELD_A).toString());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void enumRecordWithExtendedSchemaCanBeReadWithOriginalEnumSchemaIfOnlyOldValues(EncoderType encoderType) throws Exception {
        Schema writer = ENUM_ABC_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, new GenericData.EnumSymbol(ENUM_ABC, "A"));
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(ENUM_AB_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)"A", (Object)decoded.get(FIELD_A).toString());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void enumRecordWithExtendedSchemaCanNotBeReadIfNewValuesAreUsed(EncoderType encoderType) throws Exception {
        Schema writer = ENUM_ABC_RECORD;
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, new GenericData.EnumSymbol(ENUM_ABC, "C"));
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        AvroTypeException exception = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> this.decodeGenericBlob(ENUM_AB_RECORD, writer, encoded, encoderType));
        Assertions.assertEquals((Object)"No match for C", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void recordWrittenWithExtendedSchemaCanBeReadWithOriginalSchemaButLossOfData(EncoderType encoderType) throws Exception {
        Schema writer = (Schema)SchemaBuilder.record((String)RECORD_A).fields().name("newTopField").type().stringType().noDefault().name(FIELD_A).type().intType().noDefault().endRecord();
        GenericData.Record record = this.defaultRecordWithSchema(writer, FIELD_A, 42);
        record.put("newTopField", (Object)"not decoded");
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(INT_RECORD, writer, encoded, encoderType);
        Assert.assertEquals((Object)42, (Object)decoded.get(FIELD_A));
        try {
            decoded.get("newTopField");
            Assertions.fail((String)"get should throw a exception");
        }
        catch (AvroRuntimeException ex) {
            Assertions.assertEquals((Object)"Not a valid schema field: newTopField", (Object)ex.getMessage());
        }
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void readerWithoutDefaultValueThrowsException(EncoderType encoderType) throws Exception {
        Schema reader = (Schema)SchemaBuilder.record((String)RECORD_A).fields().name("newField").type().intType().noDefault().name(FIELD_A).type().intType().noDefault().endRecord();
        GenericData.Record record = this.defaultRecordWithSchema(INT_RECORD, FIELD_A, 42);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        AvroTypeException exception = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> this.decodeGenericBlob(reader, INT_RECORD, encoded, encoderType));
        Assertions.assertTrue((boolean)exception.getMessage().contains("missing required field newField"), (String)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void readerWithDefaultValueIsApplied(EncoderType encoderType) throws Exception {
        Schema reader = (Schema)SchemaBuilder.record((String)RECORD_A).fields().name("newFieldWithDefault").type().intType().intDefault(314).name(FIELD_A).type().intType().noDefault().endRecord();
        GenericData.Record record = this.defaultRecordWithSchema(INT_RECORD, FIELD_A, 42);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(reader, INT_RECORD, encoded, encoderType);
        Assert.assertEquals((Object)42, (Object)decoded.get(FIELD_A));
        Assert.assertEquals((Object)314, (Object)decoded.get("newFieldWithDefault"));
    }

    @ParameterizedTest
    @EnumSource(value=EncoderType.class)
    void aliasesInSchema(EncoderType encoderType) throws Exception {
        Schema writer = new Schema.Parser().parse("{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\", \"fields\": [{\"name\": \"name\", \"type\": \"int\"}\n]}\n");
        Schema reader = new Schema.Parser().parse("{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\", \"fields\": [{\"name\": \"fname\", \"type\": \"int\", \"aliases\" : [ \"name\" ]}\n]}\n");
        GenericData.Record record = this.defaultRecordWithSchema(writer, "name", 1);
        byte[] encoded = this.encodeGenericBlob((GenericRecord)record, encoderType);
        GenericData.Record decoded = this.decodeGenericBlob(reader, reader, encoded, encoderType);
        Assert.assertEquals((Object)1, (Object)decoded.get("fname"));
    }

    private <T> GenericData.Record defaultRecordWithSchema(Schema schema, String key, T value) {
        GenericData.Record data = new GenericData.Record(schema);
        data.put(key, value);
        return data;
    }

    private byte[] encodeGenericBlob(GenericRecord data, EncoderType encoderType) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(data.getSchema());
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = encoderType == EncoderType.BINARY ? EncoderFactory.get().binaryEncoder((OutputStream)outStream, null) : EncoderFactory.get().jsonEncoder(data.getSchema(), (OutputStream)outStream);
        writer.write((Object)data, (Encoder)encoder);
        encoder.flush();
        outStream.close();
        return outStream.toByteArray();
    }

    private GenericData.Record decodeGenericBlob(Schema expectedSchema, Schema schemaOfBlob, byte[] blob, EncoderType encoderType) throws IOException {
        if (blob == null) {
            return null;
        }
        GenericDatumReader reader = new GenericDatumReader();
        reader.setExpected(expectedSchema);
        reader.setSchema(schemaOfBlob);
        BinaryDecoder decoder = encoderType == EncoderType.BINARY ? DecoderFactory.get().binaryDecoder(blob, null) : DecoderFactory.get().jsonDecoder(schemaOfBlob, (InputStream)new ByteArrayInputStream(blob));
        return (GenericData.Record)reader.read(null, (Decoder)decoder);
    }

    static enum EncoderType {
        BINARY,
        JSON;

    }
}

