/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaNormalization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtocol {
    @Test
    public void parse() throws IOException {
        File fic = new File("target/test-classes/share/test/schemas/namespace.avpr");
        Protocol protocol = Protocol.parse((File)fic);
        Assertions.assertNotNull((Object)protocol);
        Assertions.assertEquals((Object)"TestNamespace", (Object)protocol.getName());
    }

    @Test
    public void crossProtocol() {
        String userStatus = "{ \"protocol\" : \"p1\", \"types\": [{\"name\": \"User\", \"type\": \"record\", \"fields\": [{\"name\": \"current_status\", \"type\": \"Status\"}]},\n\n{\"name\": \"Status\", \"type\": \"record\", \"fields\": [{\"name\": \"author\", \"type\": \"User\"}]}]}";
        Protocol protocol = Protocol.parse((String)userStatus);
        Schema userSchema = protocol.getType("User");
        Schema statusSchema = protocol.getType("Status");
        Assertions.assertSame((Object)statusSchema, (Object)userSchema.getField("current_status").schema());
        Assertions.assertSame((Object)userSchema, (Object)statusSchema.getField("author").schema());
        String parsingFormUser = SchemaNormalization.toParsingForm((Schema)userSchema);
        Assertions.assertEquals((Object)"{\"name\":\"User\",\"type\":\"record\",\"fields\":[{\"name\":\"current_status\",\"type\":{\"name\":\"Status\",\"type\":\"record\",\"fields\":[{\"name\":\"author\",\"type\":\"User\"}]}}]}", (Object)parsingFormUser);
        String parsingFormStatus = SchemaNormalization.toParsingForm((Schema)statusSchema);
        Assertions.assertEquals((Object)"{\"name\":\"Status\",\"type\":\"record\",\"fields\":[{\"name\":\"author\",\"type\":{\"name\":\"User\",\"type\":\"record\",\"fields\":[{\"name\":\"current_status\",\"type\":\"Status\"}]}}]}", (Object)parsingFormStatus);
    }

    @Test
    void normalization() {
        String schema = "{\n \"type\":\"record\",  \"name\": \"Main\",  \"fields\":[\n    {  \"name\":\"f1\", \"type\":\"Sub\"  },\n    {  \"name\":\"f2\",        \"type\":{\n         \"type\":\"enum\",  \"name\":\"Sub\",\n         \"symbols\":[\"OPEN\",\"CLOSE\"]\n        }\n    }\n ]\n}";
        Schema s = new Schema.Parser().parse("{\n \"type\":\"record\",  \"name\": \"Main\",  \"fields\":[\n    {  \"name\":\"f1\", \"type\":\"Sub\"  },\n    {  \"name\":\"f2\",        \"type\":{\n         \"type\":\"enum\",  \"name\":\"Sub\",\n         \"symbols\":[\"OPEN\",\"CLOSE\"]\n        }\n    }\n ]\n}");
        Assertions.assertNotNull((Object)s);
        String parsingForm = SchemaNormalization.toParsingForm((Schema)s);
        Assertions.assertEquals((Object)"{\"name\":\"Main\",\"type\":\"record\",\"fields\":[{\"name\":\"f1\",\"type\":{\"name\":\"Sub\",\"type\":\"enum\",\"symbols\":[\"OPEN\",\"CLOSE\"]}},{\"name\":\"f2\",\"type\":\"Sub\"}]}", (Object)parsingForm);
    }

    @Test
    void namespaceAndNameRules() {
        Protocol p1 = new Protocol("P", null, "foo");
        Protocol p2 = new Protocol("foo.P", null, null);
        Protocol p3 = new Protocol("foo.P", null, "bar");
        Assertions.assertEquals((Object)p1.getName(), (Object)p2.getName());
        Assertions.assertEquals((Object)p1.getNamespace(), (Object)p2.getNamespace());
        Assertions.assertEquals((Object)p1.getName(), (Object)p3.getName());
        Assertions.assertEquals((Object)p1.getNamespace(), (Object)p3.getNamespace());
        Protocol invalidName = new Protocol(".P", null, "ignored");
        Assertions.assertNull((Object)invalidName.getNamespace());
        Assertions.assertEquals((Object)"P", (Object)invalidName.getName());
    }

    @Test
    void propEquals() {
        Protocol p1 = new Protocol("P", null, "foo");
        p1.addProp("a", "1");
        Protocol p2 = new Protocol("P", null, "foo");
        p2.addProp("a", "2");
        Assertions.assertNotEquals((Object)p1, (Object)p2);
    }

    @Test
    void splitProtocolBuild() {
        Protocol p = new Protocol("P", null, "foo");
        p.addProp("property", "some value");
        String protocolString = p.toString();
        int mid = protocolString.length() / 2;
        Protocol parsedStringProtocol = Protocol.parse((String)protocolString);
        Protocol parsedArrayOfStringProtocol = Protocol.parse((String)protocolString.substring(0, mid), (String[])new String[]{protocolString.substring(mid)});
        Assertions.assertNotNull((Object)parsedStringProtocol);
        Assertions.assertNotNull((Object)parsedArrayOfStringProtocol);
        Assertions.assertEquals((Object)parsedStringProtocol.toString(), (Object)parsedArrayOfStringProtocol.toString());
    }

    @Test
    void copyMessage() {
        Protocol p = new Protocol("P", "protocol", "foo");
        Schema req1 = (Schema)SchemaBuilder.record((String)"foo.req1").fields().endRecord();
        Protocol.Message m1 = p.createMessage("M", "message", Collections.singletonMap("foo", "bar"), req1);
        Schema req2 = (Schema)SchemaBuilder.record((String)"foo.req2").fields().name("test").type().booleanType().noDefault().endRecord();
        Protocol.Message m2 = p.createMessage(m1, req2);
        Assertions.assertEquals((Object)m1.getName(), (Object)m2.getName());
        Assertions.assertEquals((Object)m1.getDoc(), (Object)m2.getDoc());
        Assertions.assertEquals((Object)m1.getProp("foo"), (Object)m2.getProp("foo"));
    }
}

