/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFixed {
    @Test
    void fixedDefaultValueDrop() {
        Schema md5 = (Schema)SchemaBuilder.builder().fixed("MD5").size(16);
        Schema frec = (Schema)SchemaBuilder.builder().record("test").fields().name("hash").type(md5).withDefault((Object)new byte[16]).endRecord();
        Schema.Field field = frec.getField("hash");
        Assertions.assertNotNull((Object)field.defaultVal());
        Assertions.assertArrayEquals((byte[])new byte[16], (byte[])((byte[])field.defaultVal()));
    }

    @Test
    void fixedLengthOutOfLimit() {
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> Schema.createFixed((String)"oversize", (String)"doc", (String)"space", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"Cannot read arrays longer than 2147483639 bytes in Java library", (Object)ex.getMessage());
    }

    @Test
    void fixedNegativeLength() {
        Exception ex = (Exception)Assertions.assertThrows(AvroRuntimeException.class, () -> Schema.createFixed((String)"negative", (String)"doc", (String)"space", (int)-1));
        Assertions.assertEquals((Object)"Malformed data. Length is negative: -1", (Object)ex.getMessage());
    }
}

