/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDecimalConversion {
    private static final Conversion<BigDecimal> CONVERSION = new Conversions.DecimalConversion();
    private Schema smallerSchema;
    private LogicalType smallerLogicalType;
    private Schema largerSchema;
    private LogicalType largerLogicalType;

    @BeforeEach
    public void setup() {
        this.smallerSchema = Schema.createFixed((String)"smallFixed", null, null, (int)3);
        this.smallerSchema.addProp("logicalType", "decimal");
        this.smallerSchema.addProp("precision", (Object)5);
        this.smallerSchema.addProp("scale", (Object)2);
        this.smallerLogicalType = LogicalTypes.fromSchema((Schema)this.smallerSchema);
        this.largerSchema = Schema.createFixed((String)"largeFixed", null, null, (int)12);
        this.largerSchema.addProp("logicalType", "decimal");
        this.largerSchema.addProp("precision", (Object)28);
        this.largerSchema.addProp("scale", (Object)15);
        this.largerLogicalType = LogicalTypes.fromSchema((Schema)this.largerSchema);
    }

    @Test
    void toFromBytes() {
        BigDecimal value = BigDecimal.valueOf(10.99).setScale(15, RoundingMode.HALF_EVEN);
        ByteBuffer byteBuffer = CONVERSION.toBytes((Object)value, this.largerSchema, this.largerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromBytes(byteBuffer, this.largerSchema, this.largerLogicalType);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    void toFromBytesMaxPrecision() {
        BigDecimal value = new BigDecimal("4567335489766.99834").setScale(15, RoundingMode.HALF_EVEN);
        ByteBuffer byteBuffer = CONVERSION.toBytes((Object)value, this.largerSchema, this.largerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromBytes(byteBuffer, this.largerSchema, this.largerLogicalType);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    void toBytesPrecisionError() {
        BigDecimal value = new BigDecimal("1.07046455859736525E+18").setScale(15, RoundingMode.HALF_EVEN);
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> CONVERSION.toBytes((Object)value, this.largerSchema, this.largerLogicalType));
        Assertions.assertEquals((Object)"Cannot encode decimal with precision 34 as max precision 28", (Object)avroTypeException.getMessage());
    }

    @Test
    void toBytesFixedSmallerScale() {
        BigDecimal value = new BigDecimal("99892.1234").setScale(10, RoundingMode.HALF_EVEN);
        ByteBuffer byteBuffer = CONVERSION.toBytes((Object)value, this.largerSchema, this.largerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromBytes(byteBuffer, this.largerSchema, this.largerLogicalType);
        Assertions.assertEquals((Object)new BigDecimal("99892.123400000000000"), (Object)result);
    }

    @Test
    void toBytesScaleError() {
        BigDecimal value = new BigDecimal("4567335489766.989989998435899453").setScale(16, RoundingMode.HALF_EVEN);
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> CONVERSION.toBytes((Object)value, this.largerSchema, this.largerLogicalType));
        Assertions.assertEquals((Object)"Cannot encode decimal with scale 16 as scale 15 without rounding", (Object)avroTypeException.getMessage());
    }

    @Test
    void toFromFixed() {
        BigDecimal value = new BigDecimal("3").setScale(15, RoundingMode.HALF_EVEN);
        GenericFixed fixed = CONVERSION.toFixed((Object)value, this.largerSchema, this.largerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromFixed(fixed, this.largerSchema, this.largerLogicalType);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    void toFromFixedMaxPrecision() {
        BigDecimal value = new BigDecimal("4567335489766.99834").setScale(15, RoundingMode.HALF_EVEN);
        GenericFixed fixed = CONVERSION.toFixed((Object)value, this.largerSchema, this.largerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromFixed(fixed, this.largerSchema, this.largerLogicalType);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    void toFixedPrecisionError() {
        BigDecimal value = new BigDecimal("1.07046455859736525E+18").setScale(15, RoundingMode.HALF_EVEN);
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> CONVERSION.toFixed((Object)value, this.largerSchema, this.largerLogicalType));
        Assertions.assertEquals((Object)"Cannot encode decimal with precision 34 as max precision 28", (Object)avroTypeException.getMessage());
    }

    @Test
    void toFromFixedSmallerScale() {
        BigDecimal value = new BigDecimal("99892.1234").setScale(10, RoundingMode.HALF_EVEN);
        GenericFixed fixed = CONVERSION.toFixed((Object)value, this.largerSchema, this.largerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromFixed(fixed, this.largerSchema, this.largerLogicalType);
        Assertions.assertEquals((Object)new BigDecimal("99892.123400000000000"), (Object)result);
    }

    @Test
    void toFixedScaleError() {
        BigDecimal value = new BigDecimal("4567335489766.3453453453453453453453").setScale(16, RoundingMode.HALF_EVEN);
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> CONVERSION.toFixed((Object)value, this.largerSchema, this.largerLogicalType));
        Assertions.assertEquals((Object)"Cannot encode decimal with scale 16 as scale 15 without rounding", (Object)avroTypeException.getMessage());
    }

    @Test
    void toFromFixedMatchScaleAndPrecision() {
        BigDecimal value = new BigDecimal("123.45");
        GenericFixed fixed = CONVERSION.toFixed((Object)value, this.smallerSchema, this.smallerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromFixed(fixed, this.smallerSchema, this.smallerLogicalType);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    void toFromFixedRepresentedInLogicalTypeAllowRoundUnneccesary() {
        BigDecimal value = new BigDecimal("123.4500");
        GenericFixed fixed = CONVERSION.toFixed((Object)value, this.smallerSchema, this.smallerLogicalType);
        BigDecimal result = (BigDecimal)CONVERSION.fromFixed(fixed, this.smallerSchema, this.smallerLogicalType);
        Assertions.assertEquals((Object)new BigDecimal("123.45"), (Object)result);
    }

    @Test
    void toFromFixedPrecisionErrorAfterAdjustingScale() {
        BigDecimal value = new BigDecimal("1234.560");
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> CONVERSION.toFixed((Object)value, this.smallerSchema, this.smallerLogicalType));
        Assertions.assertEquals((Object)"Cannot encode decimal with precision 6 as max precision 5. This is after safely adjusting scale from 3 to required 2", (Object)avroTypeException.getMessage());
    }

    @Test
    void toFixedRepresentedInLogicalTypeErrorIfRoundingRequired() {
        BigDecimal value = new BigDecimal("123.456");
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> CONVERSION.toFixed((Object)value, this.smallerSchema, this.smallerLogicalType));
        Assertions.assertEquals((Object)"Cannot encode decimal with scale 3 as scale 2 without rounding", (Object)avroTypeException.getMessage());
    }

    @Test
    void importanceOfEnsuringCorrectScaleWhenConvertingFixed() {
        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)this.smallerLogicalType;
        BigDecimal bigDecimal = new BigDecimal("1234.5");
        Assertions.assertEquals((int)decimal.getPrecision(), (int)bigDecimal.precision());
        Assertions.assertTrue((decimal.getScale() >= bigDecimal.scale() ? 1 : 0) != 0);
        byte[] bytes = bigDecimal.unscaledValue().toByteArray();
        BigDecimal fromFixed = (BigDecimal)CONVERSION.fromFixed((GenericFixed)new GenericData.Fixed(this.smallerSchema, bytes), this.smallerSchema, (LogicalType)decimal);
        Assertions.assertNotEquals((int)0, (int)bigDecimal.compareTo(fromFixed));
        Assertions.assertNotEquals((Object)bigDecimal, (Object)fromFixed);
        Assertions.assertEquals((Object)new BigDecimal("123.45"), (Object)fromFixed);
    }

    @Test
    void importanceOfEnsuringCorrectScaleWhenConvertingBytes() {
        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)this.smallerLogicalType;
        BigDecimal bigDecimal = new BigDecimal("1234.5");
        Assertions.assertEquals((int)decimal.getPrecision(), (int)bigDecimal.precision());
        Assertions.assertTrue((decimal.getScale() >= bigDecimal.scale() ? 1 : 0) != 0);
        byte[] bytes = bigDecimal.unscaledValue().toByteArray();
        BigDecimal fromBytes = (BigDecimal)CONVERSION.fromBytes(ByteBuffer.wrap(bytes), this.smallerSchema, (LogicalType)decimal);
        Assertions.assertNotEquals((int)0, (int)bigDecimal.compareTo(fromBytes));
        Assertions.assertNotEquals((Object)bigDecimal, (Object)fromBytes);
        Assertions.assertEquals((Object)new BigDecimal("123.45"), (Object)fromBytes);
    }
}

