/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.BarRecord;
import org.apache.avro.ByteBufferRecord;
import org.apache.avro.FooRecord;
import org.apache.avro.Schema;
import org.apache.avro.TypeEnum;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDataFileReflect {
    @TempDir
    public File DIR;

    @Test
    void multiReflectWithUnionBeforeWriting() throws IOException {
        File file = new File(this.DIR.getPath(), "testMultiReflectWithUnionBeforeWriting.avro");
        CheckList check = new CheckList();
        try (FileOutputStream fos = new FileOutputStream(file);){
            ReflectData reflectData = ReflectData.get();
            List<Schema> schemas = Arrays.asList(reflectData.getSchema(FooRecord.class), reflectData.getSchema(BarRecord.class));
            Schema union = Schema.createUnion(schemas);
            try (DataFileWriter writer = new DataFileWriter((DatumWriter)new ReflectDatumWriter(union));){
                writer.create(union, (OutputStream)fos);
                this.write(writer, new BarRecord("One beer please"), check);
                this.write(writer, new FooRecord(10), check);
                this.write(writer, new BarRecord("Two beers please"), check);
                this.write(writer, new FooRecord(20), check);
            }
        }
        ReflectDatumReader din = new ReflectDatumReader();
        SeekableFileInput sin = new SeekableFileInput(file);
        try (DataFileReader reader = new DataFileReader((SeekableInput)sin, (DatumReader)din);){
            int count = 0;
            for (Object datum : reader) {
                check.assertEquals(datum, count++);
            }
            Assertions.assertEquals((int)count, (int)check.size());
        }
    }

    @Test
    void testNull() throws IOException {
        File file = new File(this.DIR.getPath(), "testNull.avro");
        CheckList check = new CheckList();
        try (FileOutputStream fos = new FileOutputStream(file);){
            ReflectData.AllowNull reflectData = ReflectData.AllowNull.get();
            Schema schema = reflectData.getSchema(BarRecord.class);
            try (DataFileWriter writer = new DataFileWriter((DatumWriter)new ReflectDatumWriter(BarRecord.class, (ReflectData)reflectData));){
                writer.create(schema, (OutputStream)fos);
                this.write(writer, new BarRecord("One beer please"), check);
                this.write(writer, new BarRecord(), check);
                this.write(writer, new BarRecord("Two beers please"), check);
            }
        }
        ReflectDatumReader din = new ReflectDatumReader();
        try (SeekableFileInput sin = new SeekableFileInput(file);
             DataFileReader reader = new DataFileReader((SeekableInput)sin, (DatumReader)din);){
            int count = 0;
            for (BarRecord datum : reader) {
                check.assertEquals(datum, count++);
            }
            Assertions.assertEquals((int)count, (int)check.size());
        }
    }

    @Test
    void testNew() throws IOException {
        ByteBuffer payload = ByteBuffer.allocateDirect(8192);
        for (int i = 0; i < 500; ++i) {
            payload.putInt(1);
        }
        payload.flip();
        ByteBufferRecord bbr = new ByteBufferRecord();
        bbr.setPayload(payload);
        bbr.setTp(TypeEnum.b);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ReflectDatumWriter writer = new ReflectDatumWriter(ByteBufferRecord.class);
        BinaryEncoder avroEncoder = EncoderFactory.get().blockingBinaryEncoder((OutputStream)outputStream, null);
        writer.write((Object)bbr, (Encoder)avroEncoder);
        avroEncoder.flush();
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ReflectDatumReader datumReader = new ReflectDatumReader(ByteBufferRecord.class);
        BinaryDecoder avroDecoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        ByteBufferRecord deserialized = (ByteBufferRecord)datumReader.read(null, (Decoder)avroDecoder);
        Assertions.assertEquals((Object)bbr, (Object)deserialized);
    }

    @Test
    void nestedClass() throws IOException {
        File file = new File(this.DIR.getPath(), "testNull.avro");
        CheckList check = new CheckList();
        try (FileOutputStream fos = new FileOutputStream(file);){
            Schema schema = ReflectData.get().getSchema(BazRecord.class);
            try (DataFileWriter writer = new DataFileWriter((DatumWriter)new ReflectDatumWriter(schema));){
                writer.create(schema, (OutputStream)fos);
                this.write(writer, new BazRecord(10), check);
                this.write(writer, new BazRecord(20), check);
            }
        }
        ReflectDatumReader din = new ReflectDatumReader();
        try (SeekableFileInput sin = new SeekableFileInput(file);
             DataFileReader reader = new DataFileReader((SeekableInput)sin, (DatumReader)din);){
            int count = 0;
            for (BazRecord datum : reader) {
                check.assertEquals(datum, count++);
            }
            Assertions.assertEquals((int)count, (int)check.size());
        }
    }

    private <T> void write(DataFileWriter<T> writer, T o, CheckList<T> l) throws IOException {
        writer.append(l.addAndReturn(o));
    }

    private static class CheckList<T>
    extends ArrayList<T> {
        private CheckList() {
        }

        T addAndReturn(T check) {
            this.add(check);
            return check;
        }

        void assertEquals(Object toCheck, int i) {
            Assertions.assertNotNull((Object)toCheck);
            Object o = this.get(i);
            Assertions.assertNotNull(o);
            Assertions.assertEquals((Object)toCheck, o);
        }
    }

    private static class BazRecord {
        private int nbr;

        public BazRecord() {
        }

        public BazRecord(int nbr) {
            this.nbr = nbr;
        }

        public boolean equals(Object that) {
            if (that instanceof BazRecord) {
                return this.nbr == ((BazRecord)that).nbr;
            }
            return false;
        }

        public int hashCode() {
            return this.nbr;
        }

        public String toString() {
            return BazRecord.class.getSimpleName() + "{cnt=" + this.nbr + "}";
        }
    }
}

