/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDataFileMeta {
    @TempDir
    public File DIR;

    @Test
    public void useReservedMeta() throws IOException {
        try (DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            Assertions.assertThrows(AvroRuntimeException.class, () -> w.setMeta("avro.foo", "bar"));
        }
    }

    @Test
    public void useMeta() throws IOException {
        File f = new File(this.DIR, "testDataFileMeta.avro");
        try (DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            w.setMeta("hello", "bar");
            w.create(Schema.create((Schema.Type)Schema.Type.NULL), f);
        }
        try (DataFileStream r = new DataFileStream((InputStream)new FileInputStream(f), (DatumReader)new GenericDatumReader());){
            Assertions.assertTrue((boolean)r.getMetaKeys().contains("hello"));
            Assertions.assertEquals((Object)"bar", (Object)r.getMetaString("hello"));
        }
    }

    @Test
    public void useMetaAfterCreate() throws IOException {
        try (DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            w.create(Schema.create((Schema.Type)Schema.Type.NULL), (OutputStream)new ByteArrayOutputStream());
            Assertions.assertThrows(AvroRuntimeException.class, () -> w.setMeta("foo", "bar"));
        }
    }

    @Test
    public void blockSizeSetInvalid() {
        int exceptions = 0;
        for (int i = -1; i < 33; ++i) {
            try {
                new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(i);
                continue;
            }
            catch (IllegalArgumentException iae) {
                ++exceptions;
            }
        }
        Assertions.assertEquals((int)33, (int)exceptions);
    }
}

