/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.RandomData;
import org.junit.Assert;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataFileConcat {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataFileConcat.class);
    @TempDir
    public File DIR;
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "200"));
    private static final boolean VALIDATE = !"false".equals(System.getProperty("test.validate", "true"));
    private static final long SEED = System.currentTimeMillis();
    private static final String SCHEMA_JSON = "{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}";
    private static final Schema SCHEMA = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}");

    public static Stream<Arguments> codecs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null, false}), Arguments.of((Object[])new Object[]{null, null, true}), Arguments.of((Object[])new Object[]{CodecFactory.deflateCodec((int)1), CodecFactory.deflateCodec((int)6), false}), Arguments.of((Object[])new Object[]{CodecFactory.deflateCodec((int)1), CodecFactory.deflateCodec((int)6), true}), Arguments.of((Object[])new Object[]{CodecFactory.deflateCodec((int)3), CodecFactory.nullCodec(), false}), Arguments.of((Object[])new Object[]{CodecFactory.nullCodec(), CodecFactory.deflateCodec((int)6), false}), Arguments.of((Object[])new Object[]{CodecFactory.xzCodec((int)1), CodecFactory.xzCodec((int)2), false}), Arguments.of((Object[])new Object[]{CodecFactory.xzCodec((int)1), CodecFactory.xzCodec((int)2), true}), Arguments.of((Object[])new Object[]{CodecFactory.xzCodec((int)2), CodecFactory.nullCodec(), false}), Arguments.of((Object[])new Object[]{CodecFactory.nullCodec(), CodecFactory.xzCodec((int)2), false}));
    }

    private File makeFile(String name) {
        return new File(this.DIR, "test-" + name + ".avro");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void concatenateFiles(CodecFactory codec, CodecFactory codec2, boolean recompress) throws IOException {
        System.out.println("SEED = " + SEED);
        System.out.println("COUNT = " + COUNT);
        for (int k = 0; k < 5; ++k) {
            int syncInterval = 460 + k;
            RandomData data1 = new RandomData(SCHEMA, COUNT, SEED);
            RandomData data2 = new RandomData(SCHEMA, COUNT, SEED + 1L);
            File file1 = this.makeFile((codec == null ? "null" : codec.toString()) + "-A");
            File file2 = this.makeFile((codec2 == null ? "null" : codec2.toString()) + "-B");
            DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(syncInterval);
            if (codec != null) {
                writer.setCodec(codec);
            }
            writer.create(SCHEMA, file1);
            try {
                for (Object datum : data1) {
                    writer.append(datum);
                }
            }
            finally {
                writer.close();
            }
            DataFileWriter writer2 = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(syncInterval);
            if (codec2 != null) {
                writer2.setCodec(codec2);
            }
            writer2.create(SCHEMA, file2);
            try {
                Object datum;
                datum = data2.iterator();
                while (datum.hasNext()) {
                    Object datum2 = datum.next();
                    writer2.append(datum2);
                }
            }
            finally {
                writer2.close();
            }
            DataFileWriter concatinto = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(syncInterval);
            concatinto.appendTo(file1);
            DataFileReader concatfrom = new DataFileReader(file2, (DatumReader)new GenericDatumReader());
            concatinto.appendAllFrom((DataFileStream)concatfrom, recompress);
            concatinto.close();
            concatfrom.close();
            concatfrom = new DataFileReader(file2, (DatumReader)new GenericDatumReader());
            DataFileReader concat = new DataFileReader(file1, (DatumReader)new GenericDatumReader());
            int count = 0;
            try {
                Object datum = null;
                if (VALIDATE) {
                    for (Object expected : data1) {
                        datum = concat.next(datum);
                        Assert.assertEquals((String)("at " + count++), expected, (Object)datum);
                    }
                    for (Object expected : data2) {
                        datum = concatfrom.next(datum);
                        Assert.assertEquals((String)("at " + count++), expected, (Object)datum);
                    }
                    for (Object expected : data2) {
                        datum = concat.next(datum);
                        Assert.assertEquals((String)("at " + count++), expected, (Object)datum);
                    }
                    continue;
                }
                for (int i = 0; i < COUNT * 2; ++i) {
                    datum = concat.next(datum);
                }
                continue;
            }
            finally {
                if (count != 3 * COUNT) {
                    System.out.println(count + " " + k);
                }
                concat.close();
                concatfrom.close();
            }
        }
    }
}

