/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryData;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCompare {
    @Test
    void testNull() throws Exception {
        Schema schema = new Schema.Parser().parse("\"null\"");
        byte[] b = TestCompare.render(null, schema, new GenericDatumWriter());
        Assertions.assertEquals((int)0, (int)BinaryData.compare((byte[])b, (int)0, (byte[])b, (int)0, (Schema)schema));
    }

    @Test
    void testBoolean() throws Exception {
        TestCompare.check("\"boolean\"", Boolean.FALSE, Boolean.TRUE);
    }

    @Test
    void string() throws Exception {
        TestCompare.check("\"string\"", new Utf8(""), new Utf8("a"));
        TestCompare.check("\"string\"", new Utf8("a"), new Utf8("b"));
        TestCompare.check("\"string\"", new Utf8("a"), new Utf8("ab"));
        TestCompare.check("\"string\"", new Utf8("ab"), new Utf8("b"));
    }

    @Test
    void bytes() throws Exception {
        TestCompare.check("\"bytes\"", ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[]{1}));
        TestCompare.check("\"bytes\"", ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2}));
        TestCompare.check("\"bytes\"", ByteBuffer.wrap(new byte[]{1, 2}), ByteBuffer.wrap(new byte[]{2}));
    }

    @Test
    void testInt() throws Exception {
        TestCompare.check("\"int\"", -1, 0);
        TestCompare.check("\"int\"", 0, 1);
    }

    @Test
    void testLong() throws Exception {
        TestCompare.check("\"long\"", 11L, 12L);
        TestCompare.check("\"long\"", -1L, 1L);
    }

    @Test
    void testFloat() throws Exception {
        TestCompare.check("\"float\"", Float.valueOf(1.1f), Float.valueOf(1.2f));
        TestCompare.check("\"float\"", Float.valueOf(-1.1f), Float.valueOf(1.0f));
    }

    @Test
    void testDouble() throws Exception {
        TestCompare.check("\"double\"", 1.2, 1.3);
        TestCompare.check("\"double\"", -1.2, 1.3);
    }

    @Test
    void array() throws Exception {
        String json = "{\"type\":\"array\", \"items\": \"long\"}";
        Schema schema = new Schema.Parser().parse(json);
        GenericData.Array a1 = new GenericData.Array(1, schema);
        a1.add((Object)1L);
        GenericData.Array a2 = new GenericData.Array(1, schema);
        a2.add((Object)1L);
        a2.add((Object)0L);
        TestCompare.check(json, a1, a2);
    }

    @Test
    void record() throws Exception {
        String fields = " \"fields\":[{\"name\":\"f\",\"type\":\"int\",\"order\":\"ignore\"},{\"name\":\"g\",\"type\":\"int\",\"order\":\"descending\"},{\"name\":\"h\",\"type\":\"int\"}]}";
        String recordJson = "{\"type\":\"record\", \"name\":\"Test\"," + fields;
        Schema schema = new Schema.Parser().parse(recordJson);
        GenericData.Record r1 = new GenericData.Record(schema);
        r1.put("f", (Object)1);
        r1.put("g", (Object)13);
        r1.put("h", (Object)41);
        GenericData.Record r2 = new GenericData.Record(schema);
        r2.put("f", (Object)0);
        r2.put("g", (Object)12);
        r2.put("h", (Object)41);
        TestCompare.check(recordJson, r1, r2);
        r2.put("f", (Object)0);
        r2.put("g", (Object)13);
        r2.put("h", (Object)42);
        TestCompare.check(recordJson, r1, r2);
        String record2Json = "{\"type\":\"record\", \"name\":\"Test2\"," + fields;
        Schema schema2 = new Schema.Parser().parse(record2Json);
        GenericData.Record r3 = new GenericData.Record(schema2);
        r3.put("f", (Object)1);
        r3.put("g", (Object)13);
        r3.put("h", (Object)41);
        assert (!r1.equals((Object)r3));
    }

    @Test
    void testEnum() throws Exception {
        String json = "{\"type\":\"enum\", \"name\":\"Test\",\"symbols\": [\"A\", \"B\"]}";
        Schema schema = new Schema.Parser().parse(json);
        TestCompare.check(json, new GenericData.EnumSymbol(schema, "A"), new GenericData.EnumSymbol(schema, "B"));
    }

    @Test
    void fixed() throws Exception {
        String json = "{\"type\": \"fixed\", \"name\":\"Test\", \"size\": 1}";
        Schema schema = new Schema.Parser().parse(json);
        TestCompare.check(json, new GenericData.Fixed(schema, new byte[]{97}), new GenericData.Fixed(schema, new byte[]{98}));
    }

    @Test
    void union() throws Exception {
        TestCompare.check("[\"string\", \"long\"]", new Utf8("a"), new Utf8("b"), false);
        TestCompare.check("[\"string\", \"long\"]", 1L, 2L, false);
        TestCompare.check("[\"string\", \"long\"]", new Utf8("a"), 1L, false);
    }

    private static <T> void check(String schemaJson, T o1, T o2) throws Exception {
        TestCompare.check(schemaJson, o1, o2, true);
    }

    private static <T> void check(String schemaJson, T o1, T o2, boolean comparable) throws Exception {
        TestCompare.check(new Schema.Parser().parse(schemaJson), o1, o2, comparable, new GenericDatumWriter(), GenericData.get());
    }

    private static <T> void check(Schema schema, T o1, T o2, boolean comparable, DatumWriter<T> writer, GenericData comparator) throws Exception {
        byte[] b1 = TestCompare.render(o1, schema, writer);
        byte[] b2 = TestCompare.render(o2, schema, writer);
        Assertions.assertEquals((int)-1, (int)BinaryData.compare((byte[])b1, (int)0, (byte[])b2, (int)0, (Schema)schema));
        Assertions.assertEquals((int)1, (int)BinaryData.compare((byte[])b2, (int)0, (byte[])b1, (int)0, (Schema)schema));
        Assertions.assertEquals((int)0, (int)BinaryData.compare((byte[])b1, (int)0, (byte[])b1, (int)0, (Schema)schema));
        Assertions.assertEquals((int)0, (int)BinaryData.compare((byte[])b2, (int)0, (byte[])b2, (int)0, (Schema)schema));
        Assertions.assertEquals((int)-1, (int)TestCompare.compare(o1, o2, schema, comparable, comparator));
        Assertions.assertEquals((int)1, (int)TestCompare.compare(o2, o1, schema, comparable, comparator));
        Assertions.assertEquals((int)0, (int)TestCompare.compare(o1, o1, schema, comparable, comparator));
        Assertions.assertEquals((int)0, (int)TestCompare.compare(o2, o2, schema, comparable, comparator));
        assert (o1.equals(o1));
        assert (o2.equals(o2));
        assert (!o1.equals(o2));
        assert (!o2.equals(o1));
        assert (!o1.equals(new Object()));
        assert (!o2.equals(new Object()));
        assert (!o1.equals(null));
        assert (!o2.equals(null));
        assert (o1.hashCode() != o2.hashCode());
        if (schema.getType() != Schema.Type.ENUM) {
            Assertions.assertEquals((int)o1.hashCode(), (int)BinaryData.hashCode((byte[])b1, (int)0, (int)b1.length, (Schema)schema));
            Assertions.assertEquals((int)o2.hashCode(), (int)BinaryData.hashCode((byte[])b2, (int)0, (int)b2.length, (Schema)schema));
        }
        Assertions.assertEquals((int)comparator.hashCode(o1, schema), (int)BinaryData.hashCode((byte[])b1, (int)0, (int)b1.length, (Schema)schema));
        Assertions.assertEquals((int)comparator.hashCode(o2, schema), (int)BinaryData.hashCode((byte[])b2, (int)0, (int)b2.length, (Schema)schema));
    }

    private static int compare(Object o1, Object o2, Schema schema, boolean comparable, GenericData comparator) {
        return comparable ? ((Comparable)o1).compareTo(o2) : comparator.compare(o1, o2, schema);
    }

    private static <T> byte[] render(T datum, Schema schema, DatumWriter<T> writer) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.setSchema(schema);
        BinaryEncoder enc = new EncoderFactory().directBinaryEncoder((OutputStream)out, null);
        writer.write(datum, (Encoder)enc);
        enc.flush();
        return out.toByteArray();
    }
}

