/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestBigDecimalConversion {
    private Conversion<BigDecimal> conversion = new Conversions.BigDecimalConversion();
    private final LogicalType bigDecimal = LogicalTypes.bigDecimal();
    private Schema bytesSchema = this.conversion.getRecommendedSchema();

    @ParameterizedTest
    @MethodSource(value={"listBigDecimal"})
    void bigdec(BigDecimal d1) {
        ByteBuffer d1bytes = this.conversion.toBytes((Object)d1, this.bytesSchema, this.bigDecimal);
        BigDecimal decimal1 = (BigDecimal)this.conversion.fromBytes(d1bytes, this.bytesSchema, this.bigDecimal);
        Assertions.assertEquals((Object)decimal1, (Object)d1);
    }

    static Stream<Arguments> listBigDecimal() {
        Iterator<BigDecimal> iterator = new Iterator<BigDecimal>(){
            int index = 0;
            BigDecimal step = new BigDecimal(-2.7);
            BigDecimal current = new BigDecimal(1.0);

            @Override
            public boolean hasNext() {
                if (this.index == 50) {
                    this.current = new BigDecimal(1.0);
                    this.step = new BigDecimal(-0.71);
                }
                return this.index < 100;
            }

            @Override
            public BigDecimal next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.index;
                this.current = this.current.multiply(this.step);
                return this.current;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

