/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonSchemaFormatterFactory;
import org.apache.avro.Schema;
import org.apache.avro.SchemaFormatter;
import org.apache.avro.SchemaFormatterFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SchemaFormatterTest {
    SchemaFormatterTest() {
    }

    @Test
    void validateDefaultNaming() {
        Assertions.assertEquals((Object)"json", (Object)new JsonSchemaFormatterFactory().formatName());
        Assertions.assertThrows(AvroRuntimeException.class, () -> new Wrongly_Named_SchemaFormatterFactory().formatName());
        Assertions.assertThrows(AvroRuntimeException.class, () -> new SchemaFormatterFactoryWithOddName().formatName());
    }

    @Test
    void validateJsonFormatDefaultsToPrettyPrinting() {
        Schema schema = Schema.createFixed((String)"ns.Fixed", null, null, (int)16);
        Assertions.assertEquals((Object)SchemaFormatter.format((String)"json", (Schema)schema), (Object)SchemaFormatter.format((String)"json/pretty", (Schema)schema));
    }

    @Test
    void validateSupportForPrettyJsonFormat() {
        Schema schema = Schema.createFixed((String)"ns.Fixed", null, null, (int)16);
        Assertions.assertEquals((Object)"{\n  \"type\" : \"fixed\",\n  \"name\" : \"Fixed\",\n  \"namespace\" : \"ns\",\n  \"size\" : 16\n}", (Object)SchemaFormatter.format((String)"json/pretty", (Schema)schema));
    }

    @Test
    void validateSupportForInlineJsonFormat() {
        Schema schema = Schema.createFixed((String)"ns.Fixed", null, null, (int)16);
        Assertions.assertEquals((Object)"{\"type\":\"fixed\",\"name\":\"Fixed\",\"namespace\":\"ns\",\"size\":16}", (Object)SchemaFormatter.format((String)"json/inline", (Schema)schema));
    }

    @Test
    void checkThatJsonHasNoExtraVariant() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> SchemaFormatter.getInstance((String)"json/extra"));
    }

    @Test
    void validateSupportForCanonicalFormat() {
        Schema schema = Schema.createFixed((String)"Fixed", (String)"Another test", (String)"ns", (int)16);
        Assertions.assertEquals((Object)"{\"name\":\"ns.Fixed\",\"type\":\"fixed\",\"size\":16}", (Object)SchemaFormatter.format((String)"canonical", (Schema)schema));
    }

    @Test
    void checkThatCanonicalFormHasNoVariants() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> SchemaFormatter.getInstance((String)"canonical/foo"));
    }

    @Test
    void checkExceptionForMissingFormat() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> SchemaFormatter.getInstance((String)"unknown"));
    }

    private static class SchemaFormatterFactoryWithOddName
    implements SchemaFormatterFactory {
        private SchemaFormatterFactoryWithOddName() {
        }

        public SchemaFormatter getDefaultFormatter() {
            return null;
        }
    }

    private static class Wrongly_Named_SchemaFormatterFactory
    implements SchemaFormatterFactory {
        private Wrongly_Named_SchemaFormatterFactory() {
        }

        public SchemaFormatter getDefaultFormatter() {
            return null;
        }
    }
}

