/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.tool.TetherTool;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestTetherTool {
    @TempDir
    public File INPUT_DIR;
    @TempDir
    public File OUTPUT_DIR;

    @Test
    void test() throws Exception {
        Schema outscheme = new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema();
        File midscfile = new File(this.INPUT_DIR.getPath(), "midschema.avpr");
        try (FileWriter hf = new FileWriter(midscfile);){
            hf.write(outscheme.toString());
        }
        JobConf job = new JobConf();
        String inputPathStr = this.INPUT_DIR.getPath();
        String outputPathStr = this.OUTPUT_DIR.getPath();
        Path outputPath = new Path(outputPathStr);
        outputPath.getFileSystem((Configuration)job).delete(outputPath, true);
        WordCountUtil.writeLinesFile((String)(inputPathStr + "/lines.avro"));
        String execargs = "-classpath " + System.getProperty("java.class.path");
        execargs = execargs + " org.apache.avro.mapred.tether.WordCountTask";
        ArrayList<String> runargs = new ArrayList<String>();
        runargs.addAll(Arrays.asList("--program", "java"));
        runargs.addAll(Arrays.asList("--exec_args", "\"" + execargs + "\""));
        runargs.addAll(Arrays.asList("--exec_cached", "false"));
        runargs.addAll(Arrays.asList("--in", inputPathStr));
        runargs.addAll(Arrays.asList("--out", outputPath.toString()));
        runargs.addAll(Arrays.asList("--outschema", midscfile.toString()));
        TetherTool tool = new TetherTool();
        tool.run(null, null, System.err, runargs);
        int numWords = 0;
        SpecificDatumReader reader = new SpecificDatumReader();
        try (BufferedInputStream cin = new BufferedInputStream(new FileInputStream(outputPathStr + "/part-00000.avro"));
             DataFileStream counts = new DataFileStream((InputStream)cin, (DatumReader)reader);){
            for (Pair wc : counts) {
                Assertions.assertEquals((Long)((Long)WordCountUtil.COUNTS.get(((Utf8)wc.key()).toString())), (Long)((Long)wc.value()), (String)((Utf8)wc.key()).toString());
                ++numWords;
            }
        }
        Assertions.assertEquals((int)WordCountUtil.COUNTS.size(), (int)numWords);
    }
}

