/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.tool.BinaryFragmentToJsonTool;
import org.apache.avro.tool.JsonToBinaryFragmentTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestJsonToFromBinaryFragmentTools {
    private static final String STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING).toString();
    private static final String UTF8 = "utf-8";
    private static final String AVRO = "ZLong string implies readable length encoding.";
    private static final String JSON = "\"Long string implies readable length encoding.\"\n";
    @TempDir
    public File DIR;

    @Test
    void binaryToJson() throws Exception {
        this.binaryToJson(AVRO, JSON, STRING_SCHEMA);
    }

    @Test
    void jsonToBinary() throws Exception {
        this.jsonToBinary(JSON, AVRO, STRING_SCHEMA);
    }

    @Test
    void multiBinaryToJson() throws Exception {
        this.binaryToJson("ZLong string implies readable length encoding.ZLong string implies readable length encoding.ZLong string implies readable length encoding.", "\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n", STRING_SCHEMA);
    }

    @Test
    void multiJsonToBinary() throws Exception {
        this.jsonToBinary("\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n", "ZLong string implies readable length encoding.ZLong string implies readable length encoding.ZLong string implies readable length encoding.", STRING_SCHEMA);
    }

    @Test
    void binaryToNoPrettyJson() throws Exception {
        this.binaryToJson(AVRO, JSON, "--no-pretty", STRING_SCHEMA);
    }

    @Test
    void multiBinaryToNoPrettyJson() throws Exception {
        this.binaryToJson("ZLong string implies readable length encoding.ZLong string implies readable length encoding.ZLong string implies readable length encoding.", "\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n", "--no-pretty", STRING_SCHEMA);
    }

    @Test
    void binaryToJsonSchemaFile() throws Exception {
        this.binaryToJson(AVRO, JSON, "--schema-file", TestJsonToFromBinaryFragmentTools.schemaFile(this.DIR));
    }

    @Test
    void jsonToBinarySchemaFile() throws Exception {
        this.jsonToBinary(JSON, AVRO, "--schema-file", TestJsonToFromBinaryFragmentTools.schemaFile(this.DIR));
    }

    private void binaryToJson(String avro, String json, String ... options) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(new BufferedOutputStream(baos));
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(options));
        args.add("-");
        new BinaryFragmentToJsonTool().run((InputStream)new ByteArrayInputStream(avro.getBytes(StandardCharsets.UTF_8)), p, null, args);
        System.out.println(baos.toString(UTF8).replace("\r", ""));
        Assertions.assertEquals((Object)json, (Object)baos.toString(UTF8).replace("\r", ""));
    }

    private void jsonToBinary(String json, String avro, String ... options) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(new BufferedOutputStream(baos));
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(options));
        args.add("-");
        new JsonToBinaryFragmentTool().run((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), p, null, args);
        Assertions.assertEquals((Object)avro, (Object)baos.toString(UTF8));
    }

    private static String schemaFile(File dir) throws IOException {
        File schemaFile = new File(dir, "String.avsc");
        try (FileWriter fw = new FileWriter(schemaFile);){
            fw.append(STRING_SCHEMA);
        }
        return schemaFile.toString();
    }
}

