/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.DataFileGetMetaTool;
import org.apache.avro.tool.DataFileGetSchemaTool;
import org.apache.avro.tool.DataFileReadTool;
import org.apache.avro.tool.DataFileWriteTool;
import org.apache.avro.tool.Tool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDataFileTools {
    static final int COUNT = 15;
    static File sampleFile;
    static String jsonData;
    static Schema schema;
    static File schemaFile;
    private static final String KEY_NEEDING_ESCAPES = "trn\\\r\t\n";
    private static final String ESCAPED_KEY = "trn\\\\\\r\\t\\n";
    @TempDir
    public static File DIR;

    @BeforeAll
    public static void writeSampleFile() throws IOException {
        sampleFile = new File(DIR, TestDataFileTools.class.getName() + ".avro");
        schema = Schema.create((Schema.Type)Schema.Type.INT);
        schemaFile = new File(DIR, "schema-temp.schema");
        try (FileWriter fw = new FileWriter(schemaFile);){
            fw.append(schema.toString());
        }
        StringBuilder builder = new StringBuilder();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.setMeta(KEY_NEEDING_ESCAPES, "");
            writer.create(schema, sampleFile);
            for (int i = 0; i < 15; ++i) {
                builder.append(Integer.toString(i));
                builder.append("\n");
                writer.append((Object)i);
            }
        }
        jsonData = builder.toString();
    }

    private String run(Tool tool, String ... args) throws Exception {
        return this.run(tool, (InputStream)null, args);
    }

    private String run(Tool tool, InputStream stdin, String ... args) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(baos);
        tool.run(stdin, p, null, Arrays.asList(args));
        return baos.toString("UTF-8").replace("\r", "");
    }

    @Test
    void read() throws Exception {
        Assertions.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), sampleFile.getPath()));
    }

    @Test
    void readStdin() throws Exception {
        FileInputStream stdin = new FileInputStream(sampleFile);
        Assertions.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), stdin, "-"));
    }

    @Test
    void readToJsonPretty() throws Exception {
        Assertions.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), "--pretty", sampleFile.getPath()));
    }

    @Test
    void readWithReaderSchema() throws Exception {
        Assertions.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), "--reader-schema", "\"long\"", sampleFile.getPath()));
    }

    @Test
    void readWithIncompatibleReaderSchema() throws Exception {
        Assertions.assertThrows(AvroTypeException.class, () -> this.run((Tool)new DataFileReadTool(), "--reader-schema", "\"string\"", sampleFile.getPath()));
    }

    @Test
    void readWithReaderSchemaFile() throws Exception {
        File readerSchemaFile = new File(DIR, "reader-schema-temp.schema");
        try (FileWriter fw = new FileWriter(readerSchemaFile);){
            fw.append("\"long\"");
        }
        Assertions.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), "--reader-schema-file", readerSchemaFile.getPath(), sampleFile.getPath()));
    }

    @Test
    void readHeadDefaultCount() throws Exception {
        String expectedJson = jsonData.substring(0, 20);
        Assertions.assertEquals((Object)expectedJson, (Object)this.run((Tool)new DataFileReadTool(), "--head", sampleFile.getPath()));
    }

    @Test
    void readHeadEquals3Count() throws Exception {
        String expectedJson = jsonData.substring(0, 6);
        Assertions.assertEquals((Object)expectedJson, (Object)this.run((Tool)new DataFileReadTool(), "--head=3", sampleFile.getPath()));
    }

    @Test
    void readHeadSpace5Count() throws Exception {
        String expectedJson = jsonData.substring(0, 10);
        Assertions.assertEquals((Object)expectedJson, (Object)this.run((Tool)new DataFileReadTool(), "--head", "5", sampleFile.getPath()));
    }

    @Test
    void readHeadLongCount() throws Exception {
        Assertions.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), "--head=3000000000", sampleFile.getPath()));
    }

    @Test
    void readHeadEqualsZeroCount() throws Exception {
        Assertions.assertEquals((Object)"\n", (Object)this.run((Tool)new DataFileReadTool(), "--head=0", sampleFile.getPath()));
    }

    @Test
    void readHeadNegativeCount() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> Assertions.assertEquals((Object)"\n", (Object)this.run((Tool)new DataFileReadTool(), "--head=-5", sampleFile.getPath())));
    }

    @Test
    void getMeta() throws Exception {
        String output = this.run((Tool)new DataFileGetMetaTool(), sampleFile.getPath());
        Assertions.assertTrue((boolean)output.contains("avro.schema\t" + schema.toString() + "\n"), (String)output);
        Assertions.assertTrue((boolean)output.contains("trn\\\\\\r\\t\\n\t\n"), (String)output);
    }

    @Test
    void getMetaForSingleKey() throws Exception {
        Assertions.assertEquals((Object)(schema.toString() + "\n"), (Object)this.run((Tool)new DataFileGetMetaTool(), sampleFile.getPath(), "--key", "avro.schema"));
    }

    @Test
    void getSchema() throws Exception {
        Assertions.assertEquals((Object)(schema.toString() + "\n"), (Object)this.run((Tool)new DataFileGetSchemaTool(), sampleFile.getPath()));
    }

    @Test
    void writeWithDeflate() throws Exception {
        this.testWrite("deflate", Arrays.asList("--codec", "deflate"), "deflate");
    }

    @Test
    void write() throws Exception {
        this.testWrite("plain", Collections.emptyList(), "null");
    }

    public void testWrite(String name, List<String> extra, String expectedCodec) throws Exception {
        this.testWrite(name, extra, expectedCodec, "-schema", schema.toString());
        this.testWrite(name, extra, expectedCodec, "-schema-file", schemaFile.toString());
    }

    public void testWrite(String name, List<String> extra, String expectedCodec, String ... extraArgs) throws Exception {
        File outFile = new File(DIR, TestDataFileTools.class + ".testWrite." + name + ".avro");
        try (FileOutputStream fout = new FileOutputStream(outFile);
             PrintStream out = new PrintStream(fout);){
            ArrayList<String> args = new ArrayList<String>();
            Collections.addAll(args, extraArgs);
            args.add("-");
            args.addAll(extra);
            new DataFileWriteTool().run((InputStream)new ByteArrayInputStream(jsonData.getBytes("UTF-8")), new PrintStream(out), null, args);
        }
        GenericDatumReader reader = new GenericDatumReader();
        try (DataFileReader fileReader = new DataFileReader(outFile, (DatumReader)reader);){
            int i = 0;
            for (Object datum : fileReader) {
                Assertions.assertEquals((Object)i, datum);
                ++i;
            }
            Assertions.assertEquals((int)15, (int)i);
            Assertions.assertEquals((Object)schema, (Object)fileReader.getSchema());
            String codecStr = fileReader.getMetaString("avro.codec");
            if (null == codecStr) {
                codecStr = "null";
            }
            Assertions.assertEquals((Object)expectedCodec, (Object)codecStr);
        }
    }

    @Test
    void failureOnWritingPartialJSONValues() throws Exception {
        Assertions.assertThrows(IOException.class, () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(baos);
            new DataFileWriteTool().run((InputStream)new ByteArrayInputStream("{".getBytes("UTF-8")), new PrintStream(out), null, Arrays.asList("-schema", "{ \"type\":\"record\", \"fields\":[{\"name\":\"foo\", \"type\":\"string\"}], \"name\":\"boring\" }", "-"));
        });
    }

    @Test
    void writingZeroJsonValues() throws Exception {
        File outFile = this.writeToAvroFile("zerojsonvalues", schema.toString(), "");
        Assertions.assertEquals((int)0, (int)this.countRecords(outFile));
    }

    private int countRecords(File outFile) throws IOException {
        GenericDatumReader reader = new GenericDatumReader();
        try (DataFileReader fileReader = new DataFileReader(outFile, (DatumReader)reader);){
            int i = 0;
            for (Object datum : fileReader) {
                ++i;
            }
            int n = i;
            return n;
        }
    }

    @Test
    void differentSeparatorsBetweenJsonRecords() throws Exception {
        File outFile = this.writeToAvroFile("separators", "{ \"type\":\"array\", \"items\":\"int\" }", "[]    [] []\n[][3]     ");
        Assertions.assertEquals((int)5, (int)this.countRecords(outFile));
    }

    public File writeToAvroFile(String testName, String schema, String json) throws Exception {
        File outFile = new File(DIR, TestDataFileTools.class + "." + testName + ".avro");
        try (FileOutputStream fout = new FileOutputStream(outFile);
             PrintStream out = new PrintStream(fout);){
            new DataFileWriteTool().run((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")), new PrintStream(out), null, Arrays.asList("-schema", schema, "-"));
        }
        return outFile;
    }

    @Test
    void defaultCodec() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(baos);
        new DataFileWriteTool().run((InputStream)new ByteArrayInputStream(jsonData.getBytes()), null, err, Collections.emptyList());
        Assertions.assertTrue((boolean)baos.toString().contains("Compression codec (default: null)"));
    }
}

