/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.lang.reflect.Method;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.ZstandardCodec;
import org.apache.avro.tool.Util;
import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.rules.TestName;

public class TestUtil {
    @Rule
    public TestName name = new TestName();

    private void zstandardCompressionLevel(int level) throws Exception {
        OptionParser optParser = new OptionParser();
        OptionSpec codecOpt = Util.compressionCodecOption((OptionParser)optParser);
        OptionSpec levelOpt = Util.compressionLevelOption((OptionParser)optParser);
        OptionSet opts = optParser.parse(new String[]{"--codec", "zstandard", "--level", String.valueOf(level)});
        CodecFactory codecFactory = Util.codecFactory((OptionSet)opts, (OptionSpec)codecOpt, (OptionSpec)levelOpt);
        Method createInstance = CodecFactory.class.getDeclaredMethod("createInstance", new Class[0]);
        createInstance.setAccessible(true);
        ZstandardCodec codec = (ZstandardCodec)createInstance.invoke((Object)codecFactory, new Object[0]);
        Assertions.assertEquals((Object)String.format("zstandard[%d]", level), (Object)codec.toString());
    }

    @Test
    void codecFactoryZstandardCompressionLevel() throws Exception {
        this.zstandardCompressionLevel(1);
        this.zstandardCompressionLevel(3);
    }
}

