/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.ToTrevniTool;
import org.apache.avro.util.RandomData;
import org.apache.trevni.avro.AvroColumnReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestToTrevniTool {
    private static final long SEED = System.currentTimeMillis();
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "200"));
    @TempDir
    private Path dataDir;
    private static final File SCHEMA_FILE = new File("../../../share/test/schemas/weather.avsc");

    private String run(String ... args) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(baos);
        new ToTrevniTool().run(null, p, null, Arrays.asList(args));
        return baos.toString("UTF-8").replace("\r", "");
    }

    @Test
    void test() throws Exception {
        Schema schema = new Schema.Parser().parse(SCHEMA_FILE);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        File avroFile = this.dataDir.resolve("random.avro").toFile();
        writer.create(schema, avroFile);
        for (Object datum : new RandomData(schema, COUNT, SEED)) {
            writer.append(datum);
        }
        writer.close();
        File trevniFile = this.dataDir.resolve("random.trv").toFile();
        this.run(avroFile.toString(), trevniFile.toString());
        AvroColumnReader reader = new AvroColumnReader(new AvroColumnReader.Params(trevniFile));
        Iterator found = reader.iterator();
        for (Object expected : new RandomData(schema, COUNT, SEED)) {
            Assertions.assertEquals(expected, found.next());
        }
        reader.close();
    }
}

