/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.tool.FromTextTool;
import org.apache.avro.tool.ToTextTool;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestTextFileTools {
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "10"));
    private static final byte[] LINE_SEP = System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
    private static File linesFile;
    private static ByteBuffer[] lines;
    static Schema schema;
    @TempDir
    public static File DIR;

    @BeforeAll
    public static void writeRandomFile() throws IOException {
        schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        lines = new ByteBuffer[COUNT];
        linesFile = new File(DIR, "random.lines");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(linesFile));
        Random rand = new Random();
        for (int j = 0; j < COUNT; ++j) {
            byte[] line = new byte[rand.nextInt(512)];
            System.out.println("Creating line = " + line.length);
            for (int i = 0; i < line.length; ++i) {
                int b = rand.nextInt(256);
                while (b == 10 || b == 13) {
                    b = rand.nextInt(256);
                }
                line[i] = (byte)b;
            }
            ((OutputStream)out).write(line);
            ((OutputStream)out).write(LINE_SEP);
            TestTextFileTools.lines[j] = ByteBuffer.wrap(line);
        }
        ((OutputStream)out).close();
    }

    private void fromText(String name, String ... args) throws Exception {
        File avroFile = new File(DIR, name + ".avro");
        ArrayList<String> arglist = new ArrayList<String>(Arrays.asList(args));
        arglist.add(linesFile.toString());
        arglist.add(avroFile.toString());
        new FromTextTool().run(null, null, null, arglist);
        DataFileReader file = new DataFileReader(avroFile, (DatumReader)new GenericDatumReader());
        int i = 0;
        for (ByteBuffer line : file) {
            System.out.println("Reading line = " + line.remaining());
            Assertions.assertEquals((Object)line, (Object)lines[i]);
            ++i;
        }
        Assertions.assertEquals((int)COUNT, (int)i);
        file.close();
    }

    @Test
    void fromText() throws Exception {
        this.fromText("null", "--codec", "null");
        this.fromText("deflate", "--codec", "deflate");
        this.fromText("snappy", "--codec", "snappy");
    }

    @AfterAll
    public static void testToText() throws Exception {
        TestTextFileTools.toText("null");
        TestTextFileTools.toText("deflate");
        TestTextFileTools.toText("snappy");
    }

    private static void toText(String name) throws Exception {
        File avroFile = new File(DIR, name + ".avro");
        File outFile = new File(DIR, name + ".lines");
        ArrayList<String> arglist = new ArrayList<String>();
        arglist.add(avroFile.toString());
        arglist.add(outFile.toString());
        new ToTextTool().run(null, null, null, arglist);
        try (BufferedInputStream orig = new BufferedInputStream(new FileInputStream(linesFile));
             BufferedInputStream after = new BufferedInputStream(new FileInputStream(outFile));){
            int b;
            while ((b = ((InputStream)orig).read()) != -1) {
                Assertions.assertEquals((int)b, (int)((InputStream)after).read());
            }
            Assertions.assertEquals((int)-1, (int)((InputStream)after).read());
        }
    }

    @Test
    void defaultCodec() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(baos);
        new FromTextTool().run(null, null, err, Collections.emptyList());
        Assertions.assertTrue((boolean)baos.toString().contains("Compression codec (default: deflate)"));
    }
}

