/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.avro.tool.SpecificCompilerTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSpecificCompilerTool {
    private static final File TEST_DIR = new File(System.getProperty("test.compile.schema.dir", "src/test/compiler"));
    private static final File TEST_INPUT_DIR = new File(TEST_DIR, "input");
    private static final File TEST_EXPECTED_OUTPUT_DIR = new File(TEST_DIR, "output");
    private static final File TEST_EXPECTED_POSITION = new File(TEST_EXPECTED_OUTPUT_DIR, "Position.java");
    private static final File TEST_EXPECTED_PLAYER = new File(TEST_EXPECTED_OUTPUT_DIR, "Player.java");
    private static final File TEST_EXPECTED_NO_SETTERS = new File(TEST_EXPECTED_OUTPUT_DIR, "NoSettersTest.java");
    private static final File TEST_EXPECTED_OPTIONAL_GETTERS_FOR_NULLABLE_FIELDS = new File(TEST_EXPECTED_OUTPUT_DIR, "OptionalGettersNullableFieldsTest.java");
    private static final File TEST_EXPECTED_OPTIONAL_GETTERS_FOR_ALL_FIELDS = new File(TEST_EXPECTED_OUTPUT_DIR, "OptionalGettersAllFieldsTest.java");
    private static final File TEST_EXPECTED_ADD_EXTRA_OPTIONAL_GETTERS = new File(TEST_EXPECTED_OUTPUT_DIR, "AddExtraOptionalGettersTest.java");
    private static final File TEST_EXPECTED_STRING_OUTPUT_DIR = new File(TEST_DIR, "output-string");
    private static final File TEST_EXPECTED_STRING_POSITION = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/Position.java");
    private static final File TEST_EXPECTED_STRING_PLAYER = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/Player.java");
    private static final File TEST_EXPECTED_STRING_NULL_SAFE_ANNOTATIONS_TEST = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/NullSafeAnnotationsFieldsTest.java");
    private static final File TEST_EXPECTED_STRING_FIELDTEST = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/FieldTest.java");
    private static final File TEST_EXPECTED_STRING_PROTO = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/Proto.java");
    private static final File TEST_OUTPUT_DIR = new File("target/compiler/output");
    private static final File TEST_OUTPUT_PLAYER = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/Player.java");
    private static final File TEST_OUTPUT_POSITION = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/Position.java");
    private static final File TEST_OUTPUT_NO_SETTERS = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/NoSettersTest.java");
    private static final File TEST_OUTPUT_OPTIONAL_GETTERS_NULLABLE_FIELDS = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/OptionalGettersNullableFieldsTest.java");
    private static final File TEST_OUTPUT_OPTIONAL_GETTERS_ALL_FIELDS = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/OptionalGettersAllFieldsTest.java");
    private static final File TEST_OUTPUT_ADD_EXTRA_OPTIONAL_GETTERS = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/AddExtraOptionalGettersTest.java");
    private static final File TEST_OUTPUT_STRING_DIR = new File("target/compiler/output-string");
    private static final File TEST_OUTPUT_STRING_PLAYER = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/Player.java");
    private static final File TEST_OUTPUT_STRING_POSITION = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/Position.java");
    private static final File TEST_OUTPUT_STRING_FIELDTEST = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/FieldTest.java");
    private static final File TEST_OUTPUT_STRING_NULL_SAFE_ANNOTATIONS_TEST = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/NullSafeAnnotationsFieldsTest.java");
    private static final File TEST_OUTPUT_STRING_PROTO = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/Proto.java");

    @BeforeEach
    public void setUp() {
        TEST_OUTPUT_DIR.delete();
    }

    @Test
    void compileSchemaWithExcludedSetters() throws Exception {
        TEST_OUTPUT_NO_SETTERS.delete();
        this.doCompile(new String[]{"-encoding", "UTF-8", "-noSetters", "schema", TEST_INPUT_DIR.toString() + "/nosetterstest.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_NO_SETTERS, TEST_OUTPUT_NO_SETTERS);
    }

    @Test
    void compileSchemaWithOptionalGettersForNullableFieldsOnly() throws Exception {
        TEST_OUTPUT_OPTIONAL_GETTERS_NULLABLE_FIELDS.delete();
        this.doCompile(new String[]{"-encoding", "UTF-8", "-optionalGetters", "only_nullable_fields", "schema", TEST_INPUT_DIR.toString() + "/optionalgettersnullablefieldstest.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_OPTIONAL_GETTERS_FOR_NULLABLE_FIELDS, TEST_OUTPUT_OPTIONAL_GETTERS_NULLABLE_FIELDS);
    }

    @Test
    void compileSchemaWithNullSafeAnnotationsFields() throws Exception {
        TEST_OUTPUT_STRING_NULL_SAFE_ANNOTATIONS_TEST.delete();
        this.doCompile(new String[]{"-encoding", "UTF-8", "-nullSafeAnnotations", "-string", "schema", TEST_INPUT_DIR.toString() + "/nullsafeannotationsfieldstest.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_NULL_SAFE_ANNOTATIONS_TEST, TEST_OUTPUT_STRING_NULL_SAFE_ANNOTATIONS_TEST);
    }

    @Test
    void compileSchemaWithOptionalGettersForAllFields() throws Exception {
        TEST_OUTPUT_OPTIONAL_GETTERS_ALL_FIELDS.delete();
        this.doCompile(new String[]{"-encoding", "UTF-8", "-optionalGetters", "all_fields", "schema", TEST_INPUT_DIR.toString() + "/optionalgettersallfieldstest.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_OPTIONAL_GETTERS_FOR_ALL_FIELDS, TEST_OUTPUT_OPTIONAL_GETTERS_ALL_FIELDS);
    }

    @Test
    void compileSchemaWithAddExtraOptionalGetters() throws Exception {
        TEST_OUTPUT_ADD_EXTRA_OPTIONAL_GETTERS.delete();
        this.doCompile(new String[]{"-encoding", "UTF-8", "-addExtraOptionalGetters", "schema", TEST_INPUT_DIR.toString() + "/addextraoptionalgetterstest.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_ADD_EXTRA_OPTIONAL_GETTERS, TEST_OUTPUT_ADD_EXTRA_OPTIONAL_GETTERS);
    }

    @Test
    void compileSchemaSingleFile() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "schema", TEST_INPUT_DIR.toString() + "/position.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_POSITION, TEST_OUTPUT_POSITION);
    }

    @Test
    void compileSchemaTwoFiles() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "schema", TEST_INPUT_DIR.toString() + "/position.avsc", TEST_INPUT_DIR.toString() + "/player.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_POSITION, TEST_OUTPUT_POSITION);
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_PLAYER, TEST_OUTPUT_PLAYER);
    }

    @Test
    void compileSchemaFileAndDirectory() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "schema", TEST_INPUT_DIR.toString() + "/position.avsc", TEST_INPUT_DIR.toString(), TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_POSITION, TEST_OUTPUT_POSITION);
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_PLAYER, TEST_OUTPUT_PLAYER);
    }

    @Test
    void compileSchemasUsingString() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "-string", "schema", TEST_INPUT_DIR.toString() + "/position.avsc", TEST_INPUT_DIR.toString() + "/player.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_POSITION, TEST_OUTPUT_STRING_POSITION);
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_PLAYER, TEST_OUTPUT_STRING_PLAYER);
    }

    @Test
    void compileSchemasWithVariousFieldTypes() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "-string", "schema", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_FIELDTEST, TEST_OUTPUT_STRING_FIELDTEST);
    }

    @Test
    void orderingOfFlags() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "-string", "-bigDecimal", "schema", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_FIELDTEST, TEST_OUTPUT_STRING_FIELDTEST);
        this.doCompile(new String[]{"-string", "-encoding", "UTF-8", "-bigDecimal", "schema", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_FIELDTEST, TEST_OUTPUT_STRING_FIELDTEST);
        this.doCompile(new String[]{"-bigDecimal", "-encoding", "UTF-8", "-string", "schema", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_FIELDTEST, TEST_OUTPUT_STRING_FIELDTEST);
        this.doCompile(new String[]{"-bigDecimal", "-string", "-encoding", "UTF-8", "schema", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_INPUT_DIR.toString() + "/fieldtest.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_FIELDTEST, TEST_OUTPUT_STRING_FIELDTEST);
    }

    @Test
    void compileProtocol() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "protocol", TEST_INPUT_DIR.toString() + "/proto.avpr", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_PROTO, TEST_OUTPUT_STRING_PROTO);
    }

    private void doCompile(String[] args) throws Exception {
        SpecificCompilerTool tool = new SpecificCompilerTool();
        tool.run(null, null, null, Arrays.asList(args));
    }

    private static void assertFileMatch(File expected, File found) throws IOException {
        Assertions.assertEquals((Object)TestSpecificCompilerTool.readFile(expected), (Object)TestSpecificCompilerTool.readFile(found), (String)("Found file: " + found + " does not match expected file: " + expected));
    }

    private static String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        String line = null;
        boolean first = true;
        while ((line = reader.readLine()) != null) {
            if (!first) {
                sb.append("\n");
                first = false;
            }
            sb.append(line);
        }
        reader.close();
        return sb.toString();
    }
}

