/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.avro.tool.RpcReceiveTool;
import org.apache.avro.tool.RpcSendTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRpcReceiveAndSendTools {
    @Test
    void serveAndSend() throws Exception {
        String protocolFile = System.getProperty("share.dir", "../../../share") + "/test/schemas/simple.avpr";
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        PrintStream p1 = new PrintStream(baos1);
        RpcReceiveTool receive = new RpcReceiveTool();
        receive.run1(null, p1, System.err, Arrays.asList("http://0.0.0.0:0/", protocolFile, "hello", "-data", "\"Hello!\""));
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        PrintStream p2 = new PrintStream(baos2);
        RpcSendTool send = new RpcSendTool();
        send.run(null, p2, System.err, Arrays.asList("http://127.0.0.1:" + receive.server.getPort() + "/", protocolFile, "hello", "-data", "{ \"greeting\": \"Hi!\" }"));
        receive.run2(System.err);
        Assertions.assertTrue((boolean)baos1.toString("UTF-8").replace("\r", "").endsWith("hello\t{\"greeting\":\"Hi!\"}\n"));
        Assertions.assertEquals((Object)"\"Hello!\"\n", (Object)baos2.toString("UTF-8").replace("\r", ""));
    }
}

